package com.biz.crm.tpm.business.activity.form.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;


/**
 * @author ：dengwei
 * @date ：Created in 2022/10/24 17:17
 * @description：活动形式
 */
@ApiModel(value = "ActivityForm", description = "活动形式")
@TableName("tpm_activity_form")
@Getter
@Setter
@Entity(name = "tpm_activity_form")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_form", comment = "活动形式")
@Table(name = "tpm_activity_form")
public class ActivityForm extends TenantFlagOpEntity {

    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    @Column(name = "activity_form_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '活动形式名称'")
    private String activityFormName;

    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    @Column(name = "activity_form_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动形式Code'")
    private String activityFormCode;

    @ApiModelProperty(name = "会计科目编码", notes = "会计科目编码")
    @Column(name = "accountant_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '会计科目编码 '")
    private String accountantCode;

    @ApiModelProperty(name = "会计科目名称", notes = "会计科目名称")
    @Column(name = "accountant_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '会计科目名称'")
    private String accountantName;

    @ApiModelProperty(name = "业态", notes = "业态")
    @Column(name = "business_format_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "分摊费用到产品", notes = "分摊费用到产品")
    @Column(name = "allocation_fee_to_product",  length = 1, columnDefinition = "char(1) COMMENT '分摊费用到产品 '")
    private Boolean allocationFeeToProduct;

    @ApiModelProperty(name = "是否为商超扣费项", notes = "是否为商超扣费项")
    @Column(name = "is_supermarket_deduction_item",  length = 1, columnDefinition = "char(1) COMMENT '是否为商超扣费项 '")
    private Boolean isSupermarketDeductionItem;

    @ApiModelProperty("是否和价格相关")
    @Column(name = "is_relate_price",  length = 1, columnDefinition = "char(1) COMMENT '是否和价格相关'")
    private Boolean isRelatePrice;

    @ApiModelProperty("差异费用处理模版")
    @Column(name = "diff_cost_dispose_template",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '差异费用处理模版'")
    private String diffCostDisposeTemplate;

    @ApiModelProperty("利润表项目")
    @Column(name = "profit_table_item",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '利润表项目'")
    private String profitTableItem;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    @Column(name = "business_unit_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "业务单元名称", notes = "业务单元名称")
    @Column(name = "business_unit_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '业务单元名称'")
    private String businessUnitName;

    @ApiModelProperty(name = "选择细案模版", notes = "选择细案模版")
    @Column(name = "thin_project_template",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '选择细案模版'")
    private String thinProjectTemplate;

    @ApiModelProperty(name = "结案方式", notes = "结案方式")
    @Column(name = "audit_way_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '结案方式'")
    private String auditWayCode;

    @ApiModelProperty(name = "结案方式名称", notes = "结案方式名称")
    @Column(name = "audit_way_name",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '结案方式名称'")
    private String auditWayName;

    @ApiModelProperty(name = "是否推送巡查系统", notes = "是否推送巡查系统")
    @Column(name = "is_push_patrol_system",  length = 1, columnDefinition = "CHAR(1) COMMENT '是否推送巡查系统 '")
    private Boolean isPushPatrolSystem;

    @ApiModelProperty(name = "是否自动核销", notes = "是否自动核销")
    @Column(name = "is_auto_audit",  length = 1, columnDefinition = "CHAR(1) COMMENT '是否自动核销 '")
    private Boolean isAutoAudit;

    @ApiModelProperty("是否允许超额核销")
    @Column(name = "is_allow_excess_audit",  length = 1, columnDefinition = "CHAR(1) COMMENT '是否允许超额核销'")
    private Boolean isAllowExcessAudit;

    @ApiModelProperty(name = "选择巡查系统", notes = "选择巡查系统")
    @Column(name = "select_patrol_system_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '选择巡查系统'")
    private String selectPatrolSystemCode;

    @ApiModelProperty(name = "允许多次核销", notes = "允许多次核销")
    @Column(name = "is_more_audit",  length = 1, columnDefinition = "CHAR(1) COMMENT '允许多次核销'")
    private Boolean isMoreAudit;


    @ApiModelProperty(name = "核销有效期（月）", notes = "核销有效期（月）")
    @Column(name = "audit_valid_date",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销有效期（月）'")
    private String auditValidDate;

    @ApiModelProperty(name = "核销条件", notes = "核销条件")
    @Column(name = "audit_condition",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销条件（月）'")
    private String auditCondition;

    @ApiModelProperty("申请维度")
    @Column(name = "apply_dimensionality",  length = 256, columnDefinition = "VARCHAR(256) COMMENT '申请维度'")
    private String applyDimensionality;

    @ApiModelProperty("sap编码")
    @Column(name = "sap_code",  length = 32, columnDefinition = "VARCHAR(32) COMMENT 'sap编码'")
    private String sapCode;

    @ApiModelProperty("垂直活动类型")
    @Column(name = "vertical_activity_type",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '垂直活动类型'")
    private String verticalActivityType;

    @ApiModelProperty("对应主体活动形式编码（分子活动形式使用）")
    @Column(name = "sub_main_activity_form_code",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '对应主体活动形式编码'")
    private String subMainActivityFormCode;

    @ApiModelProperty("拆分客户数据源")
    @Column(name = "split_customer_data_source",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '拆分客户数据源'")
    private String splitCustomerDataSource;

}
