package com.biz.crm.tpm.business.activity.form.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author ：dengwei
 * @date ：Created in 2022/10/25 10:33
 * @description：活动形式的核销资料
 */
@ApiModel(value = "ActivityFormAudit", description = "活动形式的核销资料")
@TableName("tpm_activity_form_audit")
@Getter
@Setter
@Entity(name = "tpm_activity_form_audit")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_form_audit", comment = "活动形式的核销资料")
@Table(name = "tpm_activity_form_audit",
        indexes = {@Index(name = "tpm_activity_form_audit_idx1", columnList = "activity_form_code", unique = false),
                @Index(name = "tpm_activity_form_audit_idx2", columnList = "audit_data_code", unique = false),
        })
public class ActivityFormAudit extends TenantFlagOpEntity {

    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    @Column(name = "activity_form_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动形式Code'")
    private String activityFormCode;

    @ApiModelProperty(name = "核销资料code（示例编码）", notes = "核销资料code（示例编码）")
    @Column(name = "audit_data_code", length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销资料code（示例编码）'")
    private String auditDataCode;
}
