package com.biz.crm.tpm.business.activity.form.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/5 17:49
 * @description：活动形式照片采集
 */
@ApiModel(value = "ActivityFormCollect", description = "活动形式照片采集")
@TableName("tpm_activity_form_collect")
@Getter
@Setter
@Entity(name = "tpm_activity_form_collect")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_form_collect", comment = "活动形式照片采集")
@Table(name = "tpm_activity_form_collect")
public class ActivityFormCollect extends TenantFlagOpEntity {

    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    @Column(name = "activity_form_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动形式Code'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动执行控制明细id", notes = "活动执行控制明细id")
    @Column(name = "activity_form_exe_detail_id",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动执行控制明细id'")
    private String activityFormExeDetailId;

    @ApiModelProperty(name = "照片采集code（示例编码）", notes = "照片采集code（示例编码）")
    @Column(name = "collect_data_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '照片采集code（示例编码）'")
    private String collectDataCode;
}
