package com.biz.crm.tpm.business.activity.form.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Table;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/7 13:39
 * @description：活动采集字段
 */
@ApiModel(value = "ActivityFormCollectField", description = "活动采集字段")
@TableName("tpm_activity_form_collect_field")
@Getter
@Setter
@Entity(name = "tpm_activity_form_collect_field")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_form_collect_field", comment = "活动采集字段")
@Table(name = "tpm_activity_form_collect_field")
public class ActivityFormCollectField extends TenantFlagOpEntity {

    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    @Column(name = "activity_form_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动形式Code'")
    private String activityFormCode;

    @ApiModelProperty(name = "活动执行控制明细id", notes = "活动执行控制明细id")
    @Column(name = "activity_form_exe_detail_id",  length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动执行控制明细id'")
    private String activityFormExeDetailId;

    @ApiModelProperty(name = "字段编码", notes = "字段编码")
    @Column(name = "field_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '字段编码'")
    private String fieldCode;

    @ApiModelProperty(name = "字段名称", notes = "字段名称")
    @Column(name = "field_name",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '字段名称'")
    private String fieldName;

    @ApiModelProperty(name = "是否必填", notes = "是否必填")
    @Column(name = "is_must",  length = 255, columnDefinition = "CHAR(1) COMMENT '是否必填'")
    private Boolean isMust;

    @ApiModelProperty(name = "顺序", notes = "顺序")
    @Column(name = "the_order", columnDefinition = "int(4) COMMENT '顺序'")
    private Integer theOrder;
}
