package com.biz.crm.tpm.business.activity.form.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/28 11:52
 * @description：活动形式活动执行明细
 */
@ApiModel(value = "ActivityFormExeDetail", description = "活动形式活动执行明细")
@TableName("tpm_activity_form_exe_detail")
@Getter
@Setter
@Entity(name = "tpm_activity_form_exe_detail")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_form_exe_detail", comment = "活动形式活动执行明细")
@Table(name = "tpm_activity_form_exe_detail", indexes = {
        @Index(name = "tpm_activity_form_exe_detail_idx1", columnList = "activity_form_code", unique = false),
})
public class ActivityFormExeDetail extends TenantFlagOpEntity {

    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    @Column(name = "activity_form_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '活动形式Code'")
    private String activityFormCode;

    @ApiModelProperty(name = "核销方式", notes = "核销方式")
    @Column(name = "audit_type",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '核销方式'")
    private String auditType;

    @ApiModelProperty(name = "是否推送其他平台执行", notes = "是否推送其他平台执行")
    @Column(name = "is_push_other_platform_exe",  length = 1, columnDefinition = "char(1) COMMENT '是否推送其他平台执行 '")
    private Boolean isPushOtherPlatformExe;

    @ApiModelProperty(name = "选择推送执行系统", notes = "选择推送执行系统")
    @Column(name = "push_exe_system_code",  length = 128, columnDefinition = "VARCHAR(128) COMMENT '选择推送执行系统 '")
    private String pushExeSystemCode;

    @ApiModelProperty(name = "是否采集活动数据", notes = "是否采集活动数据")
    @Column(name = "is_collect_activity_data",  length = 1, columnDefinition = "CHAR(1) COMMENT '是否采集活动数据 '")
    private Boolean isCollectActivityData;

    @ApiModelProperty(name = "是否采集照片", notes = "是否采集照片")
    @Column(name = "is_collect_picture",  length = 1, columnDefinition = "CHAR(1) COMMENT '是否采集照片 '")
    private Boolean isCollectPicture;

    @ApiModelProperty(name = "是否采集分销订单", notes = "是否采集分销订单")
    @Column(name = "is_collect_distribution_order",  length = 1, columnDefinition = "CHAR(1) COMMENT '是否采集分销订单 '")
    private Boolean isCollectDistributionOrder;

    @ApiModelProperty(name = "是否控制活动费用", notes = "是否控制活动费用")
    @Column(name = "is_collect_activity_fee",  length = 1, columnDefinition = "CHAR(1) COMMENT '是否控制活动费用 '")
    private Boolean isCollectActivityFee;
}
