package com.biz.crm.tpm.business.activity.form.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;

/**
 * @Description: 分子活动形式关联主体活动形式
 * @Author qiancheng
 * @Date 2023/4/4
 */
@ApiModel(value = "SubRelatedMainActivityForm", description = "分子活动形式关联主体活动形式")
@TableName("tpm_sub_related_main_activity_form")
@Getter
@Setter
@Entity(name = "tpm_sub_related_main_activity_form")
@org.hibernate.annotations.Table(appliesTo = "tpm_sub_related_main_activity_form", comment = "分子活动形式关联主体活动形式")
@Table(name = "tpm_sub_related_main_activity_form", indexes = {
        @Index(name = "tpm_sub_related_main_form_idx1", columnList = "sub_form_code", unique = false),
})
public class SubRelatedMainActivityForm extends TenantFlagOpEntity {

    @ApiModelProperty(name = "分子活动形式编码", notes = "分子活动形式编码")
    @Column(name = "sub_form_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '分子活动形式编码'")
    private String subFormCode;

    @ApiModelProperty(name = "分子活动形式名称", notes = "分子活动形式名称")
    @Column(name = "sub_form_name",  length = 255, columnDefinition = "VARCHAR(255) COMMENT '分子活动形式名称'")
    private String subFormName;

    @ApiModelProperty(name = "主体活动形式编码", notes = "主体活动形式编码")
    @Column(name = "main_form_code",  length = 64, columnDefinition = "VARCHAR(64) COMMENT '主体活动形式编码'")
    private String mainFormCode;

}
