package com.biz.crm.tpm.business.activity.form.local.listener;

import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormAudit;
import com.biz.crm.tpm.business.activity.form.local.service.ActivityFormAuditService;
import com.biz.crm.tpm.business.approval.collect.sdk.event.MnApprovalCollectEventListener;
import com.biz.crm.tpm.business.approval.collect.sdk.vo.MnApprovalCollectVo;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 核销采集事件监听
 *
 * @author: huxmld
 * @version: v1.0.0
 * @date: 2023.3.4 1:18
 */
@Component
public class MnApprovalCollectEventListenerImpl implements MnApprovalCollectEventListener {

    @Autowired(required = false)
    private ActivityFormAuditService activityFormAuditService;

    /**
     * 核销形式删除
     *
     * @param dto
     * @return
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023.3.4 1:22
     */
    @Override
    public void onDeleted(MnApprovalCollectVo dto) {
        if (Objects.isNull(dto)
                || StringUtils.isEmpty(dto.getCode())) {
            return;
        }
        List<ActivityFormAudit> result = activityFormAuditService.findByAuditDataCode(dto.getCode());
        if (CollectionUtils.isEmpty(result)) {
            return;
        }
        Set<String> codeSet = result.stream().filter(k -> StringUtils.isNotBlank(k.getActivityFormCode()))
                .map(ActivityFormAudit::getActivityFormCode)
                .collect(Collectors.toSet());
        Assert.isTrue(CollectionUtils.isEmpty(result),
                "核销采集示例" + codeSet.toString() + ";已被活动形式关联不允许删除!");

    }


    /**
     * 核销形式更新
     *
     * @param oldMnApprovalCollectVo
     * @param newMnApprovalCollectVo
     * @return
     * @author: huxmld
     * @version: v1.0.0
     * @date: 2023.3.4 1:22
     */
    @Override
    public void onUpdate(MnApprovalCollectVo oldMnApprovalCollectVo, MnApprovalCollectVo newMnApprovalCollectVo) {

    }


}
