package com.biz.crm.tpm.business.activity.form.local.mapper;


import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityForm;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormPopEctDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormCodeAndNameVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormPopEctVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 活动形式(ActivityForm)表mybatis访问层
 *
 * @author makejava
 * @since 2022-10-25 10:55:05
 */
public interface ActivityFormMapper extends BaseMapper<ActivityForm> {

    /**
     * 分页查询所有数据
     *
     * @param page         分页对象
     * @param activityForm 查询实体
     * @return 所有数据
     */
    public Page<ActivityFormVo> findByConditions(@Param("page") Page<ActivityFormVo> page, @Param("activityForm") ActivityFormDto activityForm);

    List<ActivityFormVo> findListByConditions(@Param("activityForm") ActivityFormDto activityForm);

    /**
     * 活动形式下拉
     *
     * @param dto       活动形式查询参数
     * @param limitSize 下拉数量
     * @return 活动形式下拉数据
     */
    List<CommonSelectVo> findActivityFormSelectList(@Param("dto") ActivityFormSelectDto dto, @Param("limitSize") int limitSize);

    /**
     * 活动形式下拉（分子公司规划、细案用）
     *
     * @param dto
     * @param limitSize
     * @return java.util.List<com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo>
     * @author huojia
     * @date 2022/12/28 14:17
     **/
    List<ActivityFormVo> findSelectList(@Param("dto") ActivityFormSelectDto dto, @Param("limitSize") int limitSize);

    /**
     * 根据活动形式编码获取有效的活动形式信息
     *
     * @param formCodes  活动形式编码列表
     * @param tenantCode 租户编码
     * @return List<ActivityFormCodeAndNameVo>
     */
    List<ActivityFormCodeAndNameVo> findFormByCodes(@Param("formCodes") List<List<String>> formCodes, @Param("tenantCode") String tenantCode);

    List<String> findFormByCodesZs03(@Param("formCodes") List<List<String>> formCodes, @Param("tenantCode") String tenantCode);

    List<String> findFormByCodesZs42(@Param("formCodes") List<List<String>> formCodes, @Param("tenantCode") String tenantCode);

    ActivityFormVo findFormAndRelatedTypeCode(@Param("formCode") String activityFormCode,@Param("tenantCode") String tenantCode);

    /**
     * 分页查询重客垂直的活动形式，ect系统用
     * @param page
     * @param activityFormPopEctDto
     * @return
     */
    Page<ActivityFormPopEctVo> findActivityFormPopEct(@Param("page") Page<ActivityFormPopEctVo> page, @Param("dto") ActivityFormPopEctDto activityFormPopEctDto);

    List<String> findActivityFormCodeFromPromotionsType(@Param("businessUnitCode") String businessUnitCode, @Param("verticalActivityType") String verticalActivityType, @Param("pushExeSystemCode") String pushExeSystemCode, @Param("tenantCode") String tenantCode);

    List<ActivityFormVo> findFormAndRelatedTypeCodes(@Param("codes")List<String> activityFormCodes,@Param("tenantCode") String tenantCode);
}

