package com.biz.crm.tpm.business.activity.form.local.register;

import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.bizunited.nebula.europa.database.register.sdk.service.DataviewRegister;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/8 11:21
 * @description：数据视图
 */
@Component
@Slf4j
public class ActivityFormRegister implements DataviewRegister {
    @Override
    public String code() {
        return "tpm_activity_form_data_view";
    }

    @Override
    public String desc() {
        return "TPM-活动形式";
    }

    @Override
    public String buildSql() {
        return "select t.*,tt.activity_type_code,tt.activity_type_name from tpm_activity_form t " +
                "left join (\n" +
                "select a.activity_form_code,\n" +
                "group_concat(b.activity_type_code) activity_type_code,\n" +
                "group_concat(b.activity_type_name) activity_type_name\n" +
                " from tpm_activity_type_form a\n" +
                " left join tpm_activity_type b on a.activity_type_code = b.activity_type_code\n" +
                "where b.del_flag = '009'\n" +
                "group by a.activity_form_code\n" +
                ") tt on tt.activity_form_code = t.activity_form_code\n" +
                "where t.tenant_code = :tenantCode " +
                "and t.del_flag = '"+ DelFlagStatusEnum.NORMAL.getCode()+"'";
    }
}
