package com.biz.crm.tpm.business.activity.form.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormAudit;
import com.biz.crm.tpm.business.activity.form.local.mapper.ActivityFormAuditMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.List;


/**
 * 活动形式的核销资料(ActivityFormAudit)表数据库访问层
 *
 * @author makejava
 * @since 2022-10-25 10:55:05
 */
@Component
public class ActivityFormAuditRepository extends ServiceImpl<ActivityFormAuditMapper, ActivityFormAudit> {

    @Autowired
    private ActivityFormAuditMapper activityFormAuditMapper;

    /**
     * 分页查询数据
     *
     * @param pageable          分页对象
     * @param activityFormAudit 实体对象
     * @return
     */
    public Page<ActivityFormAudit> findByConditions(Pageable pageable, ActivityFormAudit activityFormAudit) {
        Page<ActivityFormAudit> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<ActivityFormAudit> pageList = this.activityFormAuditMapper.findByConditions(page, activityFormAudit);
        return pageList;
    }

    /**
     * 根据核销编码
     *
     * @param auditDataCode
     * @return
     */
    public List<ActivityFormAudit> findByAuditDataCode(String auditDataCode) {
        if (StringUtils.isEmpty(auditDataCode)) {
            return Collections.emptyList();
        }
        return this.lambdaQuery()
                .eq(ActivityFormAudit::getAuditDataCode, auditDataCode)
                .eq(ActivityFormAudit::getTenantCode, TenantUtils.getTenantCode())
                .eq(ActivityFormAudit::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }
}

