package com.biz.crm.tpm.business.activity.form.local.repository;



import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormCollectField;
import com.biz.crm.tpm.business.activity.form.local.mapper.ActivityFormCollectFieldMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * 活动采集字段(ActivityFormCollectField)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-07 13:50:33
 */
@Component
public class ActivityFormCollectFieldRepository extends ServiceImpl<ActivityFormCollectFieldMapper, ActivityFormCollectField> {

  @Autowired
  private ActivityFormCollectFieldMapper activityFormCollectFieldMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param activityFormCollectField 实体对象
   * @return
   */
  public Page<ActivityFormCollectField> findByConditions(Pageable pageable, ActivityFormCollectField activityFormCollectField) {
    Page<ActivityFormCollectField> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<ActivityFormCollectField> pageList = this.activityFormCollectFieldMapper.findByConditions(page, activityFormCollectField);
    return pageList;
  }
}

