package com.biz.crm.tpm.business.activity.form.local.repository;



import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormCollect;
import com.biz.crm.tpm.business.activity.form.local.mapper.ActivityFormCollectMapper;
import org.springframework.beans.factory.annotation.Autowired;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import org.springframework.stereotype.Component;
import org.springframework.data.domain.Pageable;


/**
 * 活动形式照片采集(ActivityFormCollect)表数据库访问层
 *
 * @author makejava
 * @since 2022-11-07 13:50:33
 */
@Component
public class ActivityFormCollectRepository extends ServiceImpl<ActivityFormCollectMapper, ActivityFormCollect> {

  @Autowired
  private ActivityFormCollectMapper activityFormCollectMapper;
  
   /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param activityFormCollect 实体对象
   * @return
   */
  public Page<ActivityFormCollect> findByConditions(Pageable pageable, ActivityFormCollect activityFormCollect) {
    Page<ActivityFormCollect> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
    Page<ActivityFormCollect> pageList = this.activityFormCollectMapper.findByConditions(page, activityFormCollect);
    return pageList;
  }
}

