package com.biz.crm.tpm.business.activity.form.local.repository;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormExeDetail;
import com.biz.crm.tpm.business.activity.form.local.mapper.ActivityFormExeDetailMapper;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/28 12:24
 * @description：活动执行明细
 */
@Component
public class ActivityFormExeDetailRepository extends ServiceImpl<ActivityFormExeDetailMapper, ActivityFormExeDetail> {

    /**
     * 查询所有需推送订单共享平台的活动形式
     * @return 活动形式活动执行明细集合
     */
    public List<ActivityFormExeDetail> findPushOtherPlatform(List<String> formCodes) {
        return this.lambdaQuery()
                .eq(ActivityFormExeDetail::getIsPushOtherPlatformExe, BooleanEnum.TRUE.getNumStr())
                .eq(ActivityFormExeDetail::getTenantCode, TenantUtils.getTenantCode())
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(ActivityFormExeDetail::getActivityFormCode,formCodes)
                .list();
    }

    /**
     * 批量查询
     *
     * @param activityFormCodeList
     * @return java.util.List<com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormExeDetail>
     * @author huojia
     * @date 2022/12/28 14:34
     **/
    public List<ActivityFormExeDetail> listByActivityFormCode(List<String> activityFormCodeList) {
        if (CollectionUtils.isEmpty(activityFormCodeList)) {
            return null;
        }
        return this.lambdaQuery()
                .in(ActivityFormExeDetail::getActivityFormCode, activityFormCodeList)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
    }
}
