package com.biz.crm.tpm.business.activity.form.local.repository;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.BooleanEnum;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.mn.common.base.constant.CommonSelectConstant;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityForm;
import com.biz.crm.tpm.business.activity.form.local.mapper.ActivityFormMapper;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormPopEctDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormCodeAndNameVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormPopEctVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.Arrays;
import java.util.List;
import java.util.Optional;


/**
 * 活动形式(ActivityForm)表数据库访问层
 *
 * @author makejava
 * @since 2022-10-25 10:55:05
 */
@Component
public class ActivityFormRepository extends ServiceImpl<ActivityFormMapper, ActivityForm> {

    @Autowired
    private ActivityFormMapper activityFormMapper;

    /**
     * 分页查询数据
     *
     * @param pageable     分页对象
     * @param activityForm 实体对象
     * @return
     */
    public Page<ActivityFormVo> findByConditions(Pageable pageable, ActivityFormDto activityForm) {
        Page<ActivityFormVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        if (StringUtils.isNotEmpty(activityForm.getActivityTypeCodes())) {
            List<String> activityTypeCodeList = Optional.ofNullable(activityForm.getActivityTypeCodeList()).orElse(Lists.newArrayList());
            activityTypeCodeList.addAll(Arrays.asList(activityForm.getActivityTypeCodes().split(",")));
            activityForm.setActivityTypeCodeList(activityTypeCodeList);
        }
        Page<ActivityFormVo> pageList = this.activityFormMapper.findByConditions(page, activityForm);
        return pageList;
    }

    public List<ActivityFormVo> findListByConditions(ActivityFormDto activityForm) {
        return this.activityFormMapper.findListByConditions(activityForm);
    }

    /**
     * 活动形式下拉
     *
     * @param dto 活动形式查询参数
     * @return 活动形式下拉数据
     */
    public List<CommonSelectVo> findActivityFormSelectList(ActivityFormSelectDto dto) {
        if (StringUtils.isNotEmpty(dto.getSelectedCode())) {
            List<String> selectCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(Lists.newArrayList());
            selectCodeList.add(dto.getSelectedCode());
            dto.setSelectedCodeList(selectCodeList);
        }
        return activityFormMapper.findActivityFormSelectList(dto, CommonSelectConstant.COMMON_SELECT_DEFAULT_SIZE);
    }

    /**
     * 活动形式下拉（分子公司规划、细案用）
     *
     * @param dto
     * @return java.util.List<com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo>
     * @author huojia
     * @date 2022/12/28 14:18
     **/
    public List<ActivityFormVo> findSelectList(ActivityFormSelectDto dto) {
        if (StringUtils.isNotEmpty(dto.getSelectedCode())) {
            List<String> selectCodeList = Optional.ofNullable(dto.getSelectedCodeList()).orElse(Lists.newArrayList());
            selectCodeList.add(dto.getSelectedCode());
            dto.setSelectedCodeList(selectCodeList);
        }
        return activityFormMapper.findSelectList(dto, CommonSelectConstant.COMMON_SELECT_DEFAULT_SIZE);
    }


    /**
     * 根据活动形式编码获取有效的活动形式信息
     *
     * @param formCodes 活动形式编码列表
     * @return Map<String, String>
     */
    public List<ActivityFormCodeAndNameVo> findFormByCodes(List<List<String>> formCodes,String tenantCode) {
        return activityFormMapper.findFormByCodes(formCodes,tenantCode);
    }

    public List<String> findFormByCodesZs03(List<List<String>> formCodes,String tenantCode) {
        return activityFormMapper.findFormByCodesZs03(formCodes,tenantCode);
    }
    public List<String> findFormByCodesZs42(List<List<String>> formCodes,String tenantCode) {
        return activityFormMapper.findFormByCodesZs42(formCodes,tenantCode);
    }

    /**
     * 查询所用需推送巡查系统的活动形式
     * @return 活动形式集合
     */
    public List<ActivityForm> findPushCowManager() {
        return this.lambdaQuery().eq(ActivityForm::getIsPushPatrolSystem, BooleanEnum.TRUE.getNumStr())
                .list();
    }

    /**
     *
     * @param formCodes
     * @return
     */
    public List<ActivityForm> findSapCodeByCodes(List<String> formCodes) {
        return this.lambdaQuery()
                .eq(ActivityForm::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .in(ActivityForm::getActivityFormCode, formCodes)
                .list();
    }

    public List<ActivityForm> findByIdList(List<String> ids) {
        return this.lambdaQuery()
                .eq(ActivityForm::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityForm::getTenantCode, TenantUtils.getTenantCode())
                .in(ActivityForm::getId, ids)
                .list();
    }

    public ActivityFormVo findFormAndRelatedTypeCode(String activityFormCode,String tennatCode) {
        if (StringUtils.isBlank(activityFormCode) || StringUtils.isBlank(tennatCode)) {
            return null;
        }
        return this.baseMapper.findFormAndRelatedTypeCode(activityFormCode,tennatCode);
    }

    public ActivityForm findById(String id) {
        return this.lambdaQuery()
                .eq(ActivityForm::getId, id)
                .eq(TenantFlagOpEntity::getTenantCode, TenantUtils.getTenantCode())
                .one();
    }

    public Page<ActivityFormPopEctVo> findActivityFormPopEct(Pageable pageable, ActivityFormPopEctDto activityFormPopEctDto) {
        Page<ActivityFormPopEctVo> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        Page<ActivityFormPopEctVo> pageList = this.activityFormMapper.findActivityFormPopEct(page, activityFormPopEctDto);
        return pageList;
    }

    public List<String> findActivityFormCodeFromPromotionsType(String businessUnitCode,String verticalActivityType,String pushExeSystemCode){
        return this.baseMapper.findActivityFormCodeFromPromotionsType(businessUnitCode,verticalActivityType,pushExeSystemCode,TenantUtils.getTenantCode());
    }

    public List<ActivityFormVo> findFormAndRelatedTypeCodes(List<String> activityFormCodes, String tenantCode) {
        return this.baseMapper.findFormAndRelatedTypeCodes(activityFormCodes,tenantCode);
    }
}

