package com.biz.crm.tpm.business.activity.form.local.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormAudit;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 * 活动形式的核销资料(ActivityFormAudit)表服务接口
 *
 * @author makejava
 * @since 2022-10-25 10:55:05
 */
public interface ActivityFormAuditService {

    /**
     * 分页查询数据
     *
     * @param pageable          分页对象
     * @param activityFormAudit 实体对象
     * @return
     */
    Page<ActivityFormAudit> findByConditions(Pageable pageable, ActivityFormAudit activityFormAudit);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    ActivityFormAudit findById(String id);

    /**
     * 根据核销编码查询
     *
     * @param auditDataCode
     * @return 活动形式和核销关系
     */
    List<ActivityFormAudit> findByAuditDataCode(String auditDataCode);

    /**
     * 新增数据
     *
     * @param activityFormAudit 实体对象
     * @return 新增结果
     */
    ActivityFormAudit create(ActivityFormAudit activityFormAudit);

    /**
     * 修改新据
     *
     * @param activityFormAudit 实体对象
     * @return 修改结果
     */
    ActivityFormAudit update(ActivityFormAudit activityFormAudit);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

}

