package com.biz.crm.tpm.business.activity.form.local.service.internal;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormAudit;
import com.biz.crm.tpm.business.activity.form.local.repository.ActivityFormAuditRepository;
import com.biz.crm.tpm.business.activity.form.local.service.ActivityFormAuditService;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.Collections;
import java.util.List;
import java.util.Objects;

/**
 * 活动形式的核销资料(ActivityFormAudit)表服务实现类
 *
 * @author makejava
 * @since 2022-10-25 10:55:05
 */
@Service("activityFormAuditService")
public class ActivityFormAuditServiceImpl implements ActivityFormAuditService {

    @Autowired
    private ActivityFormAuditRepository activityFormAuditRepository;

    /**
     * 分页查询数据
     *
     * @param pageable          分页对象
     * @param activityFormAudit 实体对象
     * @return
     */
    @Override
    public Page<ActivityFormAudit> findByConditions(Pageable pageable, ActivityFormAudit activityFormAudit) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(activityFormAudit)) {
            activityFormAudit = new ActivityFormAudit();
        }
        return this.activityFormAuditRepository.findByConditions(pageable, activityFormAudit);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public ActivityFormAudit findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        return this.activityFormAuditRepository.getById(id);
    }

    /**
     * 根据核销编码
     *
     * @param auditDataCode
     * @return
     */
    @Override
    public List<ActivityFormAudit> findByAuditDataCode(String auditDataCode) {
        if (StringUtils.isBlank(auditDataCode)) {
            return Collections.emptyList();
        }
        return activityFormAuditRepository.findByAuditDataCode( auditDataCode);
    }

    /**
     * 新增数据
     *
     * @param activityFormAudit 实体对象
     * @return 新增结果
     */
    @Transactional
    @Override
    public ActivityFormAudit create(ActivityFormAudit activityFormAudit) {
        this.createValidate(activityFormAudit);
        this.activityFormAuditRepository.saveOrUpdate(activityFormAudit);
        return activityFormAudit;
    }

    /**
     * 修改新据
     *
     * @param activityFormAudit 实体对象
     * @return 修改结果
     */
    @Transactional
    @Override
    public ActivityFormAudit update(ActivityFormAudit activityFormAudit) {
        this.updateValidate(activityFormAudit);
        this.activityFormAuditRepository.saveOrUpdate(activityFormAudit);
        return activityFormAudit;
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @Transactional
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        this.activityFormAuditRepository.removeByIds(idList);
    }

    /**
     * 创建验证
     *
     * @param activityFormAudit
     */
    private void createValidate(ActivityFormAudit activityFormAudit) {
        Validate.notNull(activityFormAudit, "新增时，对象信息不能为空！");
        activityFormAudit.setId(null);
        Validate.notBlank(activityFormAudit.getTenantCode(), "新增数据时，租户编号不能为空！");
        Validate.notBlank(activityFormAudit.getAuditDataCode(), "新增数据时，核销资料code不能为空！");

    }

    /**
     * 修改验证
     *
     * @param activityFormAudit
     */
    private void updateValidate(ActivityFormAudit activityFormAudit) {
        Validate.notNull(activityFormAudit, "修改时，对象信息不能为空！");
        Validate.notBlank(activityFormAudit.getId(), "新增数据时，不能为空！");
        Validate.notBlank(activityFormAudit.getTenantCode(), "新增数据时，租户编号不能为空！");
        Validate.notBlank(activityFormAudit.getAuditDataCode(), "新增数据时，核销资料code不能为空！");

    }
}

