package com.biz.crm.tpm.business.activity.form.local.service.internal;



import com.biz.crm.tpm.business.activity.form.local.repository.ActivityFormCollectFieldRepository;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormCollectField;
import com.biz.crm.tpm.business.activity.form.local.service.ActivityFormCollectFieldService;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 活动采集字段(ActivityFormCollectField)表服务实现类
 *
 * @author makejava
 * @since 2022-11-07 13:50:33
 */
@Service("activityFormCollectFieldService")
public class ActivityFormCollectFieldServiceImpl implements ActivityFormCollectFieldService {

  @Autowired
  private ActivityFormCollectFieldRepository activityFormCollectFieldRepository;

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param activityFormCollectField 实体对象
   * @return
   */
  @Override
  public Page<ActivityFormCollectField> findByConditions(Pageable pageable, ActivityFormCollectField activityFormCollectField) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    if (Objects.isNull(activityFormCollectField)) {
      activityFormCollectField = new ActivityFormCollectField();
    }
    return this.activityFormCollectFieldRepository.findByConditions(pageable, activityFormCollectField);
  }
  
  /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public ActivityFormCollectField findById(String id) {
    if (StringUtils.isBlank(id)) {
	  return null;
	}
    return this.activityFormCollectFieldRepository.getById(id);
  }
  
  /**
   * 新增数据
   * @param activityFormCollectField 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public ActivityFormCollectField create(ActivityFormCollectField activityFormCollectField) {
    this.createValidate(activityFormCollectField);
    this.activityFormCollectFieldRepository.saveOrUpdate(activityFormCollectField);
    return activityFormCollectField;
  }
  
  /**
   * 修改新据
   * @param activityFormCollectField 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public ActivityFormCollectField update(ActivityFormCollectField activityFormCollectField) {
    this.updateValidate(activityFormCollectField);
    this.activityFormCollectFieldRepository.saveOrUpdate(activityFormCollectField);
    return activityFormCollectField;
  }
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.activityFormCollectFieldRepository.removeByIds(idList);
  }
  
  /**
   * 创建验证
   * @param activityFormCollectField
   */
  private void createValidate(ActivityFormCollectField activityFormCollectField) {
    Validate.notNull(activityFormCollectField, "新增时，对象信息不能为空！");
	activityFormCollectField.setId(null);
      Validate.notBlank(activityFormCollectField.getTenantCode(), "新增数据时，租户编号不能为空！");
   
  }
  
   /**
   * 修改验证
   * @param activityFormCollectField
   */
  private void updateValidate(ActivityFormCollectField activityFormCollectField) {
    Validate.notNull(activityFormCollectField, "修改时，对象信息不能为空！");
      Validate.notBlank(activityFormCollectField.getId(), "新增数据时，不能为空！");
    Validate.notBlank(activityFormCollectField.getTenantCode(), "新增数据时，租户编号不能为空！");
    
  }
}

