package com.biz.crm.tpm.business.activity.form.local.service.internal;



import com.biz.crm.tpm.business.activity.form.local.repository.ActivityFormCollectRepository;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormCollect;
import com.biz.crm.tpm.business.activity.form.local.service.ActivityFormCollectService;
import org.springframework.stereotype.Service;
import org.springframework.beans.factory.annotation.Autowired;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.List;
import java.util.Objects;

/**
 * 活动形式照片采集(ActivityFormCollect)表服务实现类
 *
 * @author makejava
 * @since 2022-11-07 13:50:33
 */
@Service("activityFormCollectService")
public class ActivityFormCollectServiceImpl implements ActivityFormCollectService {

  @Autowired
  private ActivityFormCollectRepository activityFormCollectRepository;

  /**
   * 分页查询数据
   * @param pageable 分页对象
   * @param activityFormCollect 实体对象
   * @return
   */
  @Override
  public Page<ActivityFormCollect> findByConditions(Pageable pageable, ActivityFormCollect activityFormCollect) {
    pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
    if (Objects.isNull(activityFormCollect)) {
      activityFormCollect = new ActivityFormCollect();
    }
    return this.activityFormCollectRepository.findByConditions(pageable, activityFormCollect);
  }
  
  /**
   * 通过主键查询单条数据
   * @param id 主键
   * @return 单条数据
   */
  @Override
  public ActivityFormCollect findById(String id) {
    if (StringUtils.isBlank(id)) {
	  return null;
	}
    return this.activityFormCollectRepository.getById(id);
  }
  
  /**
   * 新增数据
   * @param activityFormCollect 实体对象
   * @return 新增结果
   */
  @Transactional
  @Override
  public ActivityFormCollect create(ActivityFormCollect activityFormCollect) {
    this.createValidate(activityFormCollect);
    this.activityFormCollectRepository.saveOrUpdate(activityFormCollect);
    return activityFormCollect;
  }
  
  /**
   * 修改新据
   * @param activityFormCollect 实体对象
   * @return 修改结果
   */
  @Transactional
  @Override
  public ActivityFormCollect update(ActivityFormCollect activityFormCollect) {
    this.updateValidate(activityFormCollect);
    this.activityFormCollectRepository.saveOrUpdate(activityFormCollect);
    return activityFormCollect;
  }
  
  /**
   * 删除数据
   * @param idList 主键结合
   * @return 删除结果
   */
  @Transactional
  @Override
  public void delete(List<String> idList) {
    Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
    this.activityFormCollectRepository.removeByIds(idList);
  }
  
  /**
   * 创建验证
   * @param activityFormCollect
   */
  private void createValidate(ActivityFormCollect activityFormCollect) {
    Validate.notNull(activityFormCollect, "新增时，对象信息不能为空！");
	activityFormCollect.setId(null);
      Validate.notBlank(activityFormCollect.getTenantCode(), "新增数据时，租户编号不能为空！");
   
  }
  
   /**
   * 修改验证
   * @param activityFormCollect
   */
  private void updateValidate(ActivityFormCollect activityFormCollect) {
    Validate.notNull(activityFormCollect, "修改时，对象信息不能为空！");
      Validate.notBlank(activityFormCollect.getId(), "新增数据时，不能为空！");
    Validate.notBlank(activityFormCollect.getTenantCode(), "新增数据时，租户编号不能为空！");
    
  }
}

