package com.biz.crm.tpm.business.activity.form.local.service.internal;


import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.local.entity.UuidEntity;
import com.biz.crm.business.common.local.entity.UuidFlagOpEntity;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.business.common.sdk.service.GenerateCodeService;
import com.biz.crm.mdm.business.dictionary.sdk.service.DictDataVoService;
import com.biz.crm.mdm.business.dictionary.sdk.vo.DictDataVo;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activity.form.local.constant.ActivityFormConstant;
import com.biz.crm.tpm.business.activity.form.local.entity.*;
import com.biz.crm.tpm.business.activity.form.local.enumeration.ExeSystemEnum;
import com.biz.crm.tpm.business.activity.form.local.enumeration.SelectPatrolSystemEnum;
import com.biz.crm.tpm.business.activity.form.local.repository.*;
import com.biz.crm.tpm.business.activity.form.sdk.dto.*;
import com.biz.crm.tpm.business.activity.form.sdk.dto.log.ActivityFormLogEventDto;
import com.biz.crm.tpm.business.activity.form.sdk.event.log.ActivityFormEventListener;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.*;
import com.biz.crm.tpm.business.approval.collect.sdk.service.MnApprovalCollectVoService;
import com.biz.crm.tpm.business.approval.collect.sdk.vo.MnApprovalCollectVo;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 活动形式(ActivityForm)表服务实现类
 *
 * @author makejava
 * @since 2022-10-25 10:55:05
 */
@Service("activityFormService")
public class ActivityFormServiceImpl implements ActivityFormService {

    @Autowired(required = false)
    private ActivityFormRepository activityFormRepository;
    @Autowired(required = false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required = false)
    private ActivityFormAuditRepository activityFormAuditRepository;

    @Autowired(required = false)
    private ActivityFormCollectFieldRepository activityFormCollectFieldRepository;

    @Autowired(required = false)
    private ActivityFormCollectRepository activityFormCollectRepository;

    @Autowired(required = false)
    private GenerateCodeService generateCodeService;

    @Autowired(required = false)
    private NebulaNetEventClient nebulaNetEventClient;

    @Autowired(required = false)
    private MnApprovalCollectVoService mnApprovalCollectVoService;

    @Autowired(required = false)
    private ActivityFormExeDetailRepository activityFormExeDetailRepository;

    @Autowired(required = false)
    private DictDataVoService dictDataVoService;

    @Autowired(required = false)
    private SubRelatedMainActivityFormRepository subRelatedMainActivityFormRepository;

    /**
     * 分页查询数据
     *
     * @param pageable     分页对象
     * @param activityForm 实体对象
     * @return
     */
    @Override
    public Page<ActivityFormVo> findByConditions(Pageable pageable, ActivityFormDto activityForm) {
        pageable = ObjectUtils.defaultIfNull(pageable, PageRequest.of(1, 50));
        if (Objects.isNull(activityForm)) {
            activityForm = new ActivityFormDto();
        }
        Page<ActivityFormVo> result =  this.activityFormRepository.findByConditions(pageable, activityForm);
        if(Objects.nonNull(result) && !CollectionUtils.isEmpty(result.getRecords())){
            List<DictDataVo> dictDataVo = dictDataVoService.findByDictTypeCode(ActivityFormConstant.MDM_BUSINESS_UNIT);
            Map<String,DictDataVo> dictDataVoMap = dictDataVo.stream().collect(Collectors.toMap(DictDataVo::getDictCode,Function.identity(),(v1,v2) -> v1));
            result.getRecords().forEach(e -> {
                if(StringUtils.isBlank(e.getBusinessUnitCode())) return;
                String[] businessUnitCode = e.getBusinessUnitCode().split(",");
                Set<String> businessUnitName = Sets.newHashSet();
                StringJoiner joiner = new StringJoiner(",");
                for(String code : businessUnitCode){
                    if(dictDataVoMap.containsKey(code)) {
                        businessUnitName.add(dictDataVoMap.get(code).getDictValue());
                    }
                }
                if(!CollectionUtils.isEmpty(businessUnitName)){
                    businessUnitName.forEach(joiner::add);
                    e.setBusinessUnitName(joiner.toString());
                }
            });
        }

        return result;
    }

    @Override
    public List<ActivityFormVo> findListByConditions(ActivityFormDto activityForm) {
        return this.activityFormRepository.findListByConditions(activityForm);
    }

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    @Override
    public ActivityFormVo findById(String id) {
        if (StringUtils.isBlank(id)) {
            return null;
        }
        ActivityForm activityFormEntity = this.activityFormRepository.findById(id);
        Validate.notNull(activityFormEntity, "查询的数据不存在");
        ActivityFormVo activityFormVo = this.nebulaToolkitService.copyObjectByWhiteList(activityFormEntity, ActivityFormVo.class, null, null);
        List<ActivityFormAudit> activityFormAuditList = this.activityFormAuditRepository.lambdaQuery().eq(ActivityFormAudit::getActivityFormCode, activityFormEntity.getActivityFormCode()).list();
        if (!CollectionUtils.isEmpty(activityFormAuditList)) {
            activityFormVo.setActivityFormAuditDtoList((List<ActivityFormAuditDto>) this.nebulaToolkitService.copyCollectionByBlankList(activityFormAuditList, ActivityFormAudit.class, ActivityFormAuditDto.class, LinkedHashSet.class, ArrayList.class));
        }
        List<ActivityFormExeDetail> activityFormExeDetailList = this.activityFormExeDetailRepository.lambdaQuery().eq(ActivityFormExeDetail::getActivityFormCode, activityFormEntity.getActivityFormCode()).list();
        if (!CollectionUtils.isEmpty(activityFormExeDetailList)) {
            Map<String, List<ActivityFormCollectVo>> activityFormCollectVoMap = new HashMap<>();
            List<ActivityFormCollect> list = this.activityFormCollectRepository.lambdaQuery().eq(ActivityFormCollect::getActivityFormCode, activityFormEntity.getActivityFormCode()).list();
            if (!CollectionUtils.isEmpty(list)) {
                Collection<ActivityFormCollectVo> activityFormCollectVos = this.nebulaToolkitService.copyCollectionByBlankList(list, ActivityFormCollect.class, ActivityFormCollectVo.class, LinkedHashSet.class, ArrayList.class);
                activityFormCollectVoMap = activityFormCollectVos.stream().collect(Collectors.groupingBy(ActivityFormCollectVo::getActivityFormExeDetailId));
            }
            List<ActivityFormCollectField> list1 = this.activityFormCollectFieldRepository.lambdaQuery().eq(ActivityFormCollectField::getActivityFormCode, activityFormEntity.getActivityFormCode()).list();
            Map<String, List<ActivityFormCollectFieldVo>> activityFormCollectFieldVoMap = new HashMap<>();
            if (!CollectionUtils.isEmpty(list1)) {
                Collection<ActivityFormCollectFieldVo> activityFormCollectVos = this.nebulaToolkitService.copyCollectionByBlankList(list1, ActivityFormCollectField.class, ActivityFormCollectFieldVo.class, LinkedHashSet.class, ArrayList.class);
                activityFormCollectFieldVoMap = activityFormCollectVos.stream().collect(Collectors.groupingBy(ActivityFormCollectFieldVo::getActivityFormExeDetailId));
            }
            Collection<ActivityFormExeDetailVo> activityFormExeDetailVos = this.nebulaToolkitService.copyCollectionByBlankList(activityFormExeDetailList, ActivityFormExeDetail.class, ActivityFormExeDetailVo.class, LinkedHashSet.class, ArrayList.class);
            for (ActivityFormExeDetailVo activityFormExeDetailVo : activityFormExeDetailVos) {
                List<ActivityFormCollectVo> activityFormCollectVos = activityFormCollectVoMap.get(activityFormExeDetailVo.getId());
                if (!CollectionUtils.isEmpty(activityFormCollectVos)) {
                    activityFormExeDetailVo.setActivityFormCollectDtoList(activityFormCollectVos);
                }
                List<ActivityFormCollectFieldVo> activityFormCollectFieldVos = activityFormCollectFieldVoMap.get(activityFormExeDetailVo.getId());
                if (!CollectionUtils.isEmpty(activityFormCollectFieldVos)) {
                    activityFormExeDetailVo.setActivityFormCollectFieldDtoList(activityFormCollectFieldVos);
                }
            }
            activityFormVo.setActivityFormExeDetailList((List<ActivityFormExeDetailVo>) activityFormExeDetailVos);
        }
        List<SubRelatedMainActivityForm> relatedFormList = this.subRelatedMainActivityFormRepository.lambdaQuery().eq(SubRelatedMainActivityForm::getSubFormCode,activityFormEntity.getActivityFormCode()).list();
        if (!CollectionUtils.isEmpty(relatedFormList)) {
            List<SubRelatedMainActivityFormVo> subRelatedMainActivityFormVos = (List<SubRelatedMainActivityFormVo>) nebulaToolkitService.copyCollectionByWhiteList(relatedFormList, SubRelatedMainActivityForm.class, SubRelatedMainActivityFormVo.class, HashSet.class, ArrayList.class);
            activityFormVo.setSubMainActivityFormList(subRelatedMainActivityFormVos);
        }

        return activityFormVo;
    }

    /**
     * 新增数据
     *
     * @param activityForm 实体对象
     * @return 新增结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public ActivityFormVo create(ActivityFormDto activityForm) {
        this.createValidate(activityForm);
        ActivityForm activityFormEntity = nebulaToolkitService.copyObjectByWhiteList(activityForm, ActivityForm.class, null, null);

//        String ruleCode = StringUtils.join("HDXS", DateFormatUtils.format(new Date(), "yyyyMMdd"));
//        String code = this.generateCodeService.generateCode(ruleCode, 1, 5, 2, TimeUnit.DAYS).get(0);
//        activityFormEntity.setActivityFormCode(code);
        activityFormEntity.setTenantCode(TenantUtils.getTenantCode());
        this.activityFormRepository.saveOrUpdate(activityFormEntity);
        //核销资料
        if (!CollectionUtils.isEmpty(activityForm.getActivityFormAuditDtoList())) {
            Collection<ActivityFormAudit> activityFormAudits = nebulaToolkitService.copyCollectionByWhiteList(activityForm.getActivityFormAuditDtoList(), ActivityFormAuditDto.class, ActivityFormAudit.class, LinkedHashSet.class, ArrayList.class);
            activityFormAudits.forEach(item -> {
                item.setActivityFormCode(activityFormEntity.getActivityFormCode());
                item.setTenantCode(TenantUtils.getTenantCode());
            });
            activityFormAuditRepository.saveBatch(activityFormAudits);
        }
        //活动采集明细
        if (!CollectionUtils.isEmpty(activityForm.getActivityFormExeDetailList())) {
            activityForm.getActivityFormExeDetailList().forEach(item -> {
                item.setActivityFormCode(activityFormEntity.getActivityFormCode());
                item.setTenantCode(TenantUtils.getTenantCode());
                ActivityFormExeDetail entity = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityFormExeDetail.class, null, null);
                this.activityFormExeDetailRepository.save(entity);
                //活动形式照片采集
                if (!CollectionUtils.isEmpty(activityForm.getActivityFormExeDetailList())) {
                    Collection<ActivityFormCollect> activityFormCollects = nebulaToolkitService.copyCollectionByBlankList(item.getActivityFormCollectDtoList(), ActivityFormCollectDto.class, ActivityFormCollect.class, LinkedHashSet.class, ArrayList.class);
                    activityFormCollects.forEach(item2 -> {
                        item2.setActivityFormCode(activityFormEntity.getActivityFormCode());
                        item2.setTenantCode(TenantUtils.getTenantCode());
                        item2.setActivityFormExeDetailId(entity.getId());
                    });
                    activityFormCollectRepository.saveBatch(activityFormCollects);
                }
                //采集字段
                if (!CollectionUtils.isEmpty(item.getActivityFormCollectFieldDtoList())) {
                    Collection<ActivityFormCollectField> activityFormCollectFields = nebulaToolkitService.copyCollectionByBlankList(item.getActivityFormCollectFieldDtoList(), ActivityFormCollectFieldDto.class, ActivityFormCollectField.class, LinkedHashSet.class, ArrayList.class);
                    activityFormCollectFields.forEach(item2 -> {
                        item2.setActivityFormCode(activityFormEntity.getActivityFormCode());
                        item2.setTenantCode(TenantUtils.getTenantCode());
                        item2.setActivityFormExeDetailId(entity.getId());
                    });
                    this.activityFormCollectFieldRepository.saveBatch(activityFormCollectFields);
                }
            });
        }
        if (!StringUtils.isBlank(activityForm.getSubMainActivityFormCode())) {
            String[] split = activityForm.getSubMainActivityFormCode().split(",");
            List<SubRelatedMainActivityForm> subRelatedMainFormList = new ArrayList<>(split.length);
            for (String s : split) {
                SubRelatedMainActivityForm related = new SubRelatedMainActivityForm();
                related.setSubFormCode(activityFormEntity.getActivityFormCode());
                related.setSubFormName(activityFormEntity.getActivityFormName());
                related.setMainFormCode(s);
                related.setTenantCode(TenantUtils.getTenantCode());
                subRelatedMainFormList.add(related);
            }
            this.subRelatedMainActivityFormRepository.saveBatch(subRelatedMainFormList);
        }
        //新增业务日志
        ActivityFormLogEventDto logEventDto = new ActivityFormLogEventDto();
        logEventDto.setOriginal(null);
        logEventDto.setNewest(activityForm);
        SerializableBiConsumer<ActivityFormEventListener, ActivityFormLogEventDto> onCreate =
                ActivityFormEventListener::onCreate;
        this.nebulaNetEventClient.publish(logEventDto, ActivityFormEventListener.class, onCreate);
        return nebulaToolkitService.copyObjectByWhiteList(activityFormEntity, ActivityFormVo.class, LinkedHashSet.class, ArrayList.class);
    }

    /**
     * 修改新据
     *
     * @param activityForm 实体对象
     * @return 修改结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void update(ActivityFormDto activityForm) {
        this.updateValidate(activityForm);
        ActivityFormVo oldVo = this.findById(activityForm.getId());
        ActivityForm activityFormEntity = this.nebulaToolkitService.copyObjectByWhiteList(activityForm, ActivityForm.class, null, null);
        this.activityFormRepository.saveOrUpdate(activityFormEntity);

        activityFormAuditRepository.remove(Wrappers.lambdaUpdate(ActivityFormAudit.class).eq(ActivityFormAudit::getActivityFormCode, activityFormEntity.getActivityFormCode()));
        if (!CollectionUtils.isEmpty(activityForm.getActivityFormAuditDtoList())) {
            Collection<ActivityFormAudit> activityFormAudits = this.nebulaToolkitService.copyCollectionByBlankList(activityForm.getActivityFormAuditDtoList(), ActivityFormAuditDto.class, ActivityFormAudit.class, LinkedHashSet.class, ArrayList.class);
            activityFormAudits.forEach(item -> {
                item.setId(null);
                item.setTenantCode(TenantUtils.getTenantCode());
                item.setActivityFormCode(activityFormEntity.getActivityFormCode());
            });
            activityFormAuditRepository.saveBatch(activityFormAudits);
        }

        //删除原来的数据
        activityFormCollectRepository.remove(Wrappers.lambdaUpdate(ActivityFormCollect.class).eq(ActivityFormCollect::getActivityFormCode, activityFormEntity.getActivityFormCode()));
        activityFormCollectFieldRepository.remove(Wrappers.lambdaUpdate(ActivityFormCollectField.class).eq(ActivityFormCollectField::getActivityFormCode, activityFormEntity.getActivityFormCode()));
        this.activityFormExeDetailRepository.remove(Wrappers.lambdaUpdate(ActivityFormExeDetail.class).eq(ActivityFormExeDetail::getActivityFormCode, activityFormEntity.getActivityFormCode()));
        this.subRelatedMainActivityFormRepository.remove(Wrappers.lambdaUpdate(SubRelatedMainActivityForm.class).eq(SubRelatedMainActivityForm::getSubFormCode,activityForm.getActivityFormName()));
        //活动采集明细
        if (!CollectionUtils.isEmpty(activityForm.getActivityFormExeDetailList())) {
            activityForm.getActivityFormExeDetailList().forEach(item -> {
                item.setId(null);
                item.setActivityFormCode(activityFormEntity.getActivityFormCode());
                item.setTenantCode(TenantUtils.getTenantCode());
                ActivityFormExeDetail entity = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityFormExeDetail.class, null, null);
                this.activityFormExeDetailRepository.save(entity);
                //活动形式照片采集
                if (!CollectionUtils.isEmpty(activityForm.getActivityFormExeDetailList())) {
                    Collection<ActivityFormCollect> activityFormCollects = nebulaToolkitService.copyCollectionByBlankList(item.getActivityFormCollectDtoList(), ActivityFormCollectDto.class, ActivityFormCollect.class, LinkedHashSet.class, ArrayList.class);
                    activityFormCollects.forEach(item2 -> {
                        item2.setId(null);
                        item2.setActivityFormCode(activityFormEntity.getActivityFormCode());
                        item2.setTenantCode(TenantUtils.getTenantCode());
                        item2.setActivityFormExeDetailId(entity.getId());

                    });
                    activityFormCollectRepository.saveBatch(activityFormCollects);
                }
                //采集字段
                if (!CollectionUtils.isEmpty(item.getActivityFormCollectFieldDtoList())) {
                    Collection<ActivityFormCollectField> activityFormCollectFields = nebulaToolkitService.copyCollectionByBlankList(item.getActivityFormCollectFieldDtoList(), ActivityFormCollectFieldDto.class, ActivityFormCollectField.class, LinkedHashSet.class, ArrayList.class);
                    activityFormCollectFields.forEach(item2 -> {
                        item2.setId(null);
                        item2.setActivityFormCode(activityFormEntity.getActivityFormCode());
                        item2.setTenantCode(TenantUtils.getTenantCode());
                        item2.setActivityFormExeDetailId(entity.getId());

                    });
                    this.activityFormCollectFieldRepository.saveBatch(activityFormCollectFields);
                }
            });
        }

        if (!StringUtils.isBlank(activityForm.getSubMainActivityFormCode())) {
            String[] split = activityForm.getSubMainActivityFormCode().split(",");
            List<SubRelatedMainActivityForm> subRelatedMainFormList = new ArrayList<>(split.length);
            for (String s : split) {
                SubRelatedMainActivityForm related = new SubRelatedMainActivityForm();
                related.setSubFormCode(activityFormEntity.getActivityFormCode());
                related.setSubFormName(activityFormEntity.getActivityFormName());
                related.setMainFormCode(s);
                related.setTenantCode(TenantUtils.getTenantCode());
                subRelatedMainFormList.add(related);
            }
            this.subRelatedMainActivityFormRepository.saveBatch(subRelatedMainFormList);
        }

        //修改业务日志
        ActivityFormLogEventDto logEventDto = new ActivityFormLogEventDto();
        logEventDto.setOriginal(oldVo);
        logEventDto.setNewest(activityForm);
        SerializableBiConsumer<ActivityFormEventListener, ActivityFormLogEventDto> onUpdate =
                ActivityFormEventListener::onUpdate;
        this.nebulaNetEventClient.publish(logEventDto, ActivityFormEventListener.class, onUpdate);
    }

    @Override
    public void updateAuditCondition(ActivityFormDto activityForm) {
        if (activityForm == null || StringUtils.isEmpty(activityForm.getAuditCondition()) || StringUtils.isEmpty(activityForm.getId())){
            return;
        }
        this.activityFormRepository.lambdaUpdate().eq(UuidEntity::getId,activityForm.getId())
                .set(ActivityForm::getAuditCondition,activityForm.getAuditCondition()).update();
    }

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    @Transactional(rollbackFor = Exception.class)
    @Override
    public void delete(List<String> idList) {
        Validate.isTrue(!CollectionUtils.isEmpty(idList), "删除数据时，主键集合不能为空！");
        List<ActivityForm> activityForms1 = this.activityFormRepository.findByIdList(idList);
        Validate.isTrue(!CollectionUtils.isEmpty(activityForms1), "不存在或已删除!");
        ArrayList<ActivityForm> activityForms = new ArrayList<>();
        activityForms1.forEach(item -> {
            ActivityForm activityFormEntity = new ActivityForm();
            activityFormEntity.setId(item.getId());
            activityFormEntity.setDelFlag(DelFlagStatusEnum.DELETE.getCode());
            activityForms.add(activityFormEntity);

            //删除业务日志
            ActivityFormLogEventDto logEventDto = new ActivityFormLogEventDto();
            ActivityFormVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityFormVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            ActivityFormDto activityFormDto = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityFormDto.class, null, null);
            activityFormDto.setDelFlag(activityFormEntity.getDelFlag());
            logEventDto.setNewest(activityFormDto);
            SerializableBiConsumer<ActivityFormEventListener, ActivityFormLogEventDto> onDelete =
                    ActivityFormEventListener::onDelete;
            this.nebulaNetEventClient.publish(logEventDto, ActivityFormEventListener.class, onDelete);
        });
        this.activityFormRepository.updateBatchById(activityForms);
    }

    @Override
    public void enableBatch(List<String> ids) {

        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择要操作的数据");
        List<ActivityForm> activityForms = this.activityFormRepository.findByIdList(ids);
        Validate.isTrue(!CollectionUtils.isEmpty(activityForms), "不存在或已删除!");
        ArrayList<ActivityForm> activityFormsList = new ArrayList<>();
        activityForms.forEach(item -> {
            ActivityForm activityForm = new ActivityForm();
            activityForm.setId(item.getId());
            activityForm.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            activityFormsList.add(activityForm);

            //启用业务日志
            ActivityFormLogEventDto logEventDto = new ActivityFormLogEventDto();
            ActivityFormVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityFormVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            ActivityFormDto activityFormDto = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityFormDto.class, null, null);
            activityFormDto.setEnableStatus(activityForm.getEnableStatus());
            logEventDto.setNewest(activityFormDto);
            SerializableBiConsumer<ActivityFormEventListener, ActivityFormLogEventDto> onEnable =
                    ActivityFormEventListener::onEnable;
            this.nebulaNetEventClient.publish(logEventDto, ActivityFormEventListener.class, onEnable);
        });
        this.activityFormRepository.updateBatchById(activityFormsList);
    }

    @Override
    public void disableBatch(List<String> ids) {

        Validate.isTrue(!CollectionUtils.isEmpty(ids), "请选择要操作的数据");
        List<ActivityForm> activityForms = this.activityFormRepository.findByIdList(ids);
        Validate.isTrue(!CollectionUtils.isEmpty(activityForms), "不存在或已删除!");
        ArrayList<ActivityForm> activityFormsList = new ArrayList<>();
        activityForms.forEach(item -> {
            ActivityForm activityForm = new ActivityForm();
            activityForm.setId(item.getId());
            activityForm.setEnableStatus(EnableStatusEnum.DISABLE.getCode());
            activityFormsList.add(activityForm);

            //禁用业务日志
            ActivityFormLogEventDto logEventDto = new ActivityFormLogEventDto();
            ActivityFormVo oldVo = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityFormVo.class, null, null);
            logEventDto.setOriginal(oldVo);
            ActivityFormDto activityFormDto = this.nebulaToolkitService.copyObjectByWhiteList(item, ActivityFormDto.class, null, null);
            activityFormDto.setEnableStatus(activityForm.getEnableStatus());
            logEventDto.setNewest(activityFormDto);
            SerializableBiConsumer<ActivityFormEventListener, ActivityFormLogEventDto> onDisable =
                    ActivityFormEventListener::onDisable;
            this.nebulaNetEventClient.publish(logEventDto, ActivityFormEventListener.class, onDisable);
        });
        this.activityFormRepository.updateBatchById(activityFormsList);
    }

    @Override
    public List<ActivityFormVo> getList(ActivityFormDto activityForm) {

        List<ActivityForm> list = this.activityFormRepository.lambdaQuery().eq(ActivityForm::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityForm::getEnableStatus, EnableStatusEnum.ENABLE.getCode())
                .like(StringUtils.isNotEmpty(activityForm.getActivityFormName()), ActivityForm::getActivityFormName, activityForm.getActivityFormName())
                .eq(StringUtils.isNotEmpty(activityForm.getBusinessFormatCode()), ActivityForm::getBusinessFormatCode, activityForm.getBusinessFormatCode())
                .eq(StringUtils.isNotEmpty(activityForm.getBusinessUnitCode()), ActivityForm::getActivityFormCode, activityForm.getBusinessFormatCode())
                .list();
        if (!CollectionUtils.isEmpty(list)) {
            Collection<ActivityFormVo> activityFormVos = this.nebulaToolkitService.copyCollectionByBlankList(list, ActivityForm.class, ActivityFormVo.class, LinkedHashSet.class, ArrayList.class);
            return (List<ActivityFormVo>) activityFormVos;
        }
        return new ArrayList<>();
    }

    /**
     * 创建验证
     *
     * @param activityForm
     */
    private void createValidate(ActivityFormDto activityForm) {
        Validate.notNull(activityForm, "新增时，对象信息不能为空！");
        activityForm.setId(null);
        Validate.notBlank(activityForm.getActivityFormCode(), "新增数据时，活动形式编码不能为空！");
        Validate.notBlank(activityForm.getActivityFormName(), "新增数据时，活动形式名称不能为空！");
//        Validate.notBlank(activityForm.getAccountantCode(), "新增数据时，会计科目编码 不能为空！");
//        Validate.notBlank(activityForm.getAccountantName(), "新增数据时，会计科目名称不能为空！");
        Validate.notBlank(activityForm.getBusinessFormatCode(), "新增数据时，业态不能为空！");
        Validate.notBlank(activityForm.getBusinessUnitCode(), "新增数据时，业务单元不能为空！");
//        Validate.notBlank(activityForm.getThinProjectTemplate(), "新增数据时，选择细案模版不能为空！");
        Validate.notBlank(activityForm.getAuditWayCode(), "新增数据时，支付方式不能为空！");
        Validate.notNull(activityForm.getAllocationFeeToProduct(), "新增数据时，分摊费用到产品 不能为空！");
//        Validate.notNull(activityForm.getIsSupermarketDeductionItem(), "新增数据时，分摊费用到产品 不能为空！");
        Validate.notBlank(activityForm.getEnableStatus(), "新增数据时,启用禁用状态不能为空");
//        Validate.notNull(activityForm.getIsPushOtherPlatformExe(), "新增数据时，是否推送其他平台执行 不能为空！");
//        if (activityForm.getIsPushOtherPlatformExe()) {
//            Validate.notBlank(activityForm.getPushExeSystemCode(), "新增数据时，选择推送执行系统 不能为空！");
//
//            if (ExeSystemEnum.CHANNEL_APPLY_PLATFORM.getCode().equals(activityForm.getPushExeSystemCode())) {
//                Validate.notNull(activityForm.getIsCollectActivityData(), "是否采集活动数据不能为空");
//                Validate.isTrue(!CollectionUtils.isEmpty(activityForm.getActivityFormCollectFieldDtoList()), "采集字段不能为空");
//                Validate.notNull(activityForm.getIsCollectPicture(), "是否采集照片不能为空");
//                if (activityForm.getIsCollectPicture()) {
//                    Validate.isTrue(!CollectionUtils.isEmpty(activityForm.getActivityFormCollectDtoList()), "照片采集不能为空");
//                }
//                Validate.notNull(activityForm.getIsCollectDistributionOrder(), "是否采集分销订单不能为空");
//                Validate.notNull(activityForm.getIsCollectActivityFee(), "是否控制活动费用不能为空");
//            }
//        }
        Validate.notNull(activityForm.getIsPushPatrolSystem(), "新增数据时，是否推送巡查系统 不能为空！");
        if (activityForm.getIsPushPatrolSystem()) {
            Validate.notBlank(activityForm.getSelectPatrolSystemCode(), "新增数据时，选择巡查系统不能为空！");
            //当“业务单元”选择“垂直重客”且“选择巡查系统”选择“牛人管家”时，“垂直活动类型”必填
            if(BusinessUnitEnum.VERTICAL.getCode().equals(activityForm.getBusinessUnitCode())){
                List<String> patrolSystemCodeList = Arrays.asList(activityForm.getSelectPatrolSystemCode().split(","));
                if(patrolSystemCodeList.contains(SelectPatrolSystemEnum.COW_MANAGER.getCode())){
                    Validate.notBlank(activityForm.getVerticalActivityType(), "新增数据时，垂直活动类型不能为空！");
                }
            }
        }
//        Validate.notNull(activityForm.getActivityFormAuditDtoList(), "新增数据时，核销资料不能为空！");
        activityForm.getActivityFormAuditDtoList().forEach(item -> {
            Validate.notNull(item, "新增时，对象信息不能为空！");
            item.setId(null);
//            Validate.notBlank(item.getTenantCode(), "新增数据时，租户编号不能为空！");
            Validate.notBlank(item.getAuditDataCode(), "新增数据时，核销资料code不能为空！");
        });
//        Validate.notBlank(activityForm.getAuditType(), "新增数据时，核销方式不能为空！");
        Validate.notNull(activityForm.getIsMoreAudit(), "新增数据时，允许多次核销不能为空！");
//        Validate.notBlank(activityForm.getAuditCondition(), "核销条件不能为空");

        ActivityForm one = this.activityFormRepository.lambdaQuery().eq(ActivityForm::getActivityFormName, activityForm.getActivityFormName())
                .eq(ActivityForm::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
        Validate.isTrue(Objects.isNull(one), "活动形式名称已经存在");

        one = this.activityFormRepository.lambdaQuery().eq(ActivityForm::getActivityFormCode, activityForm.getActivityFormCode())
                .eq(ActivityForm::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
        Validate.isTrue(Objects.isNull(one), "活动形式编码已经存在");

    }

    /**
     * 修改验证
     *
     * @param activityForm
     */
    private void updateValidate(ActivityFormDto activityForm) {
        Validate.notNull(activityForm, "修改时，对象信息不能为空！");
        Validate.notBlank(activityForm.getId(), "新增数据时，不能为空！");
        Validate.notBlank(activityForm.getActivityFormCode(), "新增数据时，活动形式编码不能为空！");
        Validate.notBlank(activityForm.getActivityFormName(), "新增数据时，活动形式名称不能为空！");
//        Validate.notBlank(activityForm.getAccountantCode(), "新增数据时，会计科目编码 不能为空！");
//        Validate.notBlank(activityForm.getAccountantName(), "新增数据时，会计科目名称不能为空！");
        Validate.notBlank(activityForm.getBusinessFormatCode(), "新增数据时，业态不能为空！");
        Validate.notBlank(activityForm.getBusinessUnitCode(), "新增数据时，业务单元不能为空！");
//        Validate.notBlank(activityForm.getThinProjectTemplate(), "新增数据时，选择细案模版不能为空！");
        Validate.notBlank(activityForm.getAuditWayCode(), "新增数据时，支付方式不能为空！");
        Validate.notNull(activityForm.getAllocationFeeToProduct(), "新增数据时，分摊费用到产品 不能为空！");
//        Validate.notNull(activityForm.getIsSupermarketDeductionItem(), "新增数据时，分摊费用到产品 不能为空！");
        Validate.notBlank(activityForm.getEnableStatus(), "新增数据时,启用禁用状态不能为空");
//        Validate.notNull(activityForm.getIsPushOtherPlatformExe(), "新增数据时，是否推送其他平台执行 不能为空！");
//        if (activityForm.getIsPushOtherPlatformExe()) {
//            Validate.notBlank(activityForm.getPushExeSystemCode(), "新增数据时，选择推送执行系统 不能为空！");
//
//            if (ExeSystemEnum.CHANNEL_APPLY_PLATFORM.getCode().equals(activityForm.getPushExeSystemCode())) {
//                Validate.notNull(activityForm.getIsCollectActivityData(), "是否采集活动数据不能为空");
//                Validate.isTrue(!CollectionUtils.isEmpty(activityForm.getActivityFormCollectFieldDtoList()), "采集字段不能为空");
//                Validate.notNull(activityForm.getIsCollectPicture(), "是否采集照片不能为空");
//                if (activityForm.getIsCollectPicture()) {
//                    Validate.isTrue(!CollectionUtils.isEmpty(activityForm.getActivityFormCollectDtoList()), "照片采集不能为空");
//                }
//                Validate.notNull(activityForm.getIsCollectDistributionOrder(), "是否采集分销订单不能为空");
//                Validate.notNull(activityForm.getIsCollectActivityFee(), "是否控制活动费用不能为空");
//            }
//        }
        Validate.notNull(activityForm.getIsPushPatrolSystem(), "新增数据时，是否推送巡查系统 不能为空！");
        if (activityForm.getIsPushPatrolSystem()) {
            Validate.notBlank(activityForm.getSelectPatrolSystemCode(), "新增数据时，选择巡查系统不能为空！");
            //当“业务单元”选择“垂直重客”且“选择巡查系统”选择“牛人管家”时，“垂直活动类型”必填
            if(BusinessUnitEnum.VERTICAL.getCode().equals(activityForm.getBusinessUnitCode())){
                List<String> patrolSystemCodeList = Arrays.asList(activityForm.getSelectPatrolSystemCode().split(","));
                if(patrolSystemCodeList.contains(SelectPatrolSystemEnum.COW_MANAGER.getCode())){
                    Validate.notBlank(activityForm.getVerticalActivityType(), "新增数据时，垂直活动类型不能为空！");
                }
            }
        }
//        Validate.notNull(activityForm.getActivityFormAuditDtoList(), "新增数据时，核销资料不能为空！");
        activityForm.getActivityFormAuditDtoList().forEach(item -> {
            Validate.notNull(item, "新增时，对象信息不能为空！");
            item.setId(null);
//            Validate.notBlank(item.getTenantCode(), "新增数据时，租户编号不能为空！");
            Validate.notBlank(item.getAuditDataCode(), "新增数据时，核销资料code不能为空！");
        });
//        Validate.notBlank(activityForm.getAuditType(), "新增数据时，核销方式不能为空！");
        Validate.notNull(activityForm.getIsMoreAudit(), "新增数据时，允许多次核销不能为空！");
//        Validate.notBlank(activityForm.getAuditCondition(), "核销条件不能为空");

        ActivityForm one = this.activityFormRepository.getById(activityForm.getId());
        Validate.notNull(one, "要更新的数据不存在");

        one = this.activityFormRepository.lambdaQuery().eq(ActivityForm::getActivityFormCode, activityForm.getActivityFormCode())
                .ne(ActivityForm::getId, activityForm.getId()).eq(ActivityForm::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();

        Validate.isTrue(Objects.isNull(one), "活动形式编码已经存在");
    }

    /**
     * 活动形式下拉
     *
     * @param dto 活动形式查询参数
     * @return 活动形式下拉数据
     */
    @Override
    public List<CommonSelectVo> findActivityFormSelectList(ActivityFormSelectDto dto) {
        if (ActivityFormConstant.UNIT_DS.equals(dto.getType())) {
            DictDataVo dictDataVo = dictDataVoService.findByDictTypeCode(ActivityFormConstant.MDM_BUSINESS_UNIT).stream().filter(e ->
                    ActivityFormConstant.DS.equals(e.getDictValue())).findFirst().orElse(null);
            Validate.notNull(dictDataVo, "数据字典：业务单元，未维护");
            dto.setBusinessUnitCode(dictDataVo.getDictCode());
        }
        return activityFormRepository.findActivityFormSelectList(dto);
    }

    /**
     * 活动形式下拉（分子公司规划、细案用）
     *
     * @param dto
     * @return java.util.List<com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo>
     * @author huojia
     * @date 2022/12/28 14:15
     **/
    @Override
    public List<ActivityFormVo> findSelectList(ActivityFormSelectDto dto) {
        List<ActivityFormVo> activityFormVos = activityFormRepository.findSelectList(dto);
        if (CollectionUtils.isEmpty(activityFormVos)) {
            return activityFormVos;
        }
        Set<String> activityFormCodeList = activityFormVos.stream().map(ActivityFormVo::getActivityFormCode).collect(Collectors.toSet());
        List<ActivityFormExeDetail> activityFormExeDetails = activityFormExeDetailRepository.listByActivityFormCode(new ArrayList<>(activityFormCodeList));
        if (!CollectionUtils.isEmpty(activityFormExeDetails)) {
            Map<String, List<ActivityFormExeDetail>> activityFormExeDetailMap = activityFormExeDetails.stream().collect(Collectors.groupingBy(ActivityFormExeDetail::getActivityFormCode));
            activityFormVos.forEach(activityFormVo -> {
                if (activityFormExeDetailMap.containsKey(activityFormVo.getActivityFormCode())) {
                    List<ActivityFormExeDetailVo> activityFormExeDetailVos = (List<ActivityFormExeDetailVo>) this.nebulaToolkitService.copyCollectionByWhiteList(
                            activityFormExeDetailMap.get(activityFormVo.getActivityFormCode()), ActivityFormExeDetail.class, ActivityFormExeDetailVo.class, LinkedHashSet.class, ArrayList.class
                    );
                    Set<String> auditTypeSet = activityFormExeDetailVos.stream().map(ActivityFormExeDetailVo::getAuditType).collect(Collectors.toSet());
                    activityFormVo.setAuditTypeList(new ArrayList<>(auditTypeSet));
                    activityFormVo.setActivityFormExeDetailList(activityFormExeDetailVos);
                }
            });
        }
        return activityFormVos;
    }

    @Override
    public List<ActivityFormVo> findActivityFormByCode(Set<String> activityFormCodes) {
        Validate.isTrue(!CollectionUtils.isEmpty(activityFormCodes), "活动形式code不能为空");
        List<ActivityForm> list = activityFormRepository.lambdaQuery().in(ActivityForm::getActivityFormCode, activityFormCodes).eq(ActivityForm::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .eq(ActivityForm::getEnableStatus, EnableStatusEnum.ENABLE.getCode()).list();
        List<ActivityFormCollect> activityFormCollectList = this.activityFormCollectRepository.lambdaQuery().in(ActivityFormCollect::getActivityFormCode, activityFormCodes).list();

        Map<String, MnApprovalCollectVo> mnApprovalCollectVoMap = new HashMap<>();
        Map<String, List<ActivityFormCollect>> activityFormCollectMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(activityFormCollectList)) {
            Set<String> collectDataCodeSets = activityFormCollectList.stream().map(ActivityFormCollect::getCollectDataCode).collect(Collectors.toSet());
            List<MnApprovalCollectVo> mnApprovalCollectVoList = mnApprovalCollectVoService.findDetailsByCodes(collectDataCodeSets);

            mnApprovalCollectVoMap = mnApprovalCollectVoList.stream().collect(Collectors.toMap(MnApprovalCollectVo::getCode, Function.identity()));
            activityFormCollectMap = activityFormCollectList.stream().collect(Collectors.groupingBy(ActivityFormCollect::getActivityFormExeDetailId));
        }

        List<ActivityFormExeDetail> activityFormExeDetailList = this.activityFormExeDetailRepository.lambdaQuery().in(ActivityFormExeDetail::getActivityFormCode, activityFormCodes).list();
        Map<String, List<ActivityFormExeDetail>> activityFormExeDetailMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(activityFormExeDetailList)) {
            activityFormExeDetailMap = activityFormExeDetailList.stream().collect(Collectors.groupingBy(ActivityFormExeDetail::getActivityFormCode));
        }

        List<ActivityFormAudit> activityFormAuditList = this.activityFormAuditRepository.lambdaQuery().in(ActivityFormAudit::getActivityFormCode, activityFormCodes).list();
        Map<String, MnApprovalCollectVo> mnApprovalCollectVoMap2 = new HashMap<>();
        Map<String, List<ActivityFormAudit>> activityFormAuditMap = new HashMap<>();
        if (!CollectionUtils.isEmpty(activityFormAuditList)) {
            Set<String> auditDataCodeSets = activityFormAuditList.stream().map(ActivityFormAudit::getAuditDataCode).collect(Collectors.toSet());
            List<MnApprovalCollectVo> mnApprovalCollectVoList = mnApprovalCollectVoService.findDetailsByCodes(auditDataCodeSets);
            mnApprovalCollectVoMap2 = mnApprovalCollectVoList.stream().collect(Collectors.toMap(MnApprovalCollectVo::getCode, Function.identity()));
            activityFormAuditMap = activityFormAuditList.stream().collect(Collectors.groupingBy(ActivityFormAudit::getActivityFormCode));
        }
        if (!CollectionUtils.isEmpty(list)) {
            Collection<ActivityFormVo> activityFormVos = this.nebulaToolkitService.copyCollectionByBlankList(list, ActivityForm.class, ActivityFormVo.class, LinkedHashSet.class, ArrayList.class);
            for (ActivityFormVo activityFormVo : activityFormVos) {
                List<ActivityFormExeDetail> activityFormExeDetails = activityFormExeDetailMap.get(activityFormVo.getActivityFormCode());
                if (!CollectionUtils.isEmpty(activityFormExeDetails)) {
                    Collection<ActivityFormExeDetailVo> activityFormExeDetailVos = this.nebulaToolkitService.copyCollectionByBlankList(activityFormExeDetails, ActivityFormExeDetail.class, ActivityFormExeDetailVo.class, LinkedHashSet.class, ArrayList.class);
                    for (ActivityFormExeDetailVo activityFormExeDetailVo : activityFormExeDetailVos) {
                        List<ActivityFormCollect> activityFormCollects = activityFormCollectMap.get(activityFormExeDetailVo.getId());
                        if (!CollectionUtils.isEmpty(activityFormCollects)) {
                            Collection<ActivityFormCollectVo> activityFormCollectVos = this.nebulaToolkitService.copyCollectionByBlankList(activityFormCollects, ActivityFormCollect.class, ActivityFormCollectVo.class, LinkedHashSet.class, ArrayList.class);
                            for (ActivityFormCollectVo activityFormCollectVo : activityFormCollectVos) {
                                MnApprovalCollectVo mnApprovalCollectVo = mnApprovalCollectVoMap.get(activityFormCollectVo.getCollectDataCode());
                                activityFormCollectVo.setMnApprovalCollect(mnApprovalCollectVo);
                            }
                            activityFormExeDetailVo.setActivityFormCollectDtoList((List<ActivityFormCollectVo>) activityFormCollectVos);
                        }
                    }
                    activityFormVo.setActivityFormExeDetailList((List<ActivityFormExeDetailVo>) activityFormExeDetailVos);
                }
                List<ActivityFormAudit> activityFormAudits = activityFormAuditMap.get(activityFormVo.getActivityFormCode());
                if (!CollectionUtils.isEmpty(activityFormAudits)) {
                    Collection<ActivityFormAuditDto> activityFormAuditDtos = this.nebulaToolkitService.copyCollectionByBlankList(activityFormAudits, ActivityFormAudit.class, ActivityFormAuditDto.class, LinkedHashSet.class, ArrayList.class);
                    for (ActivityFormAuditDto activityFormAuditDto : activityFormAuditDtos) {
                        MnApprovalCollectVo mnApprovalCollectVo = mnApprovalCollectVoMap2.get(activityFormAuditDto.getAuditDataCode());
                        activityFormAuditDto.setMnApprovalCollect(mnApprovalCollectVo);
                    }
                    activityFormVo.setActivityFormAuditDtoList((List<ActivityFormAuditDto>) activityFormAuditDtos);
                }
            }
            return (List<ActivityFormVo>) activityFormVos;
        }
        return new ArrayList<>();
    }

    @Override
    public ActivityFormVo findOneByCode(String code) {
        if(StringUtils.isEmpty(code)){
            return null;
        }
        ActivityForm one = this.activityFormRepository.lambdaQuery()
                .eq(ActivityForm::getActivityFormCode, code)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .one();
        if(one==null){
            return null;
        }
        ActivityFormVo activityFormVo = this.nebulaToolkitService.copyObjectByWhiteList(one, ActivityFormVo.class, null, null);
        return activityFormVo;
    }

    @Override
    public List<ActivityFormVo> findByCodes(List<String> codes) {
        if(CollectionUtils.isEmpty(codes)){
            return Lists.newArrayList();
        }
        List<ActivityForm> list = this.activityFormRepository.lambdaQuery()
                .in(ActivityForm::getActivityFormCode, codes)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        Collection<ActivityFormVo> activityFormVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, ActivityForm.class, ActivityFormVo.class, HashSet.class, ArrayList.class);
        return new ArrayList<>(activityFormVos);
    }

    /**
     * 活动形式SAP编码为ZS03
     *
     * @param formCodes
     * @return
     */
    @Override
    public List<String> findFormByCodesZs03(List<List<String>> formCodes) {
        if (CollectionUtils.isEmpty(formCodes)) {
            return new ArrayList<>();
        }
        List<String> list = activityFormRepository.findFormByCodesZs03(formCodes, TenantUtils.getTenantCode());
        return !CollectionUtils.isEmpty(list) ? list : new ArrayList<>();
    }

    /**
     * 通过code查询活动形式
     * @param names
     * @return
     */
    @Override
    public List<ActivityFormVo> findByNames(List<String> names) {
        if(CollectionUtils.isEmpty(names)){
            return Lists.newArrayList();
        }
        List<ActivityForm> list = this.activityFormRepository.lambdaQuery()
                .in(ActivityForm::getActivityFormName, names)
                .eq(UuidFlagOpEntity::getDelFlag, DelFlagStatusEnum.NORMAL.getCode())
                .list();
        if(CollectionUtils.isEmpty(list)){
            return Lists.newArrayList();
        }
        Collection<ActivityFormVo> activityFormVos = this.nebulaToolkitService.copyCollectionByWhiteList(list, ActivityForm.class, ActivityFormVo.class, HashSet.class, ArrayList.class);
        return new ArrayList<>(activityFormVos);
    }

    /**
     * 查询所有需推送订单共享平台的活动形式
     *
     * @return
     */
    @Override
    public Map<String, List<ActivityFormExeDetailVo>> findPushOrderSharePlatform(List<String> fromCodes) {
        if (CollectionUtils.isEmpty(fromCodes)) {
            return Maps.newHashMap();
        }
        List<ActivityFormExeDetail> exeDetailList = this.activityFormExeDetailRepository.findPushOtherPlatform(fromCodes);
        if (CollectionUtils.isEmpty(exeDetailList)) {
            return Maps.newHashMap();
        }
        List<ActivityFormExeDetailVo> pushOrderList = new ArrayList<>();

        for (ActivityFormExeDetail exeDetail : exeDetailList) {
            String exeSystemCode = exeDetail.getPushExeSystemCode();
            if (!StringUtils.isBlank(exeSystemCode)) {
                String[] split = exeSystemCode.split(",");
                for (String str : split) {
                    if (ExeSystemEnum.ORDER_SHARE_PLATFORM.getCode().equals(str)) {
                        ActivityFormExeDetailVo exeVo = nebulaToolkitService.copyObjectByWhiteList(exeDetail, ActivityFormExeDetailVo.class, HashSet.class, ArrayList.class);
                        pushOrderList.add(exeVo);
                    }
                }
            }
        }
        if (CollectionUtils.isEmpty(pushOrderList)) {
            return Maps.newHashMap();
        }
        Map<String, List<ActivityFormExeDetailVo>> map = pushOrderList.stream().collect(Collectors.groupingBy(ActivityFormExeDetailVo::getActivityFormCode));

        return map;
    }

    /**
     * 查询所有需推送SAP的活动形式
     *
     * @return
     */
    @Override
    public Map<String, List<ActivityFormExeDetailVo>> findPushSap(List<String> formCodes) {
        if (CollectionUtils.isEmpty(formCodes)) {
            return Maps.newHashMap();
        }
        List<ActivityFormExeDetail> exeDetailList = this.activityFormExeDetailRepository.findPushOtherPlatform(formCodes);
        if (CollectionUtils.isEmpty(exeDetailList)) {
            return Maps.newHashMap();
        }
        List<ActivityFormExeDetailVo> pushSapList = new ArrayList<>();
        for (ActivityFormExeDetail exeDetail : exeDetailList) {
            String exeSystemCode = exeDetail.getPushExeSystemCode();
            if (!StringUtils.isBlank(exeSystemCode)) {
                for (String str : exeSystemCode.split(",")) {
                    if (ExeSystemEnum.SAP.getCode().equalsIgnoreCase(str)) {
                        ActivityFormExeDetailVo exeDetailVo = nebulaToolkitService.copyObjectByWhiteList(exeDetail, ActivityFormExeDetailVo.class, HashSet.class, ArrayList.class);
                        pushSapList.add(exeDetailVo);
                    }
                }
            }
        }
        if (CollectionUtils.isEmpty(pushSapList)) {
            return Maps.newHashMap();
        }
        Map<String, List<ActivityFormExeDetailVo>> map = pushSapList.stream().collect(Collectors.groupingBy(ActivityFormExeDetailVo::getActivityFormCode));
        return map;
    }

    /**
     * 查询活动形式对应的SAP编码
     * @param formCodes 活动形式编码集合
     * @return
     */
    @Override
    public Map<String, String> findSapCode(List<String> formCodes) {
        if (CollectionUtils.isEmpty(formCodes)) {
            return Maps.newHashMap();
        }
        List<ActivityForm> list = activityFormRepository.findSapCodeByCodes(formCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        Map<String,String> map = new HashMap<>();
        list.forEach( form ->{
            if(!StringUtils.isBlank(form.getSapCode())){
                map.put(form.getActivityFormCode(),form.getSapCode());
            }
        });
        return map;
    }

    /**
     * 根据活动形式编码获取有效的活动形式信息
     *
     * @param formCodes 活动形式编码列表
     * @return Map<String, String>
     */
    @Override
    public Map<String, String> findFormByCodes(List<List<String>> formCodes) {
        if (CollectionUtils.isEmpty(formCodes)) {
            return Maps.newHashMap();
        }
        List<ActivityFormCodeAndNameVo> list = activityFormRepository.findFormByCodes(formCodes, TenantUtils.getTenantCode());
        if (CollectionUtils.isEmpty(list)) {
            return Maps.newHashMap();
        }
        return list.stream().collect(Collectors.toMap(ActivityFormCodeAndNameVo::getActivityFormCode, ActivityFormCodeAndNameVo::getActivityFormName));
    }

    /**
     * 活动形式SAP编码为ZS42
     *
     * @param formCodes
     * @return
     */
    @Override
    public List<String> findFormByCodesZs42(List<List<String>> formCodes) {
        if (CollectionUtils.isEmpty(formCodes)) {
            return new ArrayList<>();
        }
        List<String> list = activityFormRepository.findFormByCodesZs42(formCodes, TenantUtils.getTenantCode());
        return !CollectionUtils.isEmpty(list) ? list : new ArrayList<>();
    }

    /**
     * 查询所有需推送牛人管家的活动形式编码
     * @return 活动形式编码集合
     */
    @Override
    public Map<String,String> findPushCowManager() {
        List<ActivityForm> activityFormList = this.activityFormRepository.findPushCowManager();
        if (CollectionUtils.isEmpty(activityFormList)) {
            return null;
        }
        Map<String,String> formMap = new HashMap<>(activityFormList.size());
        activityFormList.forEach( activityForm -> {
            String systemCodes = activityForm.getSelectPatrolSystemCode();
            String[] split = systemCodes.split(",");
            for(String str : split){
                if (SelectPatrolSystemEnum.COW_MANAGER.getCode().equals(str)){
                    formMap.put(activityForm.getActivityFormCode(),activityForm.getVerticalActivityType());
                }
            }
        });
        return formMap;
    }

    /**
     * 更据主体活动形式编码查询对应分子活动形式
     *
     * @param mainFormCodes
     * @return
     */
    @Override
    public List<SubRelatedMainActivityFormVo> findSubRelatedMainByCodes(List<String> mainFormCodes) {
        if (CollectionUtils.isEmpty(mainFormCodes)) {
            return Lists.newArrayList();
        }
        List<SubRelatedMainActivityFormVo> list = this.subRelatedMainActivityFormRepository.findSubRelatedMainByCodes(mainFormCodes);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    @Override
    public ActivityFormVo findFormAndRelatedTypeCode(String activityFormCode,String tenantCode) {
        if (StringUtils.isBlank(activityFormCode) || StringUtils.isBlank(tenantCode)) {
            return null;
        }
        return this.activityFormRepository.findFormAndRelatedTypeCode(activityFormCode,tenantCode);
    }

    @Override
    public List<ActivityFormVo> findFormAndRelatedTypeCodes(List<String> activityFormCodes, String tenantCode) {
        if (CollectionUtils.isEmpty(activityFormCodes)) {
            return Lists.newArrayList();
        }
        List<ActivityFormVo> list = this.activityFormRepository.findFormAndRelatedTypeCodes(activityFormCodes,tenantCode);
        if (CollectionUtils.isEmpty(list)) {
            return Lists.newArrayList();
        }
        return list;
    }

    @Override
    public List<String> findActivityFormCodeFromPromotionsType(String businessUnitCode,String verticalActivityType,String pushExeSystemCode) {
        return this.activityFormRepository.findActivityFormCodeFromPromotionsType(businessUnitCode,verticalActivityType,pushExeSystemCode);
    }

    @Override
    public Page<ActivityFormPopEctVo> findActivityFormPopEct(Pageable pageable, ActivityFormPopEctDto activityFormPopEctDto) {
        activityFormPopEctDto.setTenantCode(TenantUtils.getTenantCode());
        return this.activityFormRepository.findActivityFormPopEct(pageable, activityFormPopEctDto);
    }
}

