/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.form.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.mn.common.base.util.DataTooLongGenerateRespUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityForm;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormPopEctDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.form.sdk.service.ActivityFormService;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormPopEctVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.SubRelatedMainActivityFormVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PatchMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/activityForm"})
@Api(tags={"\u6d3b\u52a8\u5f62\u5f0f"})
public class ActivityFormController {
    private static final Logger log = LoggerFactory.getLogger(ActivityFormController.class);
    @Autowired(required=false)
    private ActivityFormService activityFormService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"findByConditions"})
    public Result<Page<ActivityFormVo>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityForm", value="\u6d3b\u52a8\u5f62\u5f0f") ActivityFormDto activityForm) {
        try {
            Page page = this.activityFormService.findByConditions(pageable, activityForm);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"{id}"})
    public Result<ActivityFormVo> findById(@PathVariable @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            ActivityFormVo activityForm = this.activityFormService.findById(id);
            return Result.ok((Object)activityForm);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952e\u67e5\u8be2\u5355\u6761\u6570\u636e")
    @GetMapping(value={"/findByCode"})
    public Result<ActivityFormVo> findByCode(@RequestParam(value="code") @ApiParam(name="code", value="\u4e3b\u952eid") String code) {
        try {
            ActivityFormVo activityForm = this.activityFormService.findOneByCode(code);
            return Result.ok((Object)activityForm);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u65b0\u589e\u6570\u636e")
    @PostMapping
    public Result<ActivityFormVo> create(@ApiParam(name="activityForm", value="\u6d3b\u52a8\u5f62\u5f0f") @RequestBody ActivityFormDto activityForm) {
        try {
            ActivityFormVo result = this.activityFormService.create(activityForm);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)DataTooLongGenerateRespUtil.generateRespStr((Exception)e, ActivityForm.class));
        }
    }

    @ApiOperation(value="\u4fee\u6539\u6570\u636e")
    @PatchMapping
    public Result<?> update(@ApiParam(name="activityForm", value="\u6d3b\u52a8\u5f62\u5f0f") @RequestBody ActivityFormDto activityForm) {
        try {
            this.activityFormService.update(activityForm);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @PostMapping(value={"delete"})
    public Result<?> delete(@ApiParam(name="idList", value="\u4e3b\u952e\u96c6\u5408") @RequestBody List<String> idList) {
        try {
            this.activityFormService.delete(idList);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u542f\u7528", httpMethod="PATCH")
    @PatchMapping(value={"/enable"})
    public Result<?> enable(@RequestBody List<String> ids) {
        try {
            this.activityFormService.enableBatch(ids);
            return Result.ok((String)"\u542f\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="PATCH")
    @PatchMapping(value={"/disable"})
    public Result<?> disable(@RequestBody List<String> ids) {
        try {
            this.activityFormService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u7981\u7528", httpMethod="PATCH")
    @PostMapping(value={"/disablePos"})
    public Result<?> disablePos(@RequestBody List<String> ids) {
        try {
            this.activityFormService.disableBatch(ids);
            return Result.ok((String)"\u7981\u7528\u6210\u529f");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u4e0b\u62c9\u5217\u8868")
    @PostMapping(value={"getList"})
    public Result<List<ActivityFormVo>> getList(@RequestBody ActivityFormDto activityForm) {
        try {
            return Result.ok((Object)this.activityFormService.getList(activityForm));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u5f62\u5f0f\u4e0b\u62c9")
    @PostMapping(value={"findActivityFormSelectList"})
    public Result<List<CommonSelectVo>> findActivityFormSelectList(@ApiParam(name="CommonSelectDto", value="\u67e5\u8be2\u53c2\u6570") @RequestBody ActivityFormSelectDto dto) {
        try {
            List list = this.activityFormService.findActivityFormSelectList(dto);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6d3b\u52a8\u5f62\u5f0f\u4e0b\u62c9\uff08\u5206\u5b50\u516c\u53f8\u89c4\u5212\u3001\u7ec6\u6848\u7528\uff09")
    @PostMapping(value={"findSelectList"})
    public Result<List<ActivityFormVo>> findSelectList(@ApiParam(name="CommonSelectDto", value="\u67e5\u8be2\u53c2\u6570") @RequestBody ActivityFormSelectDto dto) {
        try {
            List list = this.activityFormService.findSelectList(dto);
            return Result.ok((Object)list);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u6d3b\u52a8\u5f62\u5f0fcode\u67e5\u8be2\u6d3b\u52a8\u5f62\u5f0f")
    @PostMapping(value={"findActivityFormByCode"})
    public Result<List<ActivityFormVo>> findActivityFormByCode(@RequestBody Set<String> activityFormCodes) {
        try {
            return Result.ok((Object)this.activityFormService.findActivityFormByCode(activityFormCodes));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7code\u67e5\u8be2\u6d3b\u52a8\u5f62\u5f0f")
    @GetMapping(value={"findOneByCode"})
    public Result<ActivityFormVo> findOneByCode(@RequestParam(value="code") String code) {
        try {
            return Result.ok((Object)this.activityFormService.findOneByCode(code));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u6839\u636e\u6d3b\u52a8\u5f62\u5f0f\u7f16\u7801\u83b7\u53d6\u6709\u6548\u7684\u6d3b\u52a8\u5f62\u5f0f\u4fe1\u606f")
    @PostMapping(value={"findFormByCodes"})
    public Result<Map<String, String>> findFormByCodes(@RequestBody List<List<String>> formCodes) {
        try {
            Map map = this.activityFormService.findFormByCodes(formCodes);
            return Result.ok((Object)map);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="testtest")
    @PostMapping(value={"testtset"})
    public Result<List<SubRelatedMainActivityFormVo>> test(@RequestBody List<String> formCodes) {
        try {
            List subRelatedMainByCodes = this.activityFormService.findSubRelatedMainByCodes(formCodes);
            return Result.ok((Object)subRelatedMainByCodes);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u91cd\u5ba2\u5782\u76f4\u7684\u6d3b\u52a8\u5f62\u5f0f\uff0cect\u7cfb\u7edf\u7528")
    @GetMapping(value={"findActivityFormPopEct"})
    public Result<Page<ActivityFormPopEctVo>> findActivityFormPopEct(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=50) Pageable pageable, @ApiParam(name="activityFormPopEctDto", value="\u6d3b\u52a8\u5f62\u5f0f") ActivityFormPopEctDto activityFormPopEctDto) {
        try {
            Page page = this.activityFormService.findActivityFormPopEct(pageable, activityFormPopEctDto);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

