/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.form.local.service.internal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.form.local.entity.ActivityFormAudit;
import com.biz.crm.tpm.business.activity.form.local.repository.ActivityFormAuditRepository;
import com.biz.crm.tpm.business.activity.form.local.service.ActivityFormAuditService;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;

@Service(value="activityFormAuditService")
public class ActivityFormAuditServiceImpl
implements ActivityFormAuditService {
    @Autowired
    private ActivityFormAuditRepository activityFormAuditRepository;

    @Override
    public Page<ActivityFormAudit> findByConditions(Pageable pageable, ActivityFormAudit activityFormAudit) {
        pageable = (Pageable)ObjectUtils.defaultIfNull((Object)pageable, (Object)PageRequest.of((int)1, (int)50));
        if (Objects.isNull((Object)activityFormAudit)) {
            activityFormAudit = new ActivityFormAudit();
        }
        return this.activityFormAuditRepository.findByConditions(pageable, activityFormAudit);
    }

    @Override
    public ActivityFormAudit findById(String id) {
        if (StringUtils.isBlank((CharSequence)id)) {
            return null;
        }
        return (ActivityFormAudit)((Object)this.activityFormAuditRepository.getById((Serializable)((Object)id)));
    }

    @Override
    public List<ActivityFormAudit> findByAuditDataCode(String auditDataCode) {
        if (StringUtils.isBlank((CharSequence)auditDataCode)) {
            return Collections.emptyList();
        }
        return this.activityFormAuditRepository.findByAuditDataCode(auditDataCode);
    }

    @Override
    @Transactional
    public ActivityFormAudit create(ActivityFormAudit activityFormAudit) {
        this.createValidate(activityFormAudit);
        this.activityFormAuditRepository.saveOrUpdate((Object)activityFormAudit);
        return activityFormAudit;
    }

    @Override
    @Transactional
    public ActivityFormAudit update(ActivityFormAudit activityFormAudit) {
        this.updateValidate(activityFormAudit);
        this.activityFormAuditRepository.saveOrUpdate((Object)activityFormAudit);
        return activityFormAudit;
    }

    @Override
    @Transactional
    public void delete(List<String> idList) {
        Validate.isTrue((!CollectionUtils.isEmpty(idList) ? 1 : 0) != 0, (String)"\u5220\u9664\u6570\u636e\u65f6\uff0c\u4e3b\u952e\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        this.activityFormAuditRepository.removeByIds(idList);
    }

    private void createValidate(ActivityFormAudit activityFormAudit) {
        Validate.notNull((Object)((Object)activityFormAudit), (String)"\u65b0\u589e\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        activityFormAudit.setId(null);
        Validate.notBlank((CharSequence)activityFormAudit.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityFormAudit.getAuditDataCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u8d44\u6599code\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }

    private void updateValidate(ActivityFormAudit activityFormAudit) {
        Validate.notNull((Object)((Object)activityFormAudit), (String)"\u4fee\u6539\u65f6\uff0c\u5bf9\u8c61\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityFormAudit.getId(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityFormAudit.getTenantCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u79df\u6237\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)activityFormAudit.getAuditDataCode(), (String)"\u65b0\u589e\u6570\u636e\u65f6\uff0c\u6838\u9500\u8d44\u6599code\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
    }
}

