package com.biz.crm.tpm.business.activity.form.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.persistence.Column;
import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/10/25 11:23
 * @description：活动形式dto
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "活动形式dto")
public class ActivityFormDto extends TenantFlagOpDto {
    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    @ApiModelProperty("活动形式Code")
    private String activityFormCode;

    private List<String> activityFormCodeList;

    @ApiModelProperty("会计科目编码")
    private String accountantCode;

    @ApiModelProperty("会计科目名称")
    private String accountantName;

    @ApiModelProperty("业态[数据字典:mdm_business_format]")
    private String businessFormatCode;

    @ApiModelProperty("分摊费用到产品")
    private Boolean allocationFeeToProduct;

    @ApiModelProperty("是否为商超扣费项")
    private Boolean isSupermarketDeductionItem;

    @ApiModelProperty("是否和价格相关")
    private Boolean isRelatePrice;

    @ApiModelProperty("差异费用处理模版")
    private String diffCostDisposeTemplate;

    @ApiModelProperty("利润表项目")
    private String profitTableItem;

    @ApiModelProperty("业务单元[数据字典:mdm_business_unit]")
    private String businessUnitCode;

    @ApiModelProperty("业务单元名称")
    private String businessUnitName;

    @ApiModelProperty("选择细案模版")
    private String thinProjectTemplate;

    @ApiModelProperty("结案方式")
    private String auditWayCode;

    @ApiModelProperty("结案方式名称")
    private String auditWayName;

    @ApiModelProperty("是否推送巡查系统【数据字典：patrol_system】")
    private Boolean isPushPatrolSystem;

    @ApiModelProperty("是否自动核销")
    private Boolean isAutoAudit;

    @ApiModelProperty("是否允许超额核销")
    private Boolean isAllowExcessAudit;

    @ApiModelProperty("选择巡查系统")
    private String selectPatrolSystemCode;

    @ApiModelProperty("垂直活动类型")
    private String verticalActivityType;

    @ApiModelProperty("允许多次核销")
    private Boolean isMoreAudit;

    @ApiModelProperty("核销有效期（月）")
    private String auditValidDate;

    @ApiModelProperty("核销条件")
    private String auditCondition;

    @ApiModelProperty("申请维度")
    private String applyDimensionality;

    @ApiModelProperty("sap编码")
    private String sapCode;

    @ApiModelProperty("拆分客户数据源")
    private String splitCustomerDataSource;

    @ApiModelProperty("活动执行明细")
    private List<ActivityFormExeDetailDto> activityFormExeDetailList;

    @ApiModelProperty("核销资料")
    private List<ActivityFormAuditDto> activityFormAuditDtoList;

    @ApiModelProperty(name = "对应主体活动形式编码（分子活动形式使用）")
    private String subMainActivityFormCode;

    @ApiModelProperty(name = "对应主体活动形式（分子活动形式使用）")
    private List<SubRelatedMainActivityFormDto> subMainActivityFormList;

    /**
     * 活动分类编码
     */
    @ApiModelProperty("活动分类编码")
    private String activityTypeCode;
    private String activityTypeCodes;
    private List<String> activityTypeCodeList;

    /**
     * 活动分类名称
     */
    @ApiModelProperty("活动分类名称")
    private String activityTypeName;


}
