package com.biz.crm.tpm.business.activity.form.sdk.dto;

import com.biz.crm.business.common.sdk.dto.TenantFlagOpDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/11/28 12:07
 * @description：活动形式活动执行明细
 */
@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "活动形式活动执行明细dto")
public class ActivityFormExeDetailDto extends TenantFlagOpDto {
    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    private String activityFormCode;

    @ApiModelProperty(name = "核销方式", notes = "核销方式")
    private String auditType;

    @ApiModelProperty(name = "是否推送其他平台执行", notes = "是否推送其他平台执行")
    private Boolean isPushOtherPlatformExe;

    @ApiModelProperty(name = "选择推送执行系统", notes = "选择推送执行系统")
    private String pushExeSystemCode;

    @ApiModelProperty(name = "是否采集活动数据", notes = "是否采集活动数据")
    private Boolean isCollectActivityData;

    @ApiModelProperty(name = "是否采集照片", notes = "是否采集照片")
    private Boolean isCollectPicture;

    @ApiModelProperty(name = "是否采集分销订单", notes = "是否采集分销订单")
    private Boolean isCollectDistributionOrder;

    @ApiModelProperty(name = "是否控制活动费用", notes = "是否控制活动费用")
    private Boolean isCollectActivityFee;

    @ApiModelProperty(name = "活动采集照片", notes = "活动采集照片")
    private List<ActivityFormCollectDto> activityFormCollectDtoList;

    @ApiModelProperty(name = "采集字段", notes = "采集字段")
    private List<ActivityFormCollectFieldDto> activityFormCollectFieldDtoList;
}
