package com.biz.crm.tpm.business.activity.form.sdk.dto;

import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.List;

/**
 * 活动形式下拉参数dto
 *
 * @author wanghaojia
 * @date 2022/11/10 20:13
 */
@Data
@ApiModel(value = "活动形式下拉参数dto")
public class ActivityFormSelectDto extends CommonSelectDto {

    @ApiModelProperty(value = "活动类型编码")
    private String activityTypeCode;

    @ApiModelProperty(value = "活动类型编码(英文逗号隔开)")
    private String activityTypeCodes;

    @ApiModelProperty(value = "活动类型编码列表", hidden = true)
    private List<String> activityTypeCodeList;

    @ApiModelProperty(notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty("业务单元")
    private String businessUnitCode;

    @ApiModelProperty("活动形式编码")
    private String activityFormCode;

    @ApiModelProperty("活动形式名称")
    private String activityFormName;

    @ApiModelProperty("选择细案模版")
    private String thinProjectTemplate;

    @ApiModelProperty("调用功能类型")
    private String type;

}
