package com.biz.crm.tpm.business.activity.form.sdk.event.log;

import com.biz.crm.tpm.business.activity.form.sdk.dto.log.ActivityFormLogEventDto;
import com.bizunited.nebula.event.sdk.service.NebulaEvent;

/**
 * 日志监听
 *
 * @author: dengwei
 * @date: 2022/11/11 10:30
 */
public interface ActivityFormEventListener extends NebulaEvent {
    /**
     * 创建事件
     *
     * @param eventDto
     */
    void onCreate(ActivityFormLogEventDto eventDto);
    /**
     * 删除事件
     *
     * @param eventDto
     */
    void onDelete(ActivityFormLogEventDto eventDto);
    /**
     * 更新日志
     *
     * @param eventDto
     */
    void onUpdate(ActivityFormLogEventDto eventDto);
    /**
     * 启用
     *
     * @param eventDto
     */
    void onEnable(ActivityFormLogEventDto eventDto);
    /**
     * 禁用
     *
     * @param eventDto
     */
    void onDisable(ActivityFormLogEventDto eventDto);
}
