package com.biz.crm.tpm.business.activity.form.sdk.service;


import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormPopEctDto;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormExeDetailVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormPopEctVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo;
import com.biz.crm.tpm.business.activity.form.sdk.vo.SubRelatedMainActivityFormVo;
import org.springframework.data.domain.Pageable;

import java.util.List;
import java.util.Map;
import java.util.Set;

/**
 * 活动形式(ActivityForm)表服务接口
 *
 * @author makejava
 * @since 2022-10-25 10:55:05
 */
public interface ActivityFormService {

    /**
     * 分页查询数据
     *
     * @param pageable     分页对象
     * @param activityForm 实体对象
     * @return
     */
    Page<ActivityFormVo> findByConditions(Pageable pageable, ActivityFormDto activityForm);

    List<ActivityFormVo> findListByConditions(ActivityFormDto activityForm);

    /**
     * 通过主键查询单条数据
     *
     * @param id 主键
     * @return 单条数据
     */
    ActivityFormVo findById(String id);

    /**
     * 新增数据
     *
     * @param activityForm 实体对象
     * @return 新增结果
     */
    ActivityFormVo create(ActivityFormDto activityForm);

    /**
     * 修改新据
     *
     * @param activityForm 实体对象
     * @return 修改结果
     */
    void update(ActivityFormDto activityForm);

    void updateAuditCondition(ActivityFormDto activityForm);

    /**
     * 删除数据
     *
     * @param idList 主键结合
     * @return 删除结果
     */
    void delete(List<String> idList);

    /**
     * create by: dengwei
     * description: 启用
     * create time: 2022/10/25 16:19
     *
     * @return void
     * @Param: ids 主键结合
     */
    void enableBatch(List<String> ids);

    /**
     * create by: dengwei
     * description: 禁用
     * create time: 2022/10/25 16:19
     *
     * @return void
     * @Param: ids 主键结合
     */
    void disableBatch(List<String> ids);

    List<ActivityFormVo> getList(ActivityFormDto activityForm);

    /**
     * 活动形式下拉
     *
     * @param dto 活动形式查询参数
     * @return 活动形式下拉数据
     */
    List<CommonSelectVo> findActivityFormSelectList(ActivityFormSelectDto dto);

    /**
     * 活动形式下拉（分子公司规划、细案用）
     *
     * @param dto
     * @return java.util.List<com.biz.crm.tpm.business.activity.form.sdk.vo.ActivityFormVo>
     * @author huojia
     * @date 2022/12/28 14:14
     **/
    List<ActivityFormVo> findSelectList(ActivityFormSelectDto dto);

    /**
     * 通过活动形式code查询活动形式
     *
     * @param activityFormCodes 活动形式codes
     * @return
     */
    List<ActivityFormVo> findActivityFormByCode(Set<String> activityFormCodes);

    /**
     * 通过code查询活动形式
     * @param code
     * @return
     */
    ActivityFormVo findOneByCode(String code);

    /**
     * 通过code查询活动形式
     * @param codes
     * @return
     */
    List<ActivityFormVo> findByCodes(List<String> codes);

    /**
     * 通过code查询活动形式
     * @param names
     * @return
     */
    List<ActivityFormVo> findByNames(List<String> names);

    /**
     * 查询所有需推送订单共享平台的活动形式
     *
     * @return
     */
    Map<String, List<ActivityFormExeDetailVo>> findPushOrderSharePlatform(List<String> fromCodes);

    /**
     * 查询所有需推送SAP的活动形式
     *
     * @return
     */
    Map<String, List<ActivityFormExeDetailVo>> findPushSap(List<String> formCodes);

    /**
     * 查询活动形式对应的SAP编码
     * @return
     */
    Map<String,String> findSapCode(List<String> formCodes);

    /**
     * 查询所有需推送牛人管家的活动形式编码,并带出其对应的垂直活动类型
     * 禁止调用feign
     * @return Map(key:活动形式编码,value:垂直活动类型)
     */
    Map<String,String> findPushCowManager();

    /**
     * 根据活动形式编码获取有效的活动形式信息
     *
     * @param formCodes 活动形式编码列表
     * @return Map<String, String>
     */
    Map<String, String> findFormByCodes(List<List<String>> formCodes);

    /**
     * 活动形式SAP编码为ZS42
     *
     * @param formCodes
     * @return
     */
    List<String> findFormByCodesZs42(List<List<String>> formCodes);

    /**
     * 更据主体活动形式编码查询对应分子活动形式
     *
     * @param mainFormCodes
     * @return
     */
    List<SubRelatedMainActivityFormVo> findSubRelatedMainByCodes(List<String> mainFormCodes);

    /**
     * 查询活动形式及关联的活动分类编码
     * @param activityFormCode
     * @param tenantCode
     * @return
     */
    ActivityFormVo findFormAndRelatedTypeCode(String activityFormCode,String tenantCode);

    List<ActivityFormVo> findFormAndRelatedTypeCodes(List<String> activityFormCodes,String tenantCode);

    /**
     * 分页查询重客垂直的活动形式，ect系统用
     * @param pageable
     * @param activityFormPopEctDto
     * @return
     */
    Page<ActivityFormPopEctVo> findActivityFormPopEct(Pageable pageable, ActivityFormPopEctDto activityFormPopEctDto);

    /**
     * 活动形式SAP编码为ZS03
     *
     * @param formCodes
     * @return
     */
    List<String> findFormByCodesZs03(List<List<String>> formCodes);

    /**
     * 查询垂直促销活动形式的活动类型
     */
    List<String> findActivityFormCodeFromPromotionsType(String businessUnitCode,String verticalActivityType,String pushExeSystemCode);
}

