package com.biz.crm.tpm.business.activity.form.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormAuditDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.util.List;

/**
 * @author ：dengwei
 * @date ：Created in 2022/10/25 14:41
 * @description：活动形式vo
 */
@EqualsAndHashCode(callSuper = true)
@Data
@ApiModel(value = "ActivityFormVo", description = "活动形式vo")
public class ActivityFormVo extends TenantFlagOpVo {
    @ApiModelProperty(name = "活动形式名称", notes = "活动形式名称")
    private String activityFormName;

    @ApiModelProperty(name = "活动形式Code", notes = "活动形式Code")
    private String activityFormCode;

    @ApiModelProperty(name = "会计科目编码", notes = "会计科目编码")
    private String accountantCode;

    @ApiModelProperty(name = "会计科目名称", notes = "会计科目名称")
    private String accountantName;

    @ApiModelProperty(name = "业态", notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "分摊费用到产品", notes = "分摊费用到产品")
    private Boolean allocationFeeToProduct;

    @ApiModelProperty(name = "是否为商超扣费项", notes = "是否为商超扣费项")
    private Boolean isSupermarketDeductionItem;

    @ApiModelProperty("是否和价格相关")
    private Boolean isRelatePrice;

    @ApiModelProperty("差异费用处理模版")
    private String diffCostDisposeTemplate;

    @ApiModelProperty("利润表项目")
    private String profitTableItem;

    @ApiModelProperty(name = "业务单元", notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "业务单元名称", notes = "业务单元名称")
    private String businessUnitName;

    @ApiModelProperty(name = "选择细案模版", notes = "选择细案模版")
    private String thinProjectTemplate;

    @ApiModelProperty(name = "支付方式", notes = "支付方式")
    private String auditWayCode;

    @ApiModelProperty(name = "支付方式名称", notes = "支付方式名称")
    private String auditWayName;

    @ApiModelProperty(name = "是否推送巡查系统", notes = "是否推送巡查系统")
    private Boolean isPushPatrolSystem;

    @ApiModelProperty(name = "是否自动核销", notes = "是否自动核销")
    private Boolean isAutoAudit;

    @ApiModelProperty("是否允许超额核销")
    private Boolean isAllowExcessAudit;

    @ApiModelProperty(name = "选择巡查系统", notes = "选择巡查系统")
    private String selectPatrolSystemCode;

    @ApiModelProperty("垂直活动类型")
    private String verticalActivityType;

    @ApiModelProperty(name = "允许多次核销", notes = "允许多次核销")
    private Boolean isMoreAudit;

    @ApiModelProperty(name = "核销有效期（月）", notes = "核销有效期（月）")
    private String auditValidDate;

    @ApiModelProperty(name = "核销条件", notes = "核销条件")
    private String auditCondition;

    @ApiModelProperty("申请维度")
    private String applyDimensionality;

    @ApiModelProperty("sap编码")
    private String sapCode;

    @ApiModelProperty("拆分客户数据源")
    private String splitCustomerDataSource;

    @ApiModelProperty("核销方式")
    private List<String> auditTypeList;

    @ApiModelProperty("活动执行明细")
    private List<ActivityFormExeDetailVo> activityFormExeDetailList;

    @ApiModelProperty(name = "核销资料", notes = "核销资料")
    private List<ActivityFormAuditDto> activityFormAuditDtoList;

    /**
     * 活动分类编码
     */
    private String activityTypeCode;

    /**
     * 活动分类名称
     */
    private String activityTypeName;

    @ApiModelProperty(name = "对应主体活动形式编码", notes = "对应主体活动形式编码（分子活动形式使用）")
    private String subMainActivityFormCode;

    @ApiModelProperty(name = "对应主体活动形式（分子活动形式使用）")
    private List<SubRelatedMainActivityFormVo> subMainActivityFormList;

}
