package com.biz.crm.tpm.business.activity.intensity.monitor.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.dto.ActivityIntensityMonitorDto;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.service.ActivityIntensityMonitorService;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo.ActivityIntensityMonitorVO;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo.ProductPromotionItemVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动力度监控表(tpm_activity_intensity_monitor) 控制层
 *
 * @author : qiancheng
 * @date : 2022-11-14
 */
@RestController
@RequestMapping("/v1/activityIntensityMonitor")
@Slf4j
@Api(tags = "活动力度监控表")
public class ActivityIntensityMonitorController {

    @Autowired
    private ActivityIntensityMonitorService activityIntensityMonitorService;

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param activityIntensityMonitor 实体对象
     * @return 分页数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("/findByConditions")
    public Result<Page<ActivityIntensityMonitorVO>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(20) Pageable pageable,
                                                                     @ApiParam(name = "promotionPolicy", value = "活动力度监控表") ActivityIntensityMonitorDto activityIntensityMonitor) {
        try {
            Page<ActivityIntensityMonitorVO> page = this.activityIntensityMonitorService.findByConditions(pageable, activityIntensityMonitor);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 通过主键id 查单条数据
     * @param id 主键id
     * @return
     */
    @ApiOperation(value = "通过主键id查单条数据")
    @GetMapping("/findById")
    public Result<ActivityIntensityMonitorVO> findById(@RequestParam("id") @ApiParam(name = "id",value = "主键id") String id){
        try {
            ActivityIntensityMonitorVO result = this.activityIntensityMonitorService.findById(id);
            return Result.ok(result);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    @ApiOperation(value = "查看详情")
    @GetMapping("/findItem")
    public Result<Page<ProductPromotionItemVo>> findItem(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(20) Pageable pageable,
                                                         @RequestParam("monitorType") @ApiParam(name = "monitorType",value = "监控类型") String monitorType,
                                                         @RequestParam("productCode") @ApiParam(name = "productCode",value = "产品编码") String productCode,
                                                         @RequestParam(name = "activityOrgCode", required = false) @ApiParam(name = "activityOrgCode",value = "组织编码") String activityOrgCode,
                                                         @RequestParam(name = "customerCode", required = false) @ApiParam(name = "customerCode",value = "客户编码") String customerCode,
                                                         @RequestParam("yearMonthLy") @ApiParam(name = "yearMonthLy",value = "年月") String yearMonthLy,
                                                         @RequestParam(name = "planCode",required = false) @ApiParam(name = "planCode",value = "方案/细案编码") String planCode,
                                                         @RequestParam(name = "planName",required = false) @ApiParam(name = "planName",value = "方案/细案名称") String planName){
        try {
            Page<ProductPromotionItemVo> productPromotionItemVos = activityIntensityMonitorService.findItem(pageable,monitorType,productCode,activityOrgCode,customerCode,yearMonthLy,planCode,planName);
            return Result.ok(productPromotionItemVos);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 生成活动力度监控数据
     */
    @ApiOperation("生成活动力度监控数据")
    @GetMapping("/activityIntensityMonitorData")
    public Result<?> getActivityIntensityMonitorData(@RequestParam("yearMonthLy") @ApiParam(name = "yearMonthLy",value = "年月") String yearMonthLy){
        try {
            activityIntensityMonitorService.generateActivityIntensityMonitor(yearMonthLy);
            return Result.ok();
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
