package com.biz.crm.tpm.business.activity.intensity.monitor.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 实体：活动力度监控表
 *
 * @author miaoqiancheng
 * @since 2022-11-14
 */
@ApiModel(value = "ActivityIntensityMonitor", description = "活动力度监控表")
@TableName("tpm_activity_intensity_monitor")
@EqualsAndHashCode(callSuper = false)
@Data
@Entity(name = "tpm_activity_intensity_monitor")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_intensity_monitor", comment = "活动力度监控表")
@Table(name = "tpm_activity_intensity_monitor", indexes = {
        @Index(name = "tpm_activity_intensity_monitor_inx1", columnList = "product_code", unique = false),
})
public class ActivityIntensityMonitor extends TenantFlagOpEntity {

    @ApiModelProperty(name = "businessFormatCode",value = "业态",notes = "业态")
    @Column(name = "business_format_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业态'")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    @Column(name = "business_unit_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '业务单元'")
    private String businessUnitCode;

    @ApiModelProperty(name = "monitorType",value = "监控类型",notes = "监控类型")
    @Column(name = "monitor_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '监控类型'")
    private String monitorType;

    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构erp编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构erp编码'")
    private String salesInstitutionErpCode;

    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区编码 '")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区erp编码 '")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属销售大区编码 '")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)erp编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组织(组)erp编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售组织(组)名称'")
    private String salesOrgName;

    @ApiModelProperty(name = "productCode",value = "产品编码",notes = "产品编码")
    @Column(name = "product_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '产品编码'")
    private String productCode;

    @ApiModelProperty(name = "productName",value = "产品名称",notes = "产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "VARCHAR(255) COMMENT '产品名称'")
    private String productName;

    @ApiModelProperty(name = "dateManufacture",value = "产品生产日期",notes = "产品生产日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "date_manufacture", nullable = true,length = 20, columnDefinition = "datetime COMMENT '产品生产日期'")
    private Date dateManufacture;

    @ApiModelProperty(name = "unitCode",value = "单位编码",notes = "单位编码")
    @Column(name = "unit_code", nullable = true,length = 32, columnDefinition = "VARCHAR(32) COMMENT '单位编码'")
    private String unitCode;

    @ApiModelProperty(name = "unit",value = "单位",notes = "单位")
    @Column(name = "unit", nullable = true,length = 32, columnDefinition = "VARCHAR(32) COMMENT '单位'")
    private String unit;

    @ApiModelProperty(name = "promotionPrice", value = "促销价",notes = "促销价")
    @Column(name = "promotion_price", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '促销价'")
    private BigDecimal promotionPrice;

    @ApiModelProperty(name = "redLinePrice", value = "红线价",notes = "红线价")
    @Column(name = "red_line_price", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '红线价'")
    private BigDecimal redLinePrice;

    @ApiModelProperty(name = "standardPrice", value = "标准定价",notes = "标准定价")
    @Column(name = "standard_price", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '标准定价'")
    private BigDecimal standardPrice;

    @ApiModelProperty(name = "superposedActivityIntensity", value = "叠加后活动力度",notes = "叠加后活动力度")
    @Column(name = "superposed_activity_intensity", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '叠加后活动力度'")
    private BigDecimal superposedActivityIntensity;

    @ApiModelProperty(name = "superposedPlanPrice", value = "叠加后规划价",notes = "叠加后规划价")
    @Column(name = "superposed_plan_price", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '叠加后规划价'")
    private BigDecimal superposedPlanPrice;

    @ApiModelProperty(name = "deviation", value = "偏差率",notes = "偏差率")
    @Column(name = "deviation", nullable = true, length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '偏差率'")
    private BigDecimal deviation;

    @ApiModelProperty("活动数量")
    @Column(name = "activity_qty", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '活动数量'")
    private BigDecimal activityQty;

    @ApiModelProperty("活动力度")
    @Column(name = "activity_intensity", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '活动力度'")
    private BigDecimal activityIntensity;

    @ApiModelProperty("力度类型")
    @Column(name = "intensityType", columnDefinition = "varchar(32) COMMENT '力度类型'")
    private String intensityType;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", columnDefinition = "varchar(64) COMMENT '客户编码'")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;
    /**
     * 年月
     */
    @ApiModelProperty("年月")
    @Column(name = "year_month_ly", length = 32, columnDefinition = "VARCHAR(32) COMMENT '年月'")
    private String yearMonthLy;

}
