package com.biz.crm.tpm.business.activity.intensity.monitor.local.enums;

import com.baomidou.mybatisplus.annotation.EnumValue;
import com.fasterxml.jackson.annotation.JsonValue;
import org.apache.commons.lang3.StringUtils;

import java.util.HashSet;
import java.util.Set;

/**
 * 活动力度监控类型枚举
 *
 * @author yaoyongming
 * @since 2023-9-16
 */
public enum IntensityTypeEnum {

    HEAD("head","总部力度"),
    REGION("region","大区力度"),
    ALL("all","全部力度");

    @EnumValue
    @JsonValue
    private String code;
    private String des;

    private IntensityTypeEnum(String code, String des) {
        this.code = code;
        this.des = des;
    }

    public String getCode() {
        return this.code;
    }

    public String getDes() {
        return this.des;
    }

    public static Set<String> codeToSet() {
        Set<String> codes = new HashSet();
        IntensityTypeEnum[] var1 = values();
        int var2 = var1.length;

        for(int var3 = 0; var3 < var2; ++var3) {
            IntensityTypeEnum intensityTypeEnum = var1[var3];
            codes.add(intensityTypeEnum.getCode());
        }

        return codes;
    }

    public static IntensityTypeEnum codeToEnum(String code) {
        IntensityTypeEnum monitorTypes = null;
        IntensityTypeEnum[] var2 = values();
        int var3 = var2.length;

        for(int var4 = 0; var4 < var3; ++var4) {
            IntensityTypeEnum intensityTypeEnum = var2[var4];
            if (intensityTypeEnum.code.equals(code)) {
                monitorTypes = intensityTypeEnum;
            }
        }

        return monitorTypes;
    }

    public static String getDesc(String code) {
        if (!StringUtils.isEmpty(code)) {
            IntensityTypeEnum[] values = values();
            IntensityTypeEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                IntensityTypeEnum value = var2[var4];
                if (value.code.equals(code)) {
                    return value.des;
                }
            }
        }

        return null;
    }

    public static boolean contains(String code) {
        if (StringUtils.isEmpty(code)) {
            return false;
        } else {
            IntensityTypeEnum[] values = values();
            IntensityTypeEnum[] var2 = values;
            int var3 = values.length;

            for(int var4 = 0; var4 < var3; ++var4) {
                IntensityTypeEnum value = var2[var4];
                if (value.getCode().equals(code)) {
                    return true;
                }
            }

            return false;
        }
    }

}
