package com.biz.crm.tpm.business.activity.intensity.monitor.local.mapper;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.intensity.monitor.local.entity.ActivityIntensityMonitor;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.dto.ActivityIntensityMonitorDto;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo.ActivityIntensityMonitorVO;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 活动力度监控表(tpm_activity_intensity_monitor)表数据库访问层
 *
 * @author : qiancheng
 * @date : 2022-11-14
 */
public interface ActivityIntensityMonitorMapper extends BaseMapper<ActivityIntensityMonitor> {

    /**
     * 分页查询数据
     *
     * @param page 分页对象
     * @param activityIntensityMonitor 实体对象
     * @return 分页对象列表
     */
    Page<ActivityIntensityMonitorVO> findByConditions(@Param("page") Page<ActivityIntensityMonitorVO> page, @Param("dto") ActivityIntensityMonitorDto activityIntensityMonitor);

    /**
     * 活动细案明细汇总
     *
     * @param activityIntensityMonitor
     * @return
     */
    List<ActivityIntensityMonitorVO> sumActivityDetailPlanItem(@Param("dto") ActivityIntensityMonitorDto activityIntensityMonitor);
}
