package com.biz.crm.tpm.business.activity.intensity.monitor.local.repository;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.tpm.business.activity.intensity.monitor.local.entity.ActivityIntensityMonitor;
import com.biz.crm.tpm.business.activity.intensity.monitor.local.mapper.ActivityIntensityMonitorMapper;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.dto.ActivityIntensityMonitorDto;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo.ActivityIntensityMonitorVO;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 活动力度监控表(tpm_activity_intensity_monitor)表数据库访问层
 *
 * @author : qiancheng
 * @date : 2022-11-14
 */
@Slf4j
@Component
public class ActivityIntensityMonitorRepository extends ServiceImpl<ActivityIntensityMonitorMapper, ActivityIntensityMonitor> {

    @Autowired
    private ActivityIntensityMonitorMapper activityIntensityMonitorMapper;


    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param activityIntensityMonitor 实体对象
     * @return 分页数据
     */
    public Page<ActivityIntensityMonitorVO> findByConditions(Pageable pageable, ActivityIntensityMonitorDto activityIntensityMonitor){
        if(pageable == null){
            pageable = PageRequest.of(1,50);
        }
        Page<ActivityIntensityMonitorVO> page = new Page<>(pageable.getPageNumber(), pageable.getPageSize());
        return this.activityIntensityMonitorMapper.findByConditions(page,activityIntensityMonitor);
    }

    /**
     * 活动细案明细汇总
     *
     * @param activityIntensityMonitor
     * @return
     */
    public List<ActivityIntensityMonitorVO> sumActivityDetailPlanItem(ActivityIntensityMonitorDto activityIntensityMonitor) {
        return this.activityIntensityMonitorMapper.sumActivityDetailPlanItem(activityIntensityMonitor);
    }

}
