/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.intensity.monitor.local.controller;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.dto.ActivityIntensityMonitorDto;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.service.ActivityIntensityMonitorService;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo.ActivityIntensityMonitorVO;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo.ProductPromotionItemVo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/v1/activityIntensityMonitor"})
@Api(tags={"\u6d3b\u52a8\u529b\u5ea6\u76d1\u63a7\u8868"})
public class ActivityIntensityMonitorController {
    private static final Logger log = LoggerFactory.getLogger(ActivityIntensityMonitorController.class);
    @Autowired
    private ActivityIntensityMonitorService activityIntensityMonitorService;

    @ApiOperation(value="\u5206\u9875\u67e5\u8be2\u6240\u6709\u6570\u636e")
    @GetMapping(value={"/findByConditions"})
    public Result<Page<ActivityIntensityMonitorVO>> findByConditions(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=20) Pageable pageable, @ApiParam(name="promotionPolicy", value="\u6d3b\u52a8\u529b\u5ea6\u76d1\u63a7\u8868") ActivityIntensityMonitorDto activityIntensityMonitor) {
        try {
            Page page = this.activityIntensityMonitorService.findByConditions(pageable, activityIntensityMonitor);
            return Result.ok((Object)page);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u901a\u8fc7\u4e3b\u952eid\u67e5\u5355\u6761\u6570\u636e")
    @GetMapping(value={"/findById"})
    public Result<ActivityIntensityMonitorVO> findById(@RequestParam(value="id") @ApiParam(name="id", value="\u4e3b\u952eid") String id) {
        try {
            ActivityIntensityMonitorVO result = this.activityIntensityMonitorService.findById(id);
            return Result.ok((Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u67e5\u770b\u8be6\u60c5")
    @GetMapping(value={"/findItem"})
    public Result<Page<ProductPromotionItemVo>> findItem(@ApiParam(name="pageable", value="\u5206\u9875\u5bf9\u8c61") @PageableDefault(value=20) Pageable pageable, @RequestParam(value="monitorType") @ApiParam(name="monitorType", value="\u76d1\u63a7\u7c7b\u578b") String monitorType, @RequestParam(value="productCode") @ApiParam(name="productCode", value="\u4ea7\u54c1\u7f16\u7801") String productCode, @RequestParam(name="activityOrgCode", required=false) @ApiParam(name="activityOrgCode", value="\u7ec4\u7ec7\u7f16\u7801") String activityOrgCode, @RequestParam(name="customerCode", required=false) @ApiParam(name="customerCode", value="\u5ba2\u6237\u7f16\u7801") String customerCode, @RequestParam(value="yearMonthLy") @ApiParam(name="yearMonthLy", value="\u5e74\u6708") String yearMonthLy, @RequestParam(name="planCode", required=false) @ApiParam(name="planCode", value="\u65b9\u6848/\u7ec6\u6848\u7f16\u7801") String planCode, @RequestParam(name="planName", required=false) @ApiParam(name="planName", value="\u65b9\u6848/\u7ec6\u6848\u540d\u79f0") String planName) {
        try {
            Page productPromotionItemVos = this.activityIntensityMonitorService.findItem(pageable, monitorType, productCode, activityOrgCode, customerCode, yearMonthLy, planCode, planName);
            return Result.ok((Object)productPromotionItemVos);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }

    @ApiOperation(value="\u751f\u6210\u6d3b\u52a8\u529b\u5ea6\u76d1\u63a7\u6570\u636e")
    @GetMapping(value={"/activityIntensityMonitorData"})
    public Result<?> getActivityIntensityMonitorData(@RequestParam(value="yearMonthLy") @ApiParam(name="yearMonthLy", value="\u5e74\u6708") String yearMonthLy) {
        try {
            this.activityIntensityMonitorService.generateActivityIntensityMonitor(yearMonthLy);
            return Result.ok();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Result.error((String)e.getMessage());
        }
    }
}

