/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.tpm.business.activity.intensity.monitor.local.service.intenal;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.enums.EnableStatusEnum;
import com.biz.crm.mdm.business.price.sdk.dto.PriceDto;
import com.biz.crm.mdm.business.price.sdk.service.PriceVoService;
import com.biz.crm.mdm.business.price.sdk.vo.PriceVo;
import com.biz.crm.mdm.business.product.sdk.service.ProductVoService;
import com.biz.crm.mdm.business.product.sdk.vo.ProductVo;
import com.biz.crm.mn.common.base.eunm.BusinessFormatEnum;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.dto.ActivityDetailPlanItemDto;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.pojo.ActivityDetailPlanItemBase;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanItemSdkService;
import com.biz.crm.tpm.business.activity.detail.plan.sdk.service.ActivityDetailPlanSdkService;
import com.biz.crm.tpm.business.activity.intensity.monitor.local.entity.ActivityIntensityMonitor;
import com.biz.crm.tpm.business.activity.intensity.monitor.local.enums.IntensityTypeEnum;
import com.biz.crm.tpm.business.activity.intensity.monitor.local.enums.MonitorTypeEnums;
import com.biz.crm.tpm.business.activity.intensity.monitor.local.repository.ActivityIntensityMonitorRepository;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.dto.ActivityIntensityMonitorDto;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.service.ActivityIntensityMonitorService;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo.ActivityIntensityMonitorVO;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo.ProductPromotionItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanBase;
import com.biz.crm.tpm.business.activity.plan.sdk.pojo.ActivityPlanItemBase;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanItemSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import com.bizunited.nebula.common.service.NebulaToolkitService;
import com.bizunited.nebula.common.util.tenant.TenantUtils;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.Validate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="activityIntensityMonitorService")
public class ActivityIntensityMonitorServiceImpl
implements ActivityIntensityMonitorService {
    private static final Logger log = LoggerFactory.getLogger(ActivityIntensityMonitorServiceImpl.class);
    @Autowired
    private ActivityIntensityMonitorRepository activityIntensityMonitorRepository;
    @Autowired(required=false)
    private ActivityDetailPlanSdkService activityDetailPlanSdkService;
    @Autowired(required=false)
    private ActivityDetailPlanItemSdkService activityDetailPlanItemSdkService;
    @Autowired(required=false)
    private ActivityPlanSdkService activityPlanSdkService;
    @Autowired(required=false)
    private ActivityPlanItemSdkService activityPlanItemSdkService;
    @Autowired(required=false)
    private NebulaToolkitService nebulaToolkitService;
    @Autowired(required=false)
    private ProductVoService productVoService;
    @Autowired(required=false)
    private PriceVoService priceVoService;

    public Page<ActivityIntensityMonitorVO> findByConditions(Pageable pageable, ActivityIntensityMonitorDto activityIntensityMonitor) {
        if (pageable == null) {
            pageable = PageRequest.of((int)1, (int)20);
        }
        if (activityIntensityMonitor == null) {
            activityIntensityMonitor = new ActivityIntensityMonitorDto();
        }
        if (StringUtils.isBlank((CharSequence)activityIntensityMonitor.getDelFlag())) {
            activityIntensityMonitor.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        }
        if (StringUtils.isBlank((CharSequence)activityIntensityMonitor.getTenantCode())) {
            activityIntensityMonitor.setTenantCode(TenantUtils.getTenantCode());
        }
        Page<ActivityIntensityMonitorVO> byConditions = this.activityIntensityMonitorRepository.findByConditions(pageable, activityIntensityMonitor);
        return byConditions;
    }

    public ActivityIntensityMonitorVO findById(String id) {
        ActivityIntensityMonitor activityIntensityMonitorEntity;
        if (!StringUtils.isBlank((CharSequence)id) && (activityIntensityMonitorEntity = (ActivityIntensityMonitor)((Object)this.activityIntensityMonitorRepository.getById((Serializable)((Object)id)))) != null) {
            return (ActivityIntensityMonitorVO)this.nebulaToolkitService.copyObjectByWhiteList((Object)activityIntensityMonitorEntity, ActivityIntensityMonitorVO.class, HashSet.class, ArrayList.class, new String[0]);
        }
        return null;
    }

    @Transactional(rollbackFor={Exception.class})
    public void findDateFormActivityDetailPlan() {
        Page byConditions1 = null;
        int i = 0;
        ArrayList activityIntensityMonitorList = new ArrayList();
        do {
            PageRequest pageForDetailPlan = PageRequest.of((int)i, (int)100);
            ActivityDetailPlanDto detailPlan = new ActivityDetailPlanDto();
            detailPlan.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            detailPlan.setTenantCode(TenantUtils.getTenantCode());
            detailPlan.setProcessStatus(ProcessStatusEnum.PASS.getKey());
            byConditions1 = this.activityDetailPlanSdkService.findByConditions((Pageable)pageForDetailPlan, detailPlan);
            List ActivityDetailPlanVoList = byConditions1.getRecords();
            if (ActivityDetailPlanVoList != null && ActivityDetailPlanVoList.size() > 0) {
                ActivityDetailPlanVoList.forEach(detailPlanVo -> {
                    Page byConditions2 = null;
                    int z = 0;
                    do {
                        PageRequest pageForDetailPlanItem = PageRequest.of((int)z, (int)100);
                        ActivityDetailPlanItemDto activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
                        activityDetailPlanItemDto.setDetailPlanCode(detailPlanVo.getDetailPlanCode());
                        activityDetailPlanItemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        byConditions2 = this.activityDetailPlanItemSdkService.findByConditions((Pageable)pageForDetailPlanItem, activityDetailPlanItemDto);
                        List activityDetailPlanItemVoList = byConditions2.getRecords();
                        if (activityDetailPlanItemVoList != null && activityDetailPlanItemVoList.size() > 0) {
                            activityDetailPlanItemVoList.forEach(detailPlanItemVo -> {
                                if (!StringUtils.isBlank((CharSequence)detailPlanItemVo.getProductCode())) {
                                    ActivityIntensityMonitor activityIntensityMonitor = new ActivityIntensityMonitor();
                                    String detailPlanItemId = detailPlanItemVo.getId();
                                    String productCode = detailPlanItemVo.getProductCode();
                                    activityIntensityMonitor.setId(detailPlanItemId.substring(0, 27) + productCode.substring(productCode.length() - 5));
                                    activityIntensityMonitor.setBusinessFormatCode(detailPlanVo.getBusinessFormatCode());
                                    activityIntensityMonitor.setBusinessUnitCode(detailPlanVo.getBusinessUnitCode());
                                    activityIntensityMonitor.setMonitorType(MonitorTypeEnums.REGION_MONITOR.getCode());
                                    activityIntensityMonitor.setSalesRegionCode(detailPlanItemVo.getActivityOrgCode());
                                    activityIntensityMonitor.setSalesRegionName(detailPlanItemVo.getActivityOrgName());
                                    activityIntensityMonitor.setProductCode(detailPlanItemVo.getProductCode());
                                    activityIntensityMonitor.setProductName(detailPlanItemVo.getProductName());
                                    activityIntensityMonitor.setPromotionPrice(detailPlanItemVo.getPrice());
                                    activityIntensityMonitor.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                                    activityIntensityMonitor.setTenantCode(TenantUtils.getTenantCode());
                                    activityIntensityMonitorList.add(activityIntensityMonitor);
                                }
                            });
                        }
                        ++z;
                    } while (byConditions2 != null && byConditions2.getRecords().size() == 100);
                });
            }
            if (activityIntensityMonitorList.size() >= 100) {
                this.activityIntensityMonitorRepository.saveOrUpdateBatch(activityIntensityMonitorList);
            }
            ++i;
        } while (byConditions1 != null && byConditions1.getRecords().size() == 100);
        if (activityIntensityMonitorList.size() > 0) {
            this.activityIntensityMonitorRepository.saveOrUpdateBatch(activityIntensityMonitorList);
        }
    }

    @Transactional(rollbackFor={Exception.class})
    public void findDateFormActivityPlan() {
        Page byConditions1 = null;
        int i = 0;
        ArrayList activityIntensityMonitorList = new ArrayList();
        do {
            PageRequest pageForDetailPlan = PageRequest.of((int)i, (int)100);
            ActivityPlanDto activityPlanDto = new ActivityPlanDto();
            activityPlanDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            activityPlanDto.setTenantCode(TenantUtils.getTenantCode());
            activityPlanDto.setProcessStatus(ProcessStatusEnum.PASS.getKey());
            byConditions1 = this.activityPlanSdkService.findByConditions((Pageable)pageForDetailPlan, activityPlanDto);
            List activityPlanVoList = byConditions1.getRecords();
            if (activityPlanVoList != null && activityPlanVoList.size() > 0) {
                activityPlanVoList.forEach(activityPlan -> {
                    Page byConditions2 = null;
                    int z = 0;
                    do {
                        PageRequest pageForDetailPlanItem = PageRequest.of((int)z, (int)100);
                        ActivityPlanItemDto activityPlanItemDto = new ActivityPlanItemDto();
                        activityPlanItemDto.setPlanCode(activityPlan.getPlanCode());
                        activityPlanItemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                        byConditions2 = this.activityPlanItemSdkService.findByConditions((Pageable)pageForDetailPlanItem, activityPlanItemDto);
                        List activityPlanItemVoList = byConditions2.getRecords();
                        if (activityPlanItemVoList != null && activityPlanItemVoList.size() > 0) {
                            activityPlanItemVoList.forEach(activityPlanItemVo -> {
                                if (!StringUtils.isBlank((CharSequence)activityPlanItemVo.getProductCode())) {
                                    ActivityIntensityMonitor activityIntensityMonitor = new ActivityIntensityMonitor();
                                    String detailPlanItemId = activityPlanItemVo.getId();
                                    String productCode = activityPlanItemVo.getProductCode();
                                    activityIntensityMonitor.setId(detailPlanItemId.substring(0, 27) + productCode.substring(productCode.length() - 5));
                                    activityIntensityMonitor.setBusinessFormatCode(activityPlan.getBusinessFormatCode());
                                    activityIntensityMonitor.setBusinessUnitCode(activityPlan.getBusinessUnitCode());
                                    activityIntensityMonitor.setMonitorType(MonitorTypeEnums.HEAD_MONITOR.getCode());
                                    activityIntensityMonitor.setSalesRegionCode(activityPlanItemVo.getActivityOrgCode());
                                    activityIntensityMonitor.setSalesRegionName(activityPlanItemVo.getActivityOrgName());
                                    activityIntensityMonitor.setProductCode(activityPlanItemVo.getProductCode());
                                    activityIntensityMonitor.setProductName(activityPlanItemVo.getProductName());
                                    activityIntensityMonitor.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
                                    activityIntensityMonitor.setTenantCode(TenantUtils.getTenantCode());
                                    activityIntensityMonitorList.add(activityIntensityMonitor);
                                }
                            });
                        }
                        ++z;
                    } while (byConditions2 != null && byConditions2.getRecords().size() == 100);
                });
            }
            if (activityIntensityMonitorList.size() >= 100) {
                this.activityIntensityMonitorRepository.saveOrUpdateBatch(activityIntensityMonitorList);
            }
            ++i;
        } while (byConditions1 != null && byConditions1.getRecords().size() == 100);
        if (activityIntensityMonitorList.size() > 0) {
            this.activityIntensityMonitorRepository.saveOrUpdateBatch(activityIntensityMonitorList);
        }
    }

    public Page<ProductPromotionItemVo> findItem(Pageable pageable, String monitorType, String productCode, String activityOrgCode, String customerCode, String yearMonthLy, String planCode, String planName) {
        Validate.isTrue((boolean)MonitorTypeEnums.contains(monitorType), (String)"\u672a\u77e5\u7684\u76d1\u63a7\u7c7b\u578b", (Object[])new Object[0]);
        Validate.notBlank((CharSequence)productCode, (String)"\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a\uff01", (Object[])new Object[0]);
        Page<ProductPromotionItemVo> productPromotionItemVoList = new Page<ProductPromotionItemVo>();
        if (MonitorTypeEnums.HEAD_MONITOR.getCode().equals(monitorType)) {
            productPromotionItemVoList = this.findItemFromActivityPlan(pageable, productCode, yearMonthLy, planCode, planName);
        }
        if (MonitorTypeEnums.REGION_MONITOR.getCode().equals(monitorType) || MonitorTypeEnums.CUSTOMER_MONITOR.getCode().equals(monitorType)) {
            ActivityDetailPlanItemDto activityDetailPlanItemDto = new ActivityDetailPlanItemDto();
            activityDetailPlanItemDto.setProductCode(productCode);
            activityDetailPlanItemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            activityDetailPlanItemDto.setTenantCode(TenantUtils.getTenantCode());
            activityDetailPlanItemDto.setDetailPlanCode(planCode);
            activityDetailPlanItemDto.setDetailPlanName(planName);
            activityDetailPlanItemDto.setActivityYearMonth(yearMonthLy);
            if (MonitorTypeEnums.REGION_MONITOR.getCode().equals(monitorType)) {
                activityDetailPlanItemDto.setActivityOrgCode(activityOrgCode);
            } else if (MonitorTypeEnums.CUSTOMER_MONITOR.getCode().equals(monitorType)) {
                activityDetailPlanItemDto.setCustomerCodes((List)Lists.newArrayList((Object[])new String[]{customerCode}));
            }
            productPromotionItemVoList = this.findItemFromActivityDetailPlan(pageable, activityDetailPlanItemDto);
        }
        return productPromotionItemVoList;
    }

    @Transactional(rollbackFor={Exception.class})
    public void generateActivityIntensityMonitor(String yearMonthLy) {
        if (StringUtils.isBlank((CharSequence)yearMonthLy)) {
            yearMonthLy = DateUtil.getDateStrByFormat((Date)DateUtil.dateAddMonth((Date)new Date(), (Integer)-1), (String)"yyyy-MM");
        }
        ActivityIntensityMonitorDto dto = new ActivityIntensityMonitorDto();
        dto.setYearMonthLy(yearMonthLy);
        log.info("\u5f00\u59cb\u751f\u6210\u6d3b\u52a8\u529b\u5ea6\u76d1\u63a7\u3010{}\u3011", (Object)yearMonthLy);
        log.info("\u5f00\u59cb\u751f\u6210\u603b\u90e8\u76d1\u63a7");
        dto.setMonitorType(MonitorTypeEnums.HEAD_MONITOR.getCode());
        this.calculateActivityIntensityMonitor(dto);
        log.info("\u7ed3\u675f\u751f\u6210\u603b\u90e8\u76d1\u63a7");
        log.info("\u5f00\u59cb\u751f\u6210\u5927\u533a\u76d1\u63a7");
        dto.setMonitorType(MonitorTypeEnums.REGION_MONITOR.getCode());
        this.calculateActivityIntensityMonitor(dto);
        log.info("\u7ed3\u675f\u751f\u6210\u5927\u533a\u76d1\u63a7");
        log.info("\u5f00\u59cb\u751f\u6210\u5ba2\u6237\u76d1\u63a7");
        dto.setMonitorType(MonitorTypeEnums.CUSTOMER_MONITOR.getCode());
        this.calculateActivityIntensityMonitor(dto);
        log.info("\u7ed3\u675f\u751f\u6210\u5ba2\u6237\u76d1\u63a7");
        log.info("\u5b8c\u6210\u751f\u6210\u6d3b\u52a8\u529b\u5ea6\u76d1\u63a7\u3010{}\u3011", (Object)yearMonthLy);
    }

    private void calculateActivityIntensityMonitor(ActivityIntensityMonitorDto dto) {
        List<ActivityIntensityMonitorVO> voList = this.activityIntensityMonitorRepository.sumActivityDetailPlanItem(dto);
        if (CollectionUtils.isEmpty(voList)) {
            log.error("\u672a\u627e\u5230\u4efb\u610f\u6ee1\u8db3\u6761\u4ef6\u7684\u7ec6\u6848\u6570\u636e");
            return;
        }
        Set productCodeSet = voList.stream().map(e -> e.getProductCode()).collect(Collectors.toSet());
        List productVoList = this.productVoService.findDetailsByIdsOrProductCodes(null, new ArrayList(productCodeSet));
        Validate.notEmpty((Collection)productVoList, (String)"\u672a\u627e\u5230\u4efb\u610f\u4ea7\u54c1\uff0c\u8bf7\u68c0\u67e5\uff01", (Object[])new Object[0]);
        Map productVoMap = productVoList.stream().collect(Collectors.toMap(ProductVo::getProductCode, Function.identity()));
        List partition = Lists.partition(new ArrayList(productCodeSet), (int)500);
        ArrayList priceVoList = new ArrayList();
        for (List part : partition) {
            priceVoList.addAll(this.priceVoService.findByProductCodeList(part));
        }
        Validate.notEmpty(priceVoList, (String)"\u672a\u627e\u5230\u4efb\u4f55\u4ea7\u54c1\u6240\u5bf9\u5e94\u7684\u4ef7\u683c", (Object[])new Object[0]);
        Map priceVoMap = priceVoList.stream().collect(Collectors.toMap(PriceVo::getGoodsCode, Function.identity(), (o, n) -> o));
        ArrayList redPriceVoList = new ArrayList();
        for (Object part : partition) {
            PriceDto priceDto = new PriceDto();
            priceDto.setTypeCodes((List)Lists.newArrayList((Object[])new String[]{"zthxj"}));
            priceDto.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            priceDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            priceDto.setBusinessFormatCode(BusinessFormatEnum.NORMAL.getCode());
            priceDto.setGoodsCodes((List)part);
            priceDto.setPriceTime(dto.getYearMonthLy() + "-01");
            redPriceVoList.addAll(Optional.ofNullable(this.priceVoService.findByPriceDtoRedLine(priceDto)).orElse(new ArrayList()));
        }
        Map redPriceVoMap = redPriceVoList.stream().collect(Collectors.toMap(PriceVo::getGoodsCode, Function.identity(), (o, n) -> o));
        for (ActivityIntensityMonitorVO vo : voList) {
            if (productVoMap.containsKey(vo.getProductCode())) {
                vo.setUnitCode(((ProductVo)productVoMap.get(vo.getProductCode())).getBaseUnit());
                vo.setUnit(((ProductVo)productVoMap.get(vo.getProductCode())).getBaseUnitDes());
            }
            if (priceVoMap.containsKey(vo.getProductCode())) {
                vo.setStandardPrice(((PriceVo)priceVoMap.get(vo.getProductCode())).getPrice());
            }
            vo.setMonitorType(dto.getMonitorType());
            vo.setTenantCode(TenantUtils.getTenantCode());
            vo.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
            vo.setEnableStatus(EnableStatusEnum.ENABLE.getCode());
            if (BigDecimal.ZERO.compareTo(vo.getActivityQty()) < 0) {
                vo.setSuperposedActivityIntensity(vo.getActivityIntensity().divide(vo.getActivityQty(), 4, 4));
                if (vo.getStandardPrice() != null) {
                    vo.setSuperposedPlanPrice(vo.getStandardPrice().subtract(vo.getSuperposedActivityIntensity()));
                }
            }
            if (!redPriceVoMap.containsKey(vo.getProductCode())) continue;
            BigDecimal redLinePrice = ((PriceVo)redPriceVoMap.get(vo.getProductCode())).getPrice();
            vo.setRedLinePrice(redLinePrice);
            BigDecimal superposedPlanPrice = Optional.ofNullable(vo.getSuperposedPlanPrice()).orElse(BigDecimal.ZERO);
            vo.setDeviation(superposedPlanPrice.subtract(redLinePrice).divide(redLinePrice, 4, 4));
        }
        List<ActivityIntensityMonitorVO> tempList = Arrays.asList(new ActivityIntensityMonitorVO[voList.size()]);
        Collections.copy(tempList, voList);
        ArrayList<ActivityIntensityMonitorVO> allList = new ArrayList<ActivityIntensityMonitorVO>();
        Map<String, List<ActivityIntensityMonitorVO>> allMap = tempList.stream().collect(Collectors.groupingBy(ActivityIntensityMonitorVO::getProductCode));
        for (String k : allMap.keySet()) {
            List<ActivityIntensityMonitorVO> list = allMap.get(k);
            ActivityIntensityMonitorVO vo = new ActivityIntensityMonitorVO();
            BeanUtils.copyProperties((Object)list.get(0), (Object)vo);
            BigDecimal activityQty = BigDecimal.ZERO;
            BigDecimal activityIntensity = BigDecimal.ZERO;
            for (ActivityIntensityMonitorVO sumVo : list) {
                activityQty = activityQty.add(Optional.ofNullable(sumVo.getActivityQty()).orElse(BigDecimal.ZERO));
                activityIntensity = activityIntensity.add(Optional.ofNullable(sumVo.getActivityIntensity()).orElse(BigDecimal.ZERO));
            }
            vo.setActivityQty(activityQty);
            vo.setActivityIntensity(activityIntensity);
            if (BigDecimal.ZERO.compareTo(vo.getActivityQty()) < 0) {
                vo.setSuperposedActivityIntensity(vo.getActivityIntensity().divide(vo.getActivityQty(), 4, 4));
                if (vo.getStandardPrice() != null) {
                    vo.setSuperposedPlanPrice(vo.getStandardPrice().subtract(vo.getSuperposedActivityIntensity()));
                }
            }
            vo.setIntensityType(IntensityTypeEnum.ALL.getCode());
            allList.add(vo);
        }
        allList.addAll(voList);
        Collection entities = this.nebulaToolkitService.copyCollectionByWhiteList(allList, ActivityIntensityMonitorVO.class, ActivityIntensityMonitor.class, LinkedHashSet.class, ArrayList.class, new String[0]);
        this.activityIntensityMonitorRepository.saveBatch(entities);
    }

    private Page<ProductPromotionItemVo> findItemFromActivityPlan(Pageable pageable, String productCode, String yearMonthLy, String planCode, String planName) {
        ActivityPlanItemDto activityPlanItemDto = new ActivityPlanItemDto();
        activityPlanItemDto.setProductCode(productCode);
        activityPlanItemDto.setDelFlag(DelFlagStatusEnum.NORMAL.getCode());
        activityPlanItemDto.setTenantCode(TenantUtils.getTenantCode());
        activityPlanItemDto.setPlanCode(planCode);
        activityPlanItemDto.setPlanName(planName);
        activityPlanItemDto.setActivityYearMonth(yearMonthLy);
        Page byConditions = this.activityPlanItemSdkService.findByConditions(pageable, activityPlanItemDto);
        if (byConditions != null && byConditions.getRecords() != null) {
            List activityPlanItemVoList = byConditions.getRecords();
            Set planCodes = activityPlanItemVoList.stream().map(ActivityPlanItemBase::getPlanCode).filter(Objects::nonNull).collect(Collectors.toSet());
            List activityPlanVos = this.activityPlanSdkService.findByPlanCodeList(planCodes);
            Map<String, String> planNameMap = activityPlanVos.stream().collect(Collectors.toMap(ActivityPlanBase::getPlanCode, ActivityPlanBase::getPlanName));
            SimpleDateFormat sif = new SimpleDateFormat("yyyy-MM-dd");
            return (Page)byConditions.convert(planItem -> {
                ProductPromotionItemVo productPromotionItemVo = new ProductPromotionItemVo();
                productPromotionItemVo.setPlanCode(planItem.getPlanCode());
                productPromotionItemVo.setPlanName((String)planNameMap.get(planItem.getPlanCode()));
                productPromotionItemVo.setPlanOrgName(planItem.getActivityOrgName());
                productPromotionItemVo.setActivityType(planItem.getActivityTypeCode());
                productPromotionItemVo.setActivityForm(planItem.getActivityFormCode());
                if (planItem.getActivityBeginDate() != null) {
                    productPromotionItemVo.setBeginDate(planItem.getActivityBeginDate());
                }
                if (null != planItem.getActivityEndDate()) {
                    productPromotionItemVo.setEndDate(planItem.getActivityEndDate());
                }
                productPromotionItemVo.setBudgetItemCode(planItem.getBudgetItemCode());
                productPromotionItemVo.setFirstChannel(planItem.getFirstChannelCode());
                productPromotionItemVo.setSecondChannel(planItem.getSecondChannelCode());
                productPromotionItemVo.setSystem(planItem.getSystemCode());
                BigDecimal feeAmount = planItem.getFeeAmount();
                Integer promoteNumber = planItem.getPromoteNumber();
                productPromotionItemVo.setPromoteNumber(promoteNumber);
                if (feeAmount != null) {
                    productPromotionItemVo.setFeeAmount(planItem.getFeeAmount());
                    productPromotionItemVo.setOneFeeAmount(promoteNumber != null && promoteNumber != 0 ? feeAmount.divide(new BigDecimal(promoteNumber), 20, RoundingMode.HALF_UP) : null);
                }
                productPromotionItemVo.setCustomerFeeAmount(planItem.getCustomerFeeAmount());
                productPromotionItemVo.setCompanyFeeAmount(planItem.getDepartmentFeeAmount());
                productPromotionItemVo.setAuditConditionCode(planItem.getAuditConditionCode());
                productPromotionItemVo.setFeeRate(planItem.getFeeRate());
                return productPromotionItemVo;
            });
        }
        return new Page();
    }

    private Page<ProductPromotionItemVo> findItemFromActivityDetailPlan(Pageable pageable, ActivityDetailPlanItemDto activityDetailPlanItemDto) {
        Page byConditions = this.activityDetailPlanItemSdkService.findByConditions(pageable, activityDetailPlanItemDto);
        if (byConditions != null && byConditions.getRecords() != null) {
            List activityDetailPlanItemVoList = byConditions.getRecords();
            Set detailPlanCodes = activityDetailPlanItemVoList.stream().map(ActivityDetailPlanItemBase::getDetailPlanCode).filter(Objects::nonNull).collect(Collectors.toSet());
            List activityDetailPlanVos = this.activityDetailPlanSdkService.findByCodes(detailPlanCodes);
            Map<String, String> planNameMap = activityDetailPlanVos.stream().collect(Collectors.toMap(ActivityDetailPlanBase::getDetailPlanCode, ActivityDetailPlanBase::getDetailPlanName));
            return (Page)byConditions.convert(detailPlanItem -> {
                ProductPromotionItemVo productPromotionItemVo = new ProductPromotionItemVo();
                productPromotionItemVo.setPlanCode(detailPlanItem.getDetailPlanCode());
                productPromotionItemVo.setPlanName((String)planNameMap.get(detailPlanItem.getDetailPlanCode()));
                productPromotionItemVo.setPlanOrgName(detailPlanItem.getActivityOrgName());
                productPromotionItemVo.setActivityType(detailPlanItem.getActivityType());
                productPromotionItemVo.setActivityForm(detailPlanItem.getActivityForm());
                productPromotionItemVo.setBeginDate(detailPlanItem.getActivityBeginDate());
                productPromotionItemVo.setEndDate(detailPlanItem.getActivityEndDate());
                productPromotionItemVo.setBudgetItemCode(detailPlanItem.getBudgetItemCode());
                productPromotionItemVo.setFirstChannel(detailPlanItem.getFirstChannelCode());
                productPromotionItemVo.setSecondChannel(detailPlanItem.getSecondChannelCode());
                productPromotionItemVo.setSystem(detailPlanItem.getSystemCode());
                BigDecimal feeAmount = detailPlanItem.getFeeAmount();
                Integer promoteNumber = detailPlanItem.getPromoteNumber();
                productPromotionItemVo.setPromoteNumber(promoteNumber);
                if (feeAmount != null) {
                    productPromotionItemVo.setFeeAmount(detailPlanItem.getFeeAmount());
                    productPromotionItemVo.setOneFeeAmount(promoteNumber != null && promoteNumber != 0 ? feeAmount.divide(new BigDecimal(promoteNumber), 20, RoundingMode.HALF_UP) : null);
                }
                productPromotionItemVo.setCustomerFeeAmount(detailPlanItem.getCustomerFeeAmount());
                productPromotionItemVo.setCompanyFeeAmount(detailPlanItem.getDepartmentFeeAmount());
                productPromotionItemVo.setAuditConditionCode(detailPlanItem.getAuditConditionCode());
                return productPromotionItemVo;
            });
        }
        return new Page();
    }
}

