package com.biz.crm.tpm.business.activity.intensity.monitor.sdk.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.dto.ActivityIntensityMonitorDto;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo.ActivityIntensityMonitorVO;
import com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo.ProductPromotionItemVo;
import org.springframework.data.domain.Pageable;

import java.util.List;

/**
 *
 * @author : qiancheng
 * @date : 2022-11-14
 */
public interface ActivityIntensityMonitorService {

    /**
     * 分页查询数据
     *
     * @param pageable 分页对象
     * @param activityIntensityMonitor 实体对象
     * @return 分页数据
     */
    Page<ActivityIntensityMonitorVO> findByConditions(Pageable pageable, ActivityIntensityMonitorDto activityIntensityMonitor);


    /**
     * 通过主键id 查单条数据
     * @param id 主键id
     * @return 单条数据
     */
    ActivityIntensityMonitorVO findById(String id);

    /**
     * 查询并保存 活动细案中关联的产品 促销信息
     */
    void findDateFormActivityDetailPlan();

    /**
     * 查询并保存 活动方案中关联的产品 促销信息
     */
    void findDateFormActivityPlan();


    /**
     * 查询产品涉及的方案、细案详情
     * @param monitorType 监控类型
     * @param productCode 产品编码
     * @param orgCode 组织编码
     * @param customerCode 客户编码
     * @param planCode 方案/细案编码
     * @param planName 方案/细案名称
     * @return 方案/细案明细集合
     */
    Page<ProductPromotionItemVo> findItem(Pageable pageable,String monitorType, String productCode,String activityOrgCode,String customerCode,String yearMonthLy,String planCode,String planName);


    /**
     * 生成活动力度监控表
     *
     * @param yearMonthLy
     */
    void generateActivityIntensityMonitor(String yearMonthLy);
}
