package com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ActivityIntensityMonitorVO", description = "活动力度监控表vo")
public class ActivityIntensityMonitorVO extends TenantFlagOpVo {

    @ApiModelProperty(name = "businessFormatCode",value = "业态",notes = "业态")
    private String businessFormatCode;

    @ApiModelProperty(name = "businessUnitCode",value = "业务单元",notes = "业务单元")
    private String businessUnitCode;

    @ApiModelProperty(name = "monitorType",value = "监控类型",notes = "监控类型")
    private String monitorType;

    @ApiModelProperty("所属销售机构编码")
    private String salesInstitutionCode;

    @ApiModelProperty("所属销售机构erp编码")
    private String salesInstitutionErpCode;

    @ApiModelProperty("所属销售机构")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    private String salesOrgCode;

    @ApiModelProperty("所属销售组织(组)erp编码")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)名称")
    private String salesOrgName;

    @ApiModelProperty(name = "productCode",value = "产品编码",notes = "产品编码")
    private String productCode;

    @ApiModelProperty(name = "productName",value = "产品名称",notes = "产品名称")
    private String productName;

    @ApiModelProperty(name = "dateManufacture",value = "产品生产日期",notes = "产品生产日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    private Date dateManufacture;

    @ApiModelProperty(name = "unitCode",value = "单位编码",notes = "单位编码")
    private String unitCode;

    @ApiModelProperty(name = "unit",value = "单位",notes = "单位")
    private String unit;

    @ApiModelProperty(name = "redLinePrice", value = "红线价",notes = "红线价")
    private BigDecimal redLinePrice;

    @ApiModelProperty(name = "standardPrice", value = "标准定价",notes = "标准定价")
    private BigDecimal standardPrice;

    @ApiModelProperty(name = "superposedActivityIntensity", value = "叠加后活动力度",notes = "叠加后活动力度")
    private BigDecimal superposedActivityIntensity;

    @ApiModelProperty(name = "superposedPlanPrice", value = "叠加后规划价",notes = "叠加后规划价")
    private BigDecimal superposedPlanPrice;

    @ApiModelProperty(name = "deviation", value = "偏差率",notes = "偏差率")
    private BigDecimal deviation;

    @ApiModelProperty("活动数量")
    private BigDecimal activityQty;

    @ApiModelProperty("活动力度")
    private BigDecimal activityIntensity;

    @ApiModelProperty("力度类型")
    private String intensityType;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    private String customerCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    private String customerName;
    /**
     * 年月
     */
    @ApiModelProperty("年月")
    private String yearMonthLy;

}
