package com.biz.crm.tpm.business.activity.intensity.monitor.sdk.vo;

import com.biz.crm.business.common.sdk.vo.TenantFlagOpVo;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

@Data
@EqualsAndHashCode(callSuper = true)
@ApiModel(value = "ProductPromotionItemVo", description = "产品涉及的方案细案促销详情vo")
public class ProductPromotionItemVo extends TenantFlagOpVo {

    @ApiModelProperty(name = "planCode",value = "方案编码",notes = "方案编码")
    private String planCode;

    @ApiModelProperty(name = "planName",value = "方案名称",notes = "方案名称")
    private String planName;

    @ApiModelProperty(name = "planOrgName",value = "方案范围",notes = "方案范围")
    private String planOrgName;

    @ApiModelProperty(name = "activityType",value = "方案类型",notes = "方案类型")
    private String activityType;

    @ApiModelProperty(name = "activityForm",value = "活动形式",notes = "活动形式")
    private String activityForm;

    @ApiModelProperty(name = "beginDate",value = "活动开始时间",notes = "活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date beginDate;

    @ApiModelProperty(name = "endDate",value = "活动结束时间",notes = "活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    private Date endDate;

    @ApiModelProperty(name = "budgetItemCode",value = "预算项目编码",notes = "预算项目编码")
    private String budgetItemCode;

    @ApiModelProperty(name = "firstChannel",value = "一级管理渠道",notes = "一级管理渠道")
    private String firstChannel;

    @ApiModelProperty(name = "secondChannel",value = "二级管理渠道",notes = "二级管理渠道")
    private String secondChannel;

    @ApiModelProperty(name = "promotionObject",value = "促销对象",notes = "促销对象")
    private String promotionObject;

    @ApiModelProperty(name = "system",value = "系统",notes = "系统")
    private String system;

    @ApiModelProperty(name = "promote_number",value = "推广场次",notes = "推广场次")
    private Integer promoteNumber;

    @ApiModelProperty(name = "oneFeeAmount",value = "单场预估费用金额",notes = "单场预估费用金额")
    private BigDecimal oneFeeAmount;

    @ApiModelProperty(name = "feeAmount",value = "预估费用总金额",notes = "预估费用总金额")
    private BigDecimal feeAmount;

    @ApiModelProperty(name = "customerFeeAmount",value = "客户承担金额",notes = "客户承担金额")
    private BigDecimal customerFeeAmount;

    @ApiModelProperty(name = "companyFeeAmount",value = "公司承担金额",notes = "公司承担金额")
    private BigDecimal companyFeeAmount;

    @ApiModelProperty(name = "feeRate",value = "预估费率",notes = "预估费率")
    private BigDecimal feeRate;

    @ApiModelProperty(name = "auditConditionCode",value = "核销条件",notes = "核销条件")
    private String auditConditionCode;


}
