package com.biz.crm.tpm.business.activity.plan.feign;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.feign.impl.ActivityPlanSdkServiceFeignImpl;
import com.biz.crm.tpm.business.activity.plan.feign.impl.SfaPushActivityPlanFeignImpl;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanOutDto;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import io.swagger.annotations.ApiParam;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;
import java.util.Set;

/**
 * @ClassName ActivityPlanSdkServiceFeign
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/15
 */
@FeignClient(
        name = "${tpm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = ActivityPlanSdkServiceFeignImpl.class)
public interface ActivityPlanSdkServiceFeign {

    @GetMapping("/v1/activityPlan/findById")
    Result<ActivityPlanVo> findById(@RequestParam("id") String id);

    @PostMapping("/v1/activityPlan/saveActivityPlanNoCache")
    Result<ActivityPlanOutDto> createOrUpdateForOut(ActivityPlanOutDto dto);

    @PostMapping("/v1/activityPlan/atomSaveActivityPlan")
    Result<?> atomSaveActivityPlan(ActivityPlanOutDto dto);

    @PostMapping("/v1/activityPlan/deletePos")
    Result<?> delete(@ApiParam(value = "策略id集合")@RequestParam List<String> ids);
}
