package com.biz.crm.tpm.business.activity.plan.feign;

import com.biz.crm.tpm.business.activity.plan.feign.impl.SfaPushActivityPlanFeignImpl;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.*;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.display.SfaActivityPlanDisplayCreateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.person.SfaActivityPlanPersonCreateDto;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import com.biz.crm.business.common.sdk.model.Result;
import java.util.List;

/**
 * 活动占用推送feign
 * @author wanghaojia
 * @date 2023/1/5 17:02
 */
@FeignClient(
        name = "${mdm.feign-client.name:crm-tpm}",
        path = "crm-tpm",
        fallbackFactory = SfaPushActivityPlanFeignImpl.class)
public interface SfaPushActivityPlanFeign {

    /**
     * 更新SFA活动占用状态
     * @param updateList 要更新的数据
     */
    @PostMapping(value = "/v1/activityPlan/updateSfaActivityPlanState")
    Result updateSfaActivityPlanState(@RequestBody List<SfaActivityPlanItemStatusUpdateDto> updateList);

    /**
     * 人员费用创建TPM方案接口
     * @param list SFA活动数据
     * @return SFA明细号对应TPM方案号
     */
    @PostMapping(value = "/v1/activityPlan/sfaActivityPlanCreatePerson")
    Result<List<SfaActivityPlanCreateResult>> sfaActivityPlanCreatePerson(@RequestBody List<SfaActivityPlanPersonCreateDto> list);

    /**
     * 陈列费用创建TPM方案接口
     * @param list SFA活动数据
     * @return SFA明细号对应TPM方案号
     */
    @PostMapping(value = "/v1/activityPlan/sfaActivityPlanCreateDisplay")
    Result sfaActivityPlanCreateDisplay(@RequestBody List<SfaActivityPlanDisplayCreateDto> list);


}
