package com.biz.crm.tpm.business.activity.plan.feign.impl;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.feign.ActivityPlanSdkServiceFeign;
import com.biz.crm.tpm.business.activity.plan.feign.SfaPushActivityPlanFeign;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanOutDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.SfaActivityPlanItemStatusUpdateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import lombok.extern.slf4j.Slf4j;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @ClassName ActivityPlanSdkServiceFeignImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/15
 */
@Component
@Slf4j
public class ActivityPlanSdkServiceFeignImpl implements FallbackFactory<ActivityPlanSdkServiceFeign> {
    @Override
    public ActivityPlanSdkServiceFeign create(Throwable cause) {
        log.error("活动方案进入熔断");
        return new ActivityPlanSdkServiceFeign() {

            @Override
            public Result<ActivityPlanVo> findById(String id) {
                throw new UnsupportedOperationException("根据主键获取活动方案超时");
            }

            @Override
            public Result<ActivityPlanOutDto> createOrUpdateForOut(ActivityPlanOutDto dto) {
                throw new UnsupportedOperationException("新增或编辑活动方案超时");
            }

            @Override
            public Result<?> atomSaveActivityPlan(ActivityPlanOutDto dto) {
                throw new UnsupportedOperationException("新增活动方案超时");
            }

            @Override
            public Result<?> delete(List<String> ids) {
                throw new UnsupportedOperationException("删除活动方案超时");
            }
        };
    }
}
