package com.biz.crm.tpm.business.activity.plan.feign.impl;

import com.biz.crm.tpm.business.activity.plan.feign.SfaPushActivityPlanFeign;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.SfaActivityPlanCreateResult;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.display.SfaActivityPlanDisplayCreateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.SfaActivityPlanItemStatusUpdateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.person.SfaActivityPlanPersonCreateDto;
import org.springframework.cloud.openfeign.FallbackFactory;
import org.springframework.stereotype.Component;

import com.biz.crm.business.common.sdk.model.Result;
import java.util.List;

/**
 * SFA活动占用推送
 * @author wanghaojia
 * @date 2023/1/5 17:02
 */
@Component
public class SfaPushActivityPlanFeignImpl implements FallbackFactory<SfaPushActivityPlanFeign> {
    @Override
    public SfaPushActivityPlanFeign create(Throwable cause) {
        return new SfaPushActivityPlanFeign() {
            @Override
            public Result updateSfaActivityPlanState(List<SfaActivityPlanItemStatusUpdateDto> updateList) {
                throw new UnsupportedOperationException("进入熔断");
            }

            @Override
            public Result<List<SfaActivityPlanCreateResult>> sfaActivityPlanCreatePerson(List<SfaActivityPlanPersonCreateDto> list) {
                throw new UnsupportedOperationException("进入熔断");
            }

            @Override
            public Result sfaActivityPlanCreateDisplay(List<SfaActivityPlanDisplayCreateDto> list) {
                throw new UnsupportedOperationException("进入熔断");
            }
        };
    }
}
