package com.biz.crm.tpm.business.activity.plan.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.enums.DelFlagStatusEnum;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.feign.ActivityPlanSdkServiceFeign;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanOutDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.OperateActivityPlanBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.ActivityPlanSdkService;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanRelatePlanVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanStrategyVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanVo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

import java.util.List;
import java.util.Set;

/**
 * @ClassName ActivityPlanSdkServiceImpl
 * @Description
 * @Author: jiangyin
 * @Date 2023/5/15
 */
@Service
public class ActivityPlanSdkServiceImpl implements ActivityPlanSdkService {

    @Autowired(required = false)
    private ActivityPlanSdkServiceFeign activityPlanSdkServiceFeign;

    @Override
    public Page<ActivityPlanVo> findByConditions(Pageable pageable, ActivityPlanDto dto) {
        return null;
    }

    @Override
    public void operateBudget(List<OperateActivityPlanBudgetDto> planBudgetOperateList) {

    }

    @Override
    public void operateCustomerBudget(List<OperateActivityPlanBudgetDto> planBudgetOperateList) {

    }

    @Override
    public List<ActivityPlanVo> findByCodes(Set<String> planCodes) {
        return null;
    }

    @Override
    public List<ActivityPlanVo> findByPlanCodeList(Set<String> planCodes) {
        return null;
    }

    @Override
    public String findPlanCodeByPlanName(String planName) {
        return null;
    }

    @Override
    public List<ActivityPlanDto> buildActivityPlanParms(List<String> businessNoList) {
        return null;
    }

    @Override
    public List<ActivityPlanDto> findPlanDtoListByCodeList(List<String> businessNoList) {
        return null;
    }

    @Override
    public List<ActivityPlanItemDto> findItemDtoAndAttachListByPlanCodeList(List<String> planCodeList) {
        return null;
    }

    @Override
    public List<ActivityPlanStrategyVo> findActivityPlanStrategyVoList(List<String> planCodeList) {
        return null;
    }

    @Override
    public List<ActivityPlanVo> findPlanActivityEndTime(Set<String> activityDetailCodes) {
        return null;
    }

    @Override
    public List<ActivityPlanItemDto> findByPlanItem(String planCode) {
        return null;
    }

    @Override
    public List<ActivityPlanRelatePlanVo> findRelatePLan(String planCode) {
        return null;
    }

    @Override
    public void createActivityPlan(ActivityPlanDto planDto) {

    }

    @Override
    public ActivityPlanVo findByPlanItemCode(String planItemCode) {
        return null;
    }

    @Override
    public ActivityPlanVo findById(String id) {
        Result<ActivityPlanVo> result = this.activityPlanSdkServiceFeign.findById(id);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("活动方案详情查询失败：" + result.getMessage());
        } else if (result.getResult() != null && DelFlagStatusEnum.DELETE.getCode().equals(result.getResult().getDelFlag())) {
            throw new UnsupportedOperationException("该活动方案已删除");
        }
        return result.getResult();
    }

    @Override
    public ActivityPlanOutDto createForOut(ActivityPlanOutDto dto) {
        Result<ActivityPlanOutDto> result = activityPlanSdkServiceFeign.createOrUpdateForOut(dto);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("新增活动方案失败：" + result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public ActivityPlanOutDto updateForOut(ActivityPlanOutDto dto) {
        Result<?> result = activityPlanSdkServiceFeign.createOrUpdateForOut(dto);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("更新活动方案失败：" + result.getMessage().replaceAll("新增", "更新"));
        }
        return null;
    }

    @Override
    public void delete(List<String> ids) {
        Result<?> result = activityPlanSdkServiceFeign.delete(ids);
        if (!result.isSuccess()) {
            throw new UnsupportedOperationException("关闭活动方案失败：" + result.getMessage());
        }
    }

    @Override
    public Object atomCreate(ActivityPlanOutDto dto) {
        Result<?> result = activityPlanSdkServiceFeign.atomSaveActivityPlan(dto);
        if(!result.isSuccess()){
            throw new UnsupportedOperationException(result.getMessage());
        }
        return result.getResult();
    }

    @Override
    public void updateActivityDelayEndTime(List<ActivityPlanItemDto> list) {

    }

    @Override
    public List<ActivityPlanBudgetVo> findHeadquartersByRegionPlanCodes(Set<String> planCodes) {
        return null;
    }

    @Override
    public List<ActivityPlanVo> findActivityUsableBudget(List<String> planCodeList) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<ActivityPlanVo> findOrgCodeByPlanCode(List<String> planCodes) {
        throw new UnsupportedOperationException();
    }
}
