package com.biz.crm.tpm.business.activity.plan.service.impl;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.feign.SfaPushActivityPlanFeign;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.SfaActivityPlanCreateResult;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.display.SfaActivityPlanDisplayCreateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.SfaActivityPlanItemStatusUpdateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.person.SfaActivityPlanPersonCreateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.service.SfaPushActivityPlanService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * @author wanghaojia
 * @date 2023/1/5 16:52
 */
@Service
public class SfaPushActivityPlanServiceImpl implements SfaPushActivityPlanService {

    @Autowired(required = false)
    private SfaPushActivityPlanFeign sfaPushActivityPlanFeign;

    @Override
    public Result<List<SfaActivityPlanCreateResult>> sfaActivityPlanCreatePerson(List<SfaActivityPlanPersonCreateDto> list) {
        return sfaPushActivityPlanFeign.sfaActivityPlanCreatePerson(list);
    }

    @Override
    public Result sfaActivityPlanCreateDisplay(List<SfaActivityPlanDisplayCreateDto> list) {
        return sfaPushActivityPlanFeign.sfaActivityPlanCreateDisplay(list);
    }

    @Override
    public Result updateSfaActivityPlanState(List<SfaActivityPlanItemStatusUpdateDto> updateList) {
        return sfaPushActivityPlanFeign.updateSfaActivityPlanState(updateList);
    }

}
