package com.biz.crm.tpm.business.activity.plan.local.consumer;

import com.alibaba.fastjson.JSON;
import com.biz.crm.mn.common.rocketmq.service.AbstractRocketMqConsumer;
import com.biz.crm.mn.common.rocketmq.vo.MqMessageVo;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanPassMqTagConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.ActivityPlanItemPushSfaDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.ActivityPlanItemPushSfaListDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanPassMqTagEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.event.ActivityPlanPushSfaEventListener;
import com.bizunited.nebula.event.sdk.function.SerializableBiConsumer;
import com.bizunited.nebula.event.sdk.service.NebulaNetEventClient;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.apache.rocketmq.spring.annotation.ConsumeMode;
import org.apache.rocketmq.spring.annotation.MessageModel;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Objects;

/**
 * @author wanghaojia
 * @date 2023/1/16 19:59
 */
@Slf4j
@Component
@RocketMQMessageListener(topic = ActivityPlanConstant.TPM_ACTIVITY_PLAN_PROCESS_PASS_TOPIC + "${rocketmq.environment}",
        /**
         * tag
         * 可用 || 监听多个tag： "tag1 || tag2 || tag3"
         * 请把tag  定义在 *** 内 需要统一维护
        */
        selectorExpression = ActivityPlanPassMqTagConstant.PASS_PUSH_SFA,
        /**
         * 相同分组下 consumer 可自动负载均衡
         * 请把consumerGroup  定义在 *** 内 需要统一维护
        */
        consumerGroup = ActivityPlanPassMqTagConstant.PASS_PUSH_SFA + "${rocketmq.environment}",
        /**
         * 默认集群消费MqConstant
         * 可以设置 ConsumeMode.ORDERLY 使用广播消费
         * 也可使用集群模式模拟广播模式：
         * 启动多个不同 consumerGroup 的consumer实例
        */
        consumeMode = ConsumeMode.CONCURRENTLY,
        /**
         * 集群消费or广播消费;默认是集群消费
        */
        messageModel = MessageModel.CLUSTERING)
public class ActivityPlanPassPushSfaConsumer extends AbstractRocketMqConsumer {

    @Autowired(required = false)
    private ActivityPlanService activityPlanService;

    @Autowired
    private NebulaNetEventClient nebulaNetEventClient;

    @Override
    protected Object handleMessage(MqMessageVo message) {
        log.info("活动方案审批通过推送渠道平台 order mq message received  : {}", message);
        if (Objects.isNull(message)
                || StringUtils.isEmpty(message.getMsgBody())) {
            return "消息为空!";
        }

        try {
            //sfa推送活动方案
            //查询需要推送的方案明细数据
            List<String> businessNoList = JSON.parseArray(message.getMsgBody(), String.class);
            List<ActivityPlanItemPushSfaDto> dtos = activityPlanService.findSfaDataByPlanCodes(businessNoList);
            SerializableBiConsumer<ActivityPlanPushSfaEventListener, ActivityPlanItemPushSfaListDto> activityPlanProcessPass =
                    ActivityPlanPushSfaEventListener::pushActivityPlanListToSfa;
            ActivityPlanItemPushSfaListDto nebulaEventDto = new ActivityPlanItemPushSfaListDto();
            nebulaEventDto.setList(dtos);
            this.nebulaNetEventClient.publish(nebulaEventDto, ActivityPlanPushSfaEventListener.class, activityPlanProcessPass);
        }catch (Exception e){
            log.error(ActivityPlanPassMqTagEnum.PASS_PUSH_SFA.getName()+"处理失败"+e.getMessage(),e);
            return "消费失败."+e.getMessage();
        }

        return "消费成功.";
    }

}
