package com.biz.crm.tpm.business.activity.plan.local.controller;


import com.alibaba.fastjson.JSONObject;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanDockingSfaService;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.SfaActivityPlanCreateResult;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.display.SfaActivityPlanDisplayCreateDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.sfa.person.SfaActivityPlanPersonCreateDto;
import com.google.common.collect.Lists;
import io.swagger.annotations.Api;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * 活动方案表(ActivityPlan)表相关的http接口
 *
 * @author wanghaojia
 * @since 2022-10-31 15:55:41
 */
@RestController
@RequestMapping("/v1/activityPlan")
@Slf4j
@Api(tags = "活动方案表-渠道平台对接")
public class ActivityPlanDockingSfaController {

    @Autowired
    private ActivityPlanDockingSfaService activityPlanDockingSfaService;

    /**
     * 人员费用创建TPM方案接口
     * @param list SFA活动数据
     * @return SFA明细号对应TPM方案号
     */
    @PostMapping(value = "sfaActivityPlanCreatePerson")
    public Result<List<SfaActivityPlanCreateResult>> sfaActivityPlanCreatePerson(@RequestBody List<SfaActivityPlanPersonCreateDto> list){
        try {
            log.info(JSONObject.toJSONString(list));
            List<SfaActivityPlanCreateResult> result = this.activityPlanDockingSfaService.sfaActivityPlanCreatePerson(list);
            return Result.ok(result);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 陈列费用创建TPM方案接口
     * @param list SFA活动数据
     * @return SFA明细号对应TPM方案号
     */
    @PostMapping(value = "sfaActivityPlanCreateDisplay")
    public Result sfaActivityPlanCreateDisplay(@RequestBody List<SfaActivityPlanDisplayCreateDto> list){
        try {
            log.info(JSONObject.toJSONString(list));
            this.activityPlanDockingSfaService.sfaActivityPlanCreateDisplay(list);
            return Result.ok();
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

}
