package com.biz.crm.tpm.business.activity.plan.local.controller;


import com.aliyun.openservices.shade.com.google.common.collect.Lists;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.business.common.sdk.service.LoginUserService;
import com.biz.crm.mn.common.base.dto.CommonSelectDto;
import com.biz.crm.mn.common.base.eunm.BusinessUnitEnum;
import com.biz.crm.mn.common.base.service.RedisLockService;
import com.biz.crm.mn.common.base.util.DateUtil;
import com.biz.crm.mn.common.base.vo.CommonSelectVo;
import com.biz.crm.mn.common.page.cache.controller.MnPageCacheController;
import com.biz.crm.tpm.business.activities.template.config.sdk.dto.ActivitiesTemplateConfigDto;
import com.biz.crm.tpm.business.activities.template.config.sdk.enums.ActivitiesTemplateConfigTypeEnum;
import com.biz.crm.tpm.business.activities.template.config.sdk.service.ActivitiesTemplateSdkService;
import com.biz.crm.tpm.business.activities.template.config.sdk.vo.ActivitiesTemplateConfigVo;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractDto;
import com.biz.crm.tpm.business.activity.contract.sdk.dto.ActivityContractMaterialDto;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractStateEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.enums.ContractTypeEnum;
import com.biz.crm.tpm.business.activity.contract.sdk.service.ActivityContractSdkService;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractMaterialVo;
import com.biz.crm.tpm.business.activity.contract.sdk.vo.ActivityContractVo;
import com.biz.crm.tpm.business.activity.form.sdk.dto.ActivityFormSelectDto;
import com.biz.crm.tpm.business.activity.plan.local.entity.ActivityPlanItem;
import com.biz.crm.tpm.business.activity.plan.local.service.*;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.plan.sdk.constant.ActivityPlanConstant;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemBudgetDto;
import com.biz.crm.tpm.business.activity.plan.sdk.dto.ActivityPlanItemDto;
import com.biz.crm.tpm.business.activity.plan.sdk.enums.ActivityPlanTypeEnum;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemBudgetVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.type.sdk.dto.ActivityTypeSelectDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.dto.MarketingStrategyBudgetDto;
import com.biz.crm.tpm.business.marketing.strategy.sdk.vo.MarketingStrategyBudgetVo;
import com.biz.crm.workflow.sdk.enums.ProcessStatusEnum;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.Validate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Pageable;
import org.springframework.data.web.PageableDefault;
import org.springframework.util.Assert;
import org.springframework.web.bind.annotation.*;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Optional;

/**
 * 活动方案明细表(ActivityPlanItem)表相关的http接口
 *
 * @author wanghaojia
 * @since 2022-11-01 15:11:38
 */
@RestController
@RequestMapping("/v1/activityPlanItem")
@Slf4j
@Api(tags = "活动方案明细表")
public class ActivityPlanItemController extends MnPageCacheController<ActivityPlanItemVo,ActivityPlanItemDto> {
    /**
     * 服务对象
     */
    @Autowired
    private ActivityPlanItemService activityPlanItemService;
    /**
     * 服务对象
     */
    @Autowired
    private ActivityPlanItemTerminalService activityPlanItemTerminalService;
    /**
     * 加锁处理service
     */
    @Autowired
    private ActivityPlanLockService activityPlanLockService;
    /**
     * 加锁处理service
     */
    @Autowired
    private RedisLockService redisLockService;
    /**
     * 加锁处理service
     */
    @Autowired
    private ActivityPlanAsyncService activityPlanAsyncService;
  /**
     * 服务对象
     */
    @Autowired
    private ActivityPlanBudgetService activityPlanBudgetService;


    /**
     * 活动配置模板服务
     */
    @Autowired(required = false)
    private ActivitiesTemplateSdkService activitiesTemplateSdkService;

    @Autowired(required = false)
    private ActivityContractSdkService activityContractSdkService;

    @Autowired(required = false)
    private LoginUserService loginUserService;

    /**
     * 分页查询所有数据
     *
     * @param pageable            分页对象
     * @param activityPlanItemDto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findByConditions")
    public Result<Page<ActivityPlanItemVo>> findByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                             @ApiParam(name = "activityPlanItemDto", value = "方案查询实体") ActivityPlanItemDto activityPlanItemDto) {
        try {
            Page<ActivityPlanItemVo> page = this.activityPlanItemService.findByConditions(pageable, activityPlanItemDto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 活动方案申请可以选择的总部方案
     * @param pageable 分页对象
     * @param dto      查询实体
     * @return 所有数据ø
     */
    @ApiOperation(value = "活动方案申请可以选择的总部方案明细")
    @GetMapping("findRelateActivityPlanItemListByConditions")
    public Result<Page<ActivityPlanItemVo>> findRelateActivityPlanListByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                               @ApiParam(name = "ActivityPlanItemDto", value = "方案明细查询实体") ActivityPlanItemDto dto) {
        try {
            dto.setPlanType(ActivityPlanTypeEnum.headquarters.getCode());
            dto.setProcessStatus(ProcessStatusEnum.PASS.getKey());
            Page<ActivityPlanItemVo> page = this.activityPlanItemService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 分页查询活动方案明细预算所有数据
     *
     * @param pageable            分页对象
     * @param dto 查询实体
     * @return 所有数据
     */
    @ApiOperation(value = "分页查询所有数据")
    @GetMapping("findItemBudgetByConditions")
    public Result<Page<ActivityPlanItemBudgetVo>> findItemBudgetByConditions(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                             @ApiParam(name = "activityPlanItemDto", value = "查询实体") ActivityPlanItemBudgetDto dto) {
        try {
            Page<ActivityPlanItemBudgetVo> page = this.activityPlanItemService.findItemBudgetByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 关闭活动方案明细
     */
    @ApiOperation(value = "关闭活动方案明细")
    @PostMapping("closeItem")
    public Result<?> closeItem(@ApiParam(name = "ids", value = "关闭活动方案明细") @RequestBody List<String> ids) {
        try {
            if (redisLockService.isBatchLock(ActivityPlanConstant.LOCK_ACTIVITY_PLAN_ITEM_CLOSE, ids)) {
                throw new RuntimeException("操作正在进行中，请稍后操作");
            }
            //10活动方案明细基础验证
            List<ActivityPlanItem> itemList = activityPlanItemService.closeItemBaseVerifyItem(ids, true, Lists.newArrayList());
            Assert.notEmpty(itemList, "无有效可以关闭方案明细,请刷新重试!");
            activityPlanAsyncService.closeItemListAsync(itemList, loginUserService.getLoginUser());
            return Result.ok("关闭请求正在执行，请稍后查看执行结果");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 关闭活动方案明细
     */
    @ApiOperation(value = "关闭活动方案明细-通过方案id")
    @PostMapping("closeItemByPlanIds")
    public Result<?> closeItemByPlanIds(@ApiParam(name = "ids", value = "关闭活动方案明细") @RequestBody List<String> ids) {
        try {
            this.activityPlanAsyncService.closeItemByPlanIdsAsync(ids,loginUserService.getLoginUser());
            return Result.ok("关闭请求正在执行，请稍后查看执行结果");
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取活动方案可以选择的模板
     */
    @ApiOperation(value = "获取活动方案可以选择的模板")
    @PostMapping("findItemColumnConfigSelect")
    public Result<List<CommonSelectVo>> findItemColumnConfigSelect(@ApiParam(value = "模板编码") ActivitiesTemplateConfigDto configDto,
                                                                   @ApiParam(value = "活动类型dto")@RequestBody CommonSelectDto dto) {
        try {
            Validate.notBlank(configDto.getBusinessFormatCode(),"业态不能为空");
            Validate.notBlank(configDto.getBusinessUnitCode(),"业务单元不能为空");
            Validate.notBlank(configDto.getSchemeTypeCode(),"方案类型不能为空");
            //如果是小业务单元的话就查主体的模板
            if (BusinessUnitEnum.isDefaultBusinessUnit(configDto.getBusinessUnitCode())){
                configDto.setBusinessUnitCode(BusinessUnitEnum.HEADQUARTERS.getCode());
            }
            configDto.setType(ActivitiesTemplateConfigTypeEnum.SCHEME.getCode());
            List<CommonSelectVo> list = activitiesTemplateSdkService.findActivitiesTemplateConfigSelectList(dto, configDto);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取活动方案明细配置
     */
    @ApiOperation(value = "获取活动方案明细配置")
    @GetMapping("getItemColumnConfig")
    public Result<ActivitiesTemplateConfigVo> getItemColumnConfig(@ApiParam(value = "模板编码")@RequestParam(required = false) String configCode) {
        try {
            configCode = Optional.ofNullable(configCode).orElse(ActivityPlanConstant.ACTIVITY_PLAN_COLUMN_DEFAULT_TEMPLATE_CONFIG_CODE);
            ActivitiesTemplateConfigVo configVo = activitiesTemplateSdkService.findByCode(configCode);
            return Result.ok(configVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 活动类型下拉
     * @param dto 活动类型查询参数
     */
    @ApiOperation(value = "活动类型下拉")
    @PostMapping("findActivityTypeSelectList")
    public Result<List<CommonSelectVo>> findActivityTypeSelectList(@ApiParam(value = "活动类型dto")@RequestBody ActivityTypeSelectDto dto){
        try {
            List<CommonSelectVo> list = activityPlanItemService.findActivityTypeSelectList(dto);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 活动形式下拉
     * @param dto 活动形式查询参数
     */
    @ApiOperation(value = "活动形式下拉")
    @PostMapping("findActivityFormSelectList")
    public Result<List<CommonSelectVo>> findActivityFormSelectList(@ApiParam(value = "活动形式dto")@RequestBody ActivityFormSelectDto dto){
        try {
            List<CommonSelectVo> list = activityPlanItemService.findActivityFormSelectList(dto);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    /**
     * 获取活动方案可以选择的关联策略预算数据
     */
    @ApiOperation(value = "获取可以选择的策略预算数据")
    @GetMapping("findChooseStrategyBudgetList")
    public Result<Page<MarketingStrategyBudgetVo>> findChooseStrategyBudgetList(@ApiParam(name = "pageable", value = "分页对象") @PageableDefault(50) Pageable pageable,
                                                                                @ApiParam(name = "activityPlanItemDto", value = "查询实体") MarketingStrategyBudgetDto dto){
        try {
            Page<MarketingStrategyBudgetVo> page = this.activityPlanBudgetService.findChooseStrategyBudgetList(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 获取预算汇总信息
     *
     * @param cacheKey 缓存key
     * @return
     */
    @ApiOperation(value = "获取预算汇总信息")
    @PostMapping("findBudgetCacheSumList")
    public Result<List<ActivityPlanBudgetSumVo>> findBudgetCacheSumList(
            @ApiParam(name = "businessUnitCode", value = "业务单元") @RequestParam String businessUnitCode,
            @ApiParam(name = "cacheKey", value = "缓存键") @RequestParam String cacheKey) {
        try {
            List<ActivityPlanBudgetSumVo> list = this.activityPlanItemService.findBudgetCacheSumList(businessUnitCode,cacheKey);
            return Result.ok(list);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("计算销售计划占比")
    @PostMapping("calculateSalePlanProportion")
    public Result<Map<String, BigDecimal>> calculateSalePlanProportion(@RequestBody ActivityPlanItemDto dto){
        try {

            return Result.ok(this.activityPlanItemService.calculateSalePlanProportion(dto));
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("按门店分摊")
    @PostMapping("proportionByTerminal")
    public Result proportionByTerminal(@RequestBody ActivityPlanItemDto dto){
        try {
            this.activityPlanItemTerminalService.proportionByTerminal(dto);
            return Result.ok();
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("按岗店分摊")
    @PostMapping("proportionByTerminalEmployee")
    public Result proportionByTerminalEmployee(@RequestBody ActivityPlanItemDto dto){
        try {
            this.activityPlanItemTerminalService.proportionByTerminalEmployee(dto);
            return Result.ok();
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("行数据计算")
    @PostMapping("calculateItemData")
    public Result<ActivityPlanItemVo> calculateItemData(@RequestBody ActivityPlanItemDto dto){
        try {

            return Result.ok(activityPlanItemService.calculateItemData(dto));
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "获取没有活动细案的活动方案")
    @GetMapping("findPlanItemNoActivityDetail")
    public Result<?> findPlanItemNoActivityDetail(Pageable pageable, @RequestParam("yearMonth") String yearMonth, @RequestParam(value = "salesOrgCode", required = false) String salesOrgCode){
        try {
            Page<ActivityPlanItemVo> page = this.activityPlanItemService.findPlanItemNoActivityDetail(pageable, yearMonth, salesOrgCode);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "查询可以选择的合同")
    @GetMapping("findActivityContractByConditions")
    public Result<Page<ActivityContractVo>> findActivityContractByConditions(@ApiParam(name = "pageable", value = "分页对象")@PageableDefault(50) Pageable pageable,
                                                  @ApiParam(name = "activityPlanItemDto", value = "查询实体") ActivityContractDto dto){
        try {
            dto.setContractState(ContractStateEnum.CONFIRMED.getCode());
            dto.setContractType(ContractTypeEnum.SUPPLIER_CONTRACT.getCode());
            dto.setCompareDateStr(DateUtil.getDateStrByFormat(new Date(),DateUtil.DEFAULT_DATE_ALL_PATTERN));
            Page<ActivityContractVo> page = activityContractSdkService.findByConditions(pageable, dto);
            return Result.ok(page);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation(value = "查询可以选择的合同")
    @GetMapping("getActivityContractMaterial")
    public Result<ActivityContractMaterialVo> getActivityContractMaterial(ActivityContractMaterialDto dto){
        try {
            ActivityContractMaterialVo contractMaterialVo = activityContractSdkService.getActivityContractMaterial(dto);
            return Result.ok(contractMaterialVo);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

}
