package com.biz.crm.tpm.business.activity.plan.local.controller;

import com.biz.crm.business.common.sdk.model.Result;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanBudgetService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanItemService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanService;
import com.biz.crm.tpm.business.activity.plan.local.service.ActivityPlanVoService;
import com.biz.crm.tpm.business.activity.plan.local.vo.ActivityPlanBudgetSumVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.ActivityPlanItemVo;
import com.biz.crm.tpm.business.activity.plan.sdk.vo.submitreportvo.ActivityPlanSubmitReportMainVo;
import com.fasterxml.jackson.annotation.JsonInclude;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.List;

/**
 * 活动方案查询
 * @author wanghaojia
 * @date 2023/12/20 14:50
 */
@RestController
@RequestMapping("/v1/activityPlan")
@Slf4j
@Api(tags = "活动方案表")
public class ActivityPlanVoController {

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private ActivityPlanService activityPlanService;

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private ActivityPlanVoService activityPlanVoService;

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private ActivityPlanItemService activityPlanItemService;

    /**
     * 服务对象
     */
    @Autowired(required = false)
    private ActivityPlanBudgetService activityPlanBudgetService;

    /**
     * 根据id获取超预算提示
     *
     * @param ids 策略ids
     */
    @ApiOperation(value = "根据id获取超预算提示")
    @PostMapping(value = "submitIsOverBudgetByIds")
    public Result<List<String>> submitIsOverBudgetByIds(@ApiParam(value = "策略id集合")@RequestParam List<String> ids){
        try {
            List<String> msgs = this.activityPlanService.submitIsOverBudgetByIds(ids);
            return Result.ok(msgs);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("方案审批页面是否超收提示")
    @PostMapping("submitIsOverBudget")
    public Result<List<String>> submitIsOverBudget(@ApiParam(name = "processNo", value = "流程编号") @RequestParam String processNo) {
        try {
            List<String> msgs = this.activityPlanService.submitIsOverBudget(processNo);
            return Result.ok(msgs);
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("方案审批页面汇总")
    @PostMapping("submitPageReport")
    public Result<ActivityPlanSubmitReportMainVo> submitPageReport(@ApiParam(name = "processNo", value = "流程编号") @RequestParam String processNo) {
        try {
            return Result.ok(this.activityPlanService.submitPageReport(processNo));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }

    @ApiOperation("方案审批页面汇总")
    @PostMapping("modifySubmitPageReport")
    public Result<ActivityPlanSubmitReportMainVo> modifySubmitPageReport(@ApiParam(name = "processNo", value = "流程编号") @RequestParam String processNo) {
        try {
            return Result.ok(this.activityPlanService.modifySubmitPageReport(processNo));
        } catch (Exception e) {
            log.error(e.getMessage(), e);
            return Result.error(e.getMessage());
        }
    }


    /**
     * 活动方案移动审批关键指标-预算汇总信息
     * @param processNo 流程编码
     */
    @GetMapping("findActivityPlanItemSumInfoByProcessNo")
    @JsonInclude(JsonInclude.Include.NON_NULL)
    public Result<List<ActivityPlanItemVo>> findActivityPlanItemSumInfoByProcessNo(@RequestParam String processNo){
        try {
//          以申请的活动方案明细的活动开始时间、活动结束时间、区域、活动分类、活动形式维度进行统计								费用合计/预估销售额
            List<ActivityPlanItemVo> list = activityPlanVoService.findActivityPlanItemSumInfoByProcessNo(processNo);
            return Result.ok(list);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error("预算汇总信息查询失败:"+e.getMessage());
        }
    }

    /**
     * 活动方案移动审批关键指标-预算汇总信息
     * @param processNo 流程编码
     */
    @GetMapping("findActivityPlanBudgetSumInfoByProcessNo")
    public Result<List<ActivityPlanBudgetSumVo>> findActivityPlanBudgetSumInfoByProcessNo(@RequestParam String processNo){
        try {
//            预算项目	年月	本月累计可用金额（元）	管控累计可用金额（元）	本次使用金额（元）
            List<ActivityPlanBudgetSumVo> list = activityPlanVoService.findActivityPlanBudgetSumInfoByProcessNo(processNo);
            return Result.ok(list);
        }catch (Exception e){
            log.error(e.getMessage(),e);
            return Result.error("预算汇总信息查询失败:"+e.getMessage());
        }
    }

}
