package com.biz.crm.tpm.business.activity.plan.local.entity;

/**
 * 活动方案占用预算表
 * @author wanghaojia
 * @date 2022/11/26 11:17
 */

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.*;
import java.math.BigDecimal;

@ApiModel(value = "ActivityPlanBudget", description = "活动方案占用预算表")
@TableName("tpm_activity_plan_budget")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_budget")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_budget", comment = "活动方案占用预算表")
@Table(
        name = "tpm_activity_plan_budget",
        indexes = {
                @Index(name = "tpm_activity_plan_budget_inx1", columnList = "plan_code"),
                @Index(name = "tpm_activity_plan_budget_inx2", columnList = "plan_item_code"),
        }
)
public class ActivityPlanBudget extends TenantFlagOpEntity {

    /**
     * 方案编码
     */
    @ApiModelProperty("方案编码")
    @Column(name = "plan_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '方案编码'")
    private String planCode;

    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    @Column(name = "plan_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '活动方案明细编码'")
    private String planItemCode;

    /**
     * 关联策略编码
     */
    @ApiModelProperty("关联策略编码")
    @Column(name = "relate_strategy_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联策略编码'")
    private String relateStrategyCode;
    /**
     * 关联策略明细编码
     */
    @ApiModelProperty("关联策略明细编码")
    @Column(name = "relate_strategy_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联策略明细编码'")
    private String relateStrategyItemCode;
    /**
     * 上级方案编码
     */
    @ApiModelProperty("上级方案编码")
    @Column(name = "relate_plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '上级方案编码'")
    private String relatePlanCode;
    /**
     * 上级方案明细编码
     */
    @ApiModelProperty("上级方案明细编码")
    @Column(name = "relate_plan_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '上级方案明细编码'")
    private String relatePlanItemCode;

    /**
     * 占用类型，1-占用月度预算，2-占用方案预算,3-客户预算
     */
    @ApiModelProperty(value = "占用类型", notes = "")
    @Column(name = "occupy_type", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '占用类型'")
    private String occupyType;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算编码", notes = "")
    @Column(name = "month_budget_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算编码'")
    private String monthBudgetCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "预算项目编码", notes = "")
    @Column(name = "budget_item_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '预算编码'")
    private String budgetItemCode;

    /**
     * 预算项目名称
     */
    @ApiModelProperty(value = "预算项目名称", notes = "")
    @Column(name = "budget_item_name", nullable = true, length = 128, columnDefinition = "varchar(128) COMMENT '预算项目名称'")
    private String budgetItemName;


    /**
     * 费用归口[数据字典:tpm_fee_belong]
     */
    @ApiModelProperty(value = "费用归口[数据字典:tpm_fee_belong]", notes = "")
    @Column(name = "fee_belong_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT '费用归口[数据字典:tpm_fee_belong] '")
    private String feeBelongCode;

    /**
     * 累计可用余额
     */
    @ApiModelProperty(value = "累计可用余额", notes = "")
    @Column(name = "accumulated_available_balance", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '累计可用余额 '")
    private BigDecimal accumulatedAvailableBalance;

    /**
     * 本次使用金额
     */
    @ApiModelProperty(value = "本次使用金额", notes = "")
    @Column(name = "use_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '本次使用金额'")
    private BigDecimal useAmount;

    /**
     * 已占用金额
     */
    @ApiModelProperty(value = "已占用金额", notes = "")
    @Column(name = "used_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '已占用金额'")
    private BigDecimal usedAmount;

    /**
     * 回退预算金额
     */
    @ApiModelProperty(value = "回退预算金额", notes = "")
    @Column(name = "return_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '回退预算金额'")
    private BigDecimal returnAmount;

    /**
     * 已向下规划金额（分子公司活动规划用）
     */
    @ApiModelProperty(value = "已向下规划金额（分子公司活动规划用）", notes = "")
    @Column(name = "down_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '已向下规划金额（分子公司活动规划用） '")
    private BigDecimal downAmount;

    /**
     * 是否完全向下规划（分子公司活动规划用）
     */
    @ApiModelProperty("是否完全向下规划（分子公司活动规划用）")
    @Column(name = "is_all_down", length = 8, columnDefinition = "varchar(8) COMMENT '是否完全向下规划（分子公司活动规划用）'")
    private String isAllDown;

    /**
     * 关联方案预测明细编码（垂直）
     */
    @ApiModelProperty("关联方案预测明细编码")
    @Column(name = "scheme_forecast_detail_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联方案预测明细编码'")
    private String schemeForecastDetailCode;

}
