package com.biz.crm.tpm.business.activity.plan.local.entity;


import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantFlagOpEntity;
import com.biz.crm.common.ie.sdk.excel.annotations.CrmExcelColumn;
import com.fasterxml.jackson.annotation.JsonFormat;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;
import org.springframework.format.annotation.DateTimeFormat;

import javax.persistence.*;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 活动方案明细表(ActivityPlanItem)
 *
 * @author wanghaojia
 * @since 2022-11-01 14:39:19
 */
@ApiModel(value = "ActivityPlanItem", description = "活动方案明细表")
@TableName("tpm_activity_plan_item")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_item")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_item", comment = "活动方案明细表")
@Table(
        name = "tpm_activity_plan_item",
        indexes = {
                @Index(name = "tpm_activity_plan_item_inx1", columnList = "plan_item_code,", unique = true),
                @Index(name = "tpm_activity_plan_item_inx2", columnList = "plan_code,", unique = false),
                @Index(name = "tpm_activity_plan_item_inx3", columnList = "template_config_code,", unique = false),
                @Index(name = "tpm_activity_plan_item_inx4", columnList = "activity_number,", unique = false)
        }
)
public class ActivityPlanItem extends TenantFlagOpEntity {

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    @Column(name = "plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动方案编码'")
    private String planCode;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    @Column(name = "plan_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '活动方案明细编码'")
    private String planItemCode;

    /**
     * 方案模板编码
     */
    @ApiModelProperty("方案模板编码")
    @Column(name = "template_config_code", length = 32, columnDefinition = "varchar(32) COMMENT '方案模板编码'")
    private String templateConfigCode;

    @ApiModelProperty("活动号")
    @Column(name = "activity_number", length = 64, columnDefinition = "VARCHAR(64) COMMENT '活动号'")
    private String  activityNumber;

    /**
     * 本品生产日期
     */
    @ApiModelProperty("本品生产日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "this_product_production_date", length = 20, columnDefinition = "datetime COMMENT '本品生产日期 '")
    private Date thisProductProductionDate;
    /**
     * 赠品生产日期
     */
    @ApiModelProperty("赠品生产日期")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "gift_production_date", length = 20, columnDefinition = "datetime COMMENT '赠品生产日期 '")
    private Date giftProductionDate;



    /**
     * 活动类型编码
     */
    @ApiModelProperty("活动类型编码")
    @Column(name = "activity_type_code", length = 500, columnDefinition = "varchar(500) COMMENT '活动类型编码'")
    private String activityTypeCode;
    /**
     * 活动类型名称
     */
    @ApiModelProperty("活动类型名称")
    @Column(name = "activity_type_name", length = 1000, columnDefinition = "varchar(1000) COMMENT '活动类型名称'")
    private String activityTypeName;
    /**
     * 活动形式编码
     */
    @ApiModelProperty("活动形式编码")
    @Column(name = "activity_form_code", length = 500, columnDefinition = "varchar(500) COMMENT '活动形式编码'")
    private String activityFormCode;
    /**
     * 活动形式名称
     */
    @ApiModelProperty("活动形式名称")
    @Column(name = "activity_form_name", length = 1000, columnDefinition = "varchar(1000) COMMENT '活动形式名称'")
    private String activityFormName;
    /**
     * 活动开始时间
     */
    @ApiModelProperty("活动开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_begin_date", columnDefinition = "datetime COMMENT '活动开始时间'")
    private Date activityBeginDate;
    /**
     * 活动结束时间
     */
    @ApiModelProperty("活动结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "activity_end_date",  columnDefinition = "datetime COMMENT '活动结束时间'")
    private Date activityEndDate;

    /**
     * 订单开始时间
     */
    @ApiModelProperty("订单开始时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_begin_date",  columnDefinition = "datetime COMMENT '订单开始时间'")
    private Date orderBeginDate;
    /**
     * 订单结束时间
     */
    @ApiModelProperty("订单结束时间")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM-dd")
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @Column(name = "order_end_date",  columnDefinition = "datetime COMMENT '订单结束时间'")
    private Date orderEndDate;
    /**
     * 活动开始时间
     */
    @ApiModelProperty("费用所属年月")
    @JsonFormat(locale = "zh", timezone = "GMT+8", pattern = "yyyy-MM")
    @DateTimeFormat(pattern = "yyyy-MM")
    @Column(name = "fee_year_month", columnDefinition = "datetime COMMENT '费用所属年月'")
    private Date feeYearMonth;

    /**
     * 一级管理渠道
     */
    @ApiModelProperty("一级管理渠道编码")
    @Column(name = "first_channel_code", length = 128, columnDefinition = "varchar(128) COMMENT '一级管理渠道编码'")
    private String firstChannelCode;
    /**
     * 一级管理渠道名称
     */
    @ApiModelProperty("一级管理渠道名称")
    @Column(name = "first_channel_name", length = 255, columnDefinition = "varchar(255) COMMENT '一级管理渠道名称'")
    private String firstChannelName;
    /**
     * 二级管理渠道编码
     */
    @ApiModelProperty("二级管理渠道编码")
    @Column(name = "second_channel_code", length = 128, columnDefinition = "varchar(128) COMMENT '二级管理渠道编码'")
    private String secondChannelCode;
    /**
     * 二级管理渠道名称
     */
    @ApiModelProperty("二级管理渠道名称")
    @Column(name = "second_channel_name", length = 255, columnDefinition = "varchar(255) COMMENT '二级管理渠道名称'")
    private String secondChannelName;


    @ApiModelProperty("分销渠道编码")
    @Column(name = "distribution_channel_code", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道编码'")
    private String distributionChannelCode;

    @ApiModelProperty("分销渠道名称")
    @Column(name = "distribution_channel_name", length = 32, columnDefinition = "varchar(32) COMMENT '分销渠道名称'")
    private String distributionChannelName;

    /**
     * 关联策略编码
     */
    @ApiModelProperty("关联策略编码")
    @Column(name = "relate_strategy_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联策略编码'")
    private String relateStrategyCode;
    /**
     * 关联策略明细编码
     */
    @ApiModelProperty("关联策略明细编码")
    @Column(name = "relate_strategy_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '关联策略明细编码'")
    private String relateStrategyItemCode;
    /**
     * 上级方案编码
     */
    @ApiModelProperty("上级方案编码")
    @Column(name = "relate_plan_code", length = 32, columnDefinition = "varchar(32) COMMENT '上级方案编码'")
    private String relatePlanCode;
    /**
     * 上级方案明细编码
     */
    @ApiModelProperty("上级方案明细编码")
    @Column(name = "relate_plan_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '上级方案明细编码'")
    private String relatePlanItemCode;

    /**
     * 预算编码
     */
    @ApiModelProperty(value = "总部预算编码", notes = "")
    @Column(name = "head_month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '预算编码'")
    private String headMonthBudgetCode;

    /**
     * 总部预算项目编码
     */
    @ApiModelProperty("总部预算项目编码")
    @Column(name = "head_budget_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '总部预算项目编码'")
    private String headBudgetItemCode;

    /**
     * 总部预算项目名称
     */
    @ApiModelProperty("总部预算项目名称")
    @Column(name = "head_budget_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '总部预算项目名称'")
    private String headBudgetItemName;

    /**
     * 大区预算编码
     */
    @ApiModelProperty(value = "预算编码/大区预算编码", notes = "")
    @Column(name = "month_budget_code", length = 32, columnDefinition = "varchar(32) COMMENT '大区预算编码'")
    private String monthBudgetCode;

    /**
     * 大区预算项目编码
     */
    @ApiModelProperty("大区预算项目编码")
    @Column(name = "budget_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '大区预算项目编码'")
    private String budgetItemCode;

    /**
     * 大区预算项目名称
     */
    @ApiModelProperty("大区预算项目名称")
    @Column(name = "budget_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '大区预算项目名称'")
    private String budgetItemName;

    @ApiModelProperty(name = "扣费标准", notes = "扣费标准")
    @Column(name = "fee_standard", length = 256, columnDefinition = "VARCHAR(256) COMMENT '扣费标准'")
    private String feeStandard;


    /**
     * 大区公投预算编码
     */
    @ApiModelProperty(value = "大区公投预算编码", notes = "")
    @Column(name = "region_referendum_month_budget_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区公投预算编码'")
    private String regionReferendumMonthBudgetCode;

    /**
     * 大区公投项目编码
     */
    @ApiModelProperty(value = "大区公投预算项目编码", notes = "")
    @Column(name = "region_referendum_budget_item_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区公投预算项目编码'")
    private String regionReferendumBudgetItemCode;

    /**
     * 大区公投预算项目名称
     */
    @ApiModelProperty(value = "大区公投预算项目名称", notes = "")
    @Column(name = "region_referendum_budget_item_name", nullable = true, length = 1024, columnDefinition = "varchar(255) COMMENT '大区公投预算项目名称'")
    private String regionReferendumBudgetItemName;

    /**
     * 大区公投预算编码
     */
    @ApiModelProperty(value = "大区自投预算编码", notes = "")
    @Column(name = "region_automatic_month_budget_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区自投预算编码'")
    private String regionAutomaticMonthBudgetCode;

    /**
     * 大区公投项目编码
     */
    @ApiModelProperty(value = "大区自投预算项目编码", notes = "")
    @Column(name = "region_automatic_budget_item_code", nullable = true, length = 512, columnDefinition = "varchar(512) COMMENT '大区自投预算项目编码'")
    private String regionAutomaticBudgetItemCode;

    /**
     * 大区公投预算项目名称
     */
    @ApiModelProperty(value = "大区自投预算项目名称", notes = "")
    @Column(name = "region_automatic_budget_item_name", nullable = true, length = 1024, columnDefinition = "varchar(255) COMMENT '大区自投预算项目名称'")
    private String regionAutomaticBudgetItemName;

    /**
     * 区域编码
     */
    @ApiModelProperty("区域编码")
    @Column(name = "activity_org_code", length = 32, columnDefinition = "varchar(32) COMMENT '区域编码'")
    private String activityOrgCode;
    /**
     * 区域名称
     */
    @ApiModelProperty("区域名称")
    @Column(name = "activity_org_name", length = 255, columnDefinition = "varchar(255) COMMENT '区域名称'")
    private String activityOrgName;
    /**
     * 促销对象
     */
    @ApiModelProperty("促销对象")
    @Column(name = "promotion_object", length = 32, columnDefinition = "varchar(32) COMMENT '促销对象'")
    private String promotionObject;
    /**
     * 系统/零售商编码
     */
    @ApiModelProperty("系统/零售商编码")
    @Column(name = "system_code", length = 32, columnDefinition = "varchar(32) COMMENT '系统/零售商编码'")
    private String systemCode;
    /**
     * 系统/零售商名称
     */
    @ApiModelProperty("系统/零售商名称")
    @Column(name = "system_name", length = 200, columnDefinition = "varchar(200) COMMENT '系统/零售商名称'")
    private String systemName;
    /**
     * 数量
     */
    @ApiModelProperty("数量")
    @Column(name = "quantity", length = 11, columnDefinition = "int(11) COMMENT '数量'")
    private Integer quantity;

    /**
     * 预估销售额
     */
    @ApiModelProperty("预估销售额")
    @Column(name = "sales_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '预估销售额'")
    private BigDecimal salesAmount;

    /**
     * 单店金额
     */
    @ApiModelProperty("单店金额")
    @Column(name = "terminal_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '单店金额'")
    private BigDecimal terminalFeeAmount;

    /**
     * 预估费用 -我方承担金额
     */
    @ApiModelProperty("预估费用 -我方承担金额")
    @Column(name = "fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '预估费用 -我方承担金额'")
    private BigDecimal feeAmount;
    /**
     * 总部承担金额
     */
    @ApiModelProperty("总部承担金额")
    @Column(name = "head_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '总部承担金额'")
    private BigDecimal headFeeAmount;
    /**
     * 大区承担金额
     */
    @ApiModelProperty("大区承担金额")
    @Column(name = "department_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '大区承担金额'")
    private BigDecimal departmentFeeAmount;
    /**
     * 客户承担金额
     */
    @ApiModelProperty("客户承担金额")
    @Column(name = "customer_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '客户承担金额'")
    private BigDecimal customerFeeAmount;
    /**
     * 费用合计
     */
    @ApiModelProperty("费用合计")
    @Column(name = "total_fee_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '费用合计'")
    private BigDecimal totalFeeAmount;

    /**
     * 大区公投预算金额
     */
    @ApiModelProperty("大区公投预算金额（元）")
    @Column(name = "region_referendum_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '大区公投预算金额（元）'")
    private BigDecimal regionReferendumFeeAmount;

    /**
     * 大区自投预算金额
     */
    @ApiModelProperty("大区自投预算金额（元）")
    @Column(name = "region_automatic_fee_amount", nullable = true, length = 24, columnDefinition = "decimal(24,6) COMMENT '大区自投预算金额（元）'")
    private BigDecimal regionAutomaticFeeAmount;

    /**
     * 已使用金额（元）
     */
    @ApiModelProperty("已使用金额（元）")
    @Column(name = "used_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '已使用金额（元）'")
    private BigDecimal usedAmount;

    /**
     * 预估费率
     */
    @ApiModelProperty("预估费率")
    @Column(name = "fee_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '预估费率'")
    private BigDecimal feeRate;
    /**
     * 核销条件编码
     */
    @ApiModelProperty("核销条件编码")
    @Column(name = "audit_condition_code", length = 32, columnDefinition = "varchar(32) COMMENT '核销条件编码'")
    private String auditConditionCode;
    /**
     * 核销条件名称
     */
    @ApiModelProperty("核销条件名称")
    @Column(name = "audit_condition_name", length = 255, columnDefinition = "varchar(255) COMMENT '核销条件名称'")
    private String auditConditionName;
    /**
     * 促销类型
     */
    @ApiModelProperty("促销类型")
    @Column(name = "promotion_type", length = 32, columnDefinition = "varchar(32) COMMENT '促销类型'")
    private String promotionType;
    /**
     * 销售目标
     */
    @ApiModelProperty("销售目标")
    @Column(name = "sales_target", length = 24, columnDefinition = "decimal(24,6) COMMENT '销售目标'")
    private BigDecimal salesTarget;
    /**
     * 促销政策编码
     */
    @ApiModelProperty("促销政策编码")
    @Column(name = "promotion_code", length = 32, columnDefinition = "varchar(32) COMMENT '促销政策编码'")
    private String promotionCode;
    /**
     * 促销政策名称
     */
    @ApiModelProperty("促销政策名称")
    @Column(name = "promotion_name", length = 255, columnDefinition = "varchar(255) COMMENT '促销政策名称'")
    private String promotionName;
    /**
     * 品牌编码
     */
    @ApiModelProperty("品牌编码")
    @Column(name = "product_brand_code", length = 32, columnDefinition = "varchar(32) COMMENT '品牌编码'")
    private String productBrandCode;
    /**
     * 品牌名称
     */
    @ApiModelProperty("品牌名称")
    @Column(name = "product_brand_name", length = 255, columnDefinition = "varchar(255) COMMENT '品牌名称'")
    private String productBrandName;
    /**
     * 品类编码
     */
    @ApiModelProperty("品类编码")
    @Column(name = "product_category_code", length = 32, columnDefinition = "varchar(32) COMMENT '品类编码'")
    private String productCategoryCode;
    /**
     * 品类名称
     */
    @ApiModelProperty("品类名称")
    @Column(name = "product_category_name", length = 255, columnDefinition = "varchar(255) COMMENT '品类名称'")
    private String productCategoryName;
    /**
     * 品项编码
     */
    @ApiModelProperty("品项编码")
    @Column(name = "product_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '品项编码'")
    private String productItemCode;
    /**
     * 品项名称
     */
    @ApiModelProperty("品项名称")
    @Column(name = "product_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '品项名称'")
    private String productItemName;
    /**
     * 考核产品编码
     */
    @ApiModelProperty("考核产品编码")
    @Column(name = "assess_product_code", length = 32, columnDefinition = "varchar(32) COMMENT '考核产品编码'")
    private String assessProductCode;
    /**
     * 考核产品名称
     */
    @ApiModelProperty("考核产品名称")
    @Column(name = "assess_product_name", length = 255, columnDefinition = "varchar(255) COMMENT '考核产品名称'")
    private String assessProductName;
    /**
     * 产品编码
     */
    @ApiModelProperty("产品编码")
    @Column(name = "product_code", length = 255, columnDefinition = "varchar(255) COMMENT '产品编码'")
    private String productCode;
    /**
     * 产品名称
     */
    @ApiModelProperty("产品名称")
    @Column(name = "product_name", length = 255, columnDefinition = "varchar(255) COMMENT '产品名称'")
    private String productName;
    /**
     * 产品单位
     */
    @ApiModelProperty("产品单位")
    @Column(name = "product_unit", length = 32, columnDefinition = "varchar(32) COMMENT '产品单位'")
    private String productUnit;
    /**
     * 产品数量
     */
    @ApiModelProperty("产品数量")
    @Column(name = "product_quantity", length = 11, columnDefinition = "int(11) COMMENT '赠品数量'")
    private Integer productQuantity;
    /**
     * 品项组价格
     */
    @ApiModelProperty("品项组价格")
    @Column(name = "product_item_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '品项组价格'")
    private BigDecimal productItemPrice;
    /**
     * 赠品品项编码
     */
    @ApiModelProperty("赠品品项编码")
    @Column(name = "gift_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '赠品品项编码'")
    private String giftItemCode;
    /**
     * 赠品品项名称
     */
    @ApiModelProperty("赠品品项名称")
    @Column(name = "gift_item_name", length = 255, columnDefinition = "varchar(255) COMMENT '赠品品项名称'")
    private String giftItemName;
    /**
     * 赠品编码
     */
    @ApiModelProperty("赠品编码")
    @Column(name = "gift_code", length = 32, columnDefinition = "varchar(32) COMMENT '赠品编码'")
    private String giftCode;
    /**
     * 赠品名称
     */
    @ApiModelProperty("赠品名称")
    @Column(name = "gift_name", length = 255, columnDefinition = "varchar(255) COMMENT '赠品名称'")
    private String giftName;
    /**
     * 赠品单位
     */
    @ApiModelProperty("赠品单位")
    @Column(name = "gift_unit", length = 32, columnDefinition = "varchar(32) COMMENT '赠品单位'")
    private String giftUnit;
    /**
     * 赠品数量
     */
    @ApiModelProperty("赠品数量")
    @Column(name = "gift_quantity", length = 11, columnDefinition = "int(11) COMMENT '赠品数量'")
    private Integer giftQuantity;
    /**
     * 赠品总量
     */
    @ApiModelProperty("赠品总量")
    @Column(name = "gift_weight", length = 24, columnDefinition = "decimal(24,6) COMMENT '赠品总量'")
    private BigDecimal giftWeight;
    /**
     * 赠品品项组价格
     */
    @ApiModelProperty("赠品品项组价格")
    @Column(name = "gift_item_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '赠品品项组价格'")
    private BigDecimal giftItemPrice;
    /**
     * 赠品品项组特价
     */
    @ApiModelProperty("赠品品项组特价")
    @Column(name = "gift_item_special_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '赠品品项组特价'")
    private BigDecimal giftItemSpecialPrice;
    /**
     * 结案周期
     */
    @ApiModelProperty("结案周期")
    @Column(name = "audit_cycle", length = 32, columnDefinition = "varchar(32) COMMENT '结案周期'")
    private String auditCycle;
    /**
     * 结案形式
     */
    @ApiModelProperty("结案形式")
    @Column(name = "audit_form", length = 32, columnDefinition = "varchar(32) COMMENT '结案形式'")
    private String auditForm;
    /**
     * 供应商编码
     */
    @ApiModelProperty("供应商编码")
    @Column(name = "supplier_code", length = 32, columnDefinition = "varchar(32) COMMENT '供应商编码'")
    private String supplierCode;
    /**
     * 供应商名称
     */
    @ApiModelProperty("供应商名称")
    @Column(name = "supplier_name", length = 255, columnDefinition = "varchar(255) COMMENT '供应商名称'")
    private String supplierName;
    /**
     * 物料编码
     */
    @ApiModelProperty("物料编码")
    @Column(name = "material_code", length = 32, columnDefinition = "varchar(32) COMMENT '物料编码'")
    private String materialCode;
    /**
     * 物料名称
     */
    @ApiModelProperty("物料名称")
    @Column(name = "material_name", length = 255, columnDefinition = "varchar(255) COMMENT '物料名称'")
    private String materialName;
    /**
     * 物料数量
     */
    @ApiModelProperty("物料数量")
    @Column(name = "material_quantity", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '物料数量'")
    private BigDecimal materialQuantity;
    /**
     * 单价
     */
    @ApiModelProperty("单价")
    @Column(name = "price", length = 24, columnDefinition = "decimal(24,6) COMMENT '单价'")
    private BigDecimal price;
    /**
     * 推广场次
     */
    @ApiModelProperty("推广场次")
    @Column(name = "promote_number", length = 11, columnDefinition = "int(11) COMMENT '推广场次'")
    private Integer promoteNumber;

    /**
     * 扣款方式
     */
    @ApiModelProperty("扣款方式/是否扣款，   Y是N否")
    @Column(name = "deduct_type", length = 32, columnDefinition = "varchar(32) COMMENT '扣款方式'")
    private String deductType;
    /**
     * 是否关闭，   Y是N否
     */
    @ApiModelProperty(name = "isClose", notes = "是否关闭", value = "是否关闭，   Y是N否")
    @Column(name = "is_close", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否关闭，   Y是N否'")
    private String isClose;

    @ApiModelProperty(name = "扣费类型", notes = "扣费类型")
    @Column(name = "fee_type", length = 32, columnDefinition = "VARCHAR(32) COMMENT '扣费类型'")
    private String feeType;

    /**
     * 已向下规划金额（分子公司活动规划用）
     */
    @ApiModelProperty(value = "已向下规划金额（分子公司活动规划用）", notes = "")
    @Column(name = "down_amount", length = 20, columnDefinition = "DECIMAL(20,6) COMMENT '已向下规划金额（分子公司活动规划用） '")
    private BigDecimal downAmount;

    /**
     * 是否完全向下规划（分子公司活动规划用）
     */
    @ApiModelProperty("是否完全向下规划（分子公司活动规划用）")
    @Column(name = "is_all_down", length = 8, columnDefinition = "varchar(8) COMMENT '是否完全向下规划（分子公司活动规划用）'")
    private String isAllDown;

    @ApiModelProperty("费用归属年月")
    @Column(name = "fee_belong_year_month", length = 10, columnDefinition = "varchar(10) COMMENT '费用归属年月'")
    private String feeBelongYearMonth;

    @ApiModelProperty("税率")
    @Column(name = "tax_rate", columnDefinition = "DECIMAL(20,6) COMMENT '税率'")
    private BigDecimal taxRate;

    @ApiModelProperty("赠品税率")
    @Column(name = "gift_tax_rate", columnDefinition = "DECIMAL(20,6) COMMENT '赠品税率'")
    private BigDecimal giftTaxRate;

    @ApiModelProperty("系统月计划量")
    @Column(name = "system_month_plan_quantity",columnDefinition = "DECIMAL(20,6) COMMENT '系统月计划量'")
    private BigDecimal systemMonthPlanQuantity;

    @ApiModelProperty("合同编码")
    @Column(name = "contract_code", length = 32, columnDefinition = "varchar(32) COMMENT '合同编码'")
    private String contractCode;

    @ApiModelProperty("系统承担比例")
    @Column(name = "system_assume_ratio", columnDefinition = "DECIMAL(24,6) COMMENT '系统承担比例'")
    private BigDecimal systemAssumeRatio;

    @ApiModelProperty("我方承担比例")
    @Column(name = "our_assume_ratio", columnDefinition = "DECIMAL(24,6) COMMENT '我方承担比例'")
    private BigDecimal ourAssumeRatio;

    /**
     * 系统承担金额
     */
    @ApiModelProperty("系统承担金额")
    @Column(name = "system_borne_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '系统承担金额'")
    private BigDecimal systemBorneAmount;

    @ApiModelProperty("浮动率")
    @Column(name = "floating_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '浮动率'")
    private BigDecimal floatingRate;
    /**
     * 区域
     */
    @ApiModelProperty("区域")
    @Column(name = "region", length = 255, columnDefinition = "varchar(255) COMMENT '区域'")
    private String region;
    /**
     * 城市名称
     */
    @ApiModelProperty("城市名称")
    @Column(name = "city_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '城市名称 '")
    private String cityName;

    /**
     * 扣费细项
     */
    @ApiModelProperty("扣费细项")
    @Column(name = "deduction_details", length = 32, columnDefinition = "varchar(32) COMMENT '扣费细项'")
    private String deductionDetails;

    /**
     * 扣费细项名称
     */
    @ApiModelProperty("扣费细项名称")
    @Column(name = "deduction_details_name", length = 255, columnDefinition = "varchar(255) COMMENT '扣费细项名称'")
    private String deductionDetailsName;

    /**
     * 客户编码
     */
    @ApiModelProperty("客户编码")
    @Column(name = "customer_code", length = 255, columnDefinition = "varchar(255) COMMENT '客户编码'")
    private String customerCode;
    /**
     * 客户编码
     */
    @ApiModelProperty("客户ERP编码")
    @Column(name = "customer_erp_code", length = 32, columnDefinition = "varchar(32) COMMENT '客户ERP编码'")
    private String customerErpCode;
    /**
     * 客户名称
     */
    @ApiModelProperty("客户名称")
    @Column(name = "customer_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerName;

    @CrmExcelColumn(value = "客户组编码")
    @Column(name = "customer_group_code", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerGroupCode;
    @CrmExcelColumn(value = "客户组名称")
    @Column(name = "customer_group_name", length = 255, columnDefinition = "varchar(255) COMMENT '客户名称'")
    private String customerGroupName;
    /**
     * AC分仓编码
     */
    @ApiModelProperty("AC分仓编码")
    @Column(name = "ac_warehouse_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT 'AC分仓编码 '")
    private String acWarehouseCode;

    /**
     * AC门店类型
     */
    @ApiModelProperty("AC门店类型")
    @Column(name = "ac_store_type", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT 'AC门店类型'")
    private String acStoreType;


    /**
     * 原供价（本品）
     */
    @ApiModelProperty("原供价（本品）")
    @Column(name = "original_supply_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '原供价（本品）'")
    private BigDecimal originalSupplyPrice;
    /**
     * 原未税价格（本品）
     */
    @ApiModelProperty("原未税价格（本品）")
    @Column(name = "original_price_product", length = 24, columnDefinition = "decimal(24,6) COMMENT '原未税价格（本品）'")
    private BigDecimal originalPriceProduct;

    /**
     * 原供价（赠品）
     */
    @ApiModelProperty( "原供价（赠品）")
    @Column(name = "original_price_gift", length = 24, columnDefinition = "decimal(24,6) COMMENT '原供价（赠品）'")
    private BigDecimal originalPriceGift;
    /**
     * 原未税价格（赠品）
     */
    @ApiModelProperty("原未税价格（赠品）")
    @Column(name = "original_tax_price_gift", length = 24, columnDefinition = "decimal(24,6) COMMENT '原未税价格（赠品）'")
    private BigDecimal originalTaxPriceGift;
    /**
     * 促销含税供价
     */
    @ApiModelProperty("促销含税供价")
    @Column(name = "promotion_price_tax", length = 24, columnDefinition = "decimal(24,6) COMMENT '促销含税供价'")
    private BigDecimal promotionPriceTax;
    /**
     * 促销未税供价
     */
    @ApiModelProperty("促销未税供价")
    @Column(name = "promotion_non_tax_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '促销未税供价'")
    private BigDecimal promotionNonTaxPrice;
    /**
     * 零售价
     */
    @ApiModelProperty("零售价")
    @Column(name = "retail_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '零售价'")
    private BigDecimal retailPrice;
    /**
     * 促销售价
     */
    @ApiModelProperty("促销售价")
    @Column(name = "promotional_price", length = 24, columnDefinition = "decimal(24,6) COMMENT '促销售价'")
    private BigDecimal promotionalPrice;

    /**
     * 原毛利率
     */
    @ApiModelProperty("原毛利率")
    @Column(name = "original_gross_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '原毛利率'")
    private BigDecimal originalGrossRate;
    /**
     * 促销毛利率
     */
    @ApiModelProperty("促销毛利率")
    @Column(name = "promotional_gross_rate", length = 24, columnDefinition = "decimal(24,6) COMMENT '促销毛利率'")
    private BigDecimal promotionalGrossRate;

    /**
     * 单件申请费用
     */
    @ApiModelProperty("单件申请费用")
    @Column(name = "single_application_fee", length = 24, columnDefinition = "decimal(24,6) COMMENT '单件申请费用'")
    private BigDecimal singleApplicationFee;
    /**
     * 期间促销件数
     */
    @ApiModelProperty("期间促销件数")
    @Column(name = "period_promotional_number", length = 11, columnDefinition = "int(11) COMMENT '期间促销件数'")
    private Integer periodPromotionalNumber;




//    期间促销金额、系统承担金额、我方承担金额、是否共用、门店共用量、门店共用金额、浮动率、浮动量、浮动金额、活动描述

    /**
     * 期间促销金额
     */
    @ApiModelProperty("期间促销金额")
    @Column(name = "period_promotional_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '期间促销金额'")
    private BigDecimal periodPromotionalAmount;

    /**
     * 是否公用
     */
    @ApiModelProperty("是否公用")
    @Column(name = "public_or_not", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '是否公用'")
    private String publicOrNot;

    /**
     * 门店公用量
     */
    @ApiModelProperty("门店公用量")
    @Column(name = "store_utility", length = 11, columnDefinition = "int(11) COMMENT '门店公用量'")
    private Integer storeUtility;
    /**
     * 门店公用金额
     */
    @ApiModelProperty("门店公用金额")
    @Column(name = "store_public_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '门店公用金额'")
    private BigDecimal storePublicAmount;
    /**
     * 浮动量
     */
    @ApiModelProperty("浮动量")
    @Column(name = "floating_number", length = 11, columnDefinition = "decimal(24,6) COMMENT '浮动量'")
    private BigDecimal floatingNumber;
    /**
     * 浮动金额
     */
    @ApiModelProperty("浮动金额")
    @Column(name = "floating_amount", length = 24, columnDefinition = "decimal(24,6) COMMENT '浮动金额'")
    private BigDecimal floatingAmount;
    /**
     * 活动描述
     */
    @ApiModelProperty("活动描述")
    @Column(name = "activity_desc", length = 255, columnDefinition = "varchar(1024) COMMENT '活动描述'")
    private String activityDesc;


    @ApiModelProperty("是否扣减费用池")
    @Column(name = "is_deduction_fee_pool", length = 255, columnDefinition = "varchar(16) COMMENT '是否扣减费用池'")
    private String isDeductionFeePool;

    /**
     * 核销方式
     */
    @ApiModelProperty("核销方式")
    @Column(name = "write_off_method", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '核销方式'")
    private String writeOffMethod;

    @ApiModelProperty("城市等级")
    @Column(name = "city_level", length = 32, columnDefinition = "varchar(32) COMMENT '城市等级'")
    private String cityLevel;
    /**
     * 档期开始日期
     */
    @ApiModelProperty("档期开始日期")
    @Column(name = "schedule_begin_date", columnDefinition = "datetime COMMENT '档期开始日期'")
    private Date scheduleBeginDate;
    /**
     * 档期结束日期
     */
    @ApiModelProperty("档期结束日期")
    @Column(name = "schedule_end_date", columnDefinition = "datetime COMMENT '档期结束日期'")
    private Date scheduleEndDate;
    /**
     * 核销类型
     */
    @ApiModelProperty("核销类型")
    @Column(name = "audit_type", length = 20, columnDefinition = "varchar(20) COMMENT '核销类型'")
    private String auditType;

    @ApiModelProperty("未含税单价")
    @Column(name = "price_no_tax", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '未含税单价'")
    private BigDecimal priceNoTax;

    @ApiModelProperty("含税单价")
    @Column(name = "price_with_tax", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '含税单价'")
    private BigDecimal priceWithTax;

    @ApiModelProperty("未含税金额")
    @Column(name = "amount_no_tax", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '未含税金额'")
    private BigDecimal amountNoTax;

    @ApiModelProperty("含税金额")
    @Column(name = "amount_with_tax", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '含税金额'")
    private BigDecimal amountWithTax;

    @ApiModelProperty("采购类型")
    @Column(name = "is_type_of_purchase_no", length = 40, columnDefinition = "varchar(40) COMMENT '采购类型'")
    private String isTypeOfPurchaseNo;

    @ApiModelProperty("投产比")
    @Column(name = "production_ratio", precision = 10, scale = 4, columnDefinition = "decimal(10,4) COMMENT '投产比'")
    private BigDecimal productionRatio;

    @ApiModelProperty("购买方式(陈列方案前端用)")
    @Column(name = "buy_way", length = 20, columnDefinition = "varchar(20) COMMENT '购买方式(陈列方案前端用)'")
    private String buyWay;

    @ApiModelProperty("是否档期(陈列方案前端用)")
    @Column(name = "on_schedule_or_not", length= 1, columnDefinition = "varchar(1) COMMENT '是否档期(陈列方案前端用)'")
    private String onScheduleOrNot;

    @ApiModelProperty("月度计划量(陈列方案前端用)")
    @Column(name = "monthly_planned_quantity", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '月度计划量(陈列方案前端用)'")
    private BigDecimal monthlyPlannedQuantity;

    @ApiModelProperty("申请金额")
    @Column(name = "apply_amount", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '申请金额(陈列方案用)'")
    private BigDecimal applyAmount;

    @ApiModelProperty("手续费点数")
    @Column(name = "commission_point", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '手续费点数(陈列方案用)'")
    private BigDecimal commissionPoint;

    @ApiModelProperty("手续费金额")
    @Column(name = "commission_amount", precision = 24, scale = 6, columnDefinition = "decimal(24,6) COMMENT '手续费金额(陈列方案用)'")
    private BigDecimal commissionAmount;

    @ApiModelProperty("门店编码")
    @Column(name = "terminal_code", length = 32, columnDefinition = "varchar(32) COMMENT '门店编码'")
    private String terminalCode;

    @ApiModelProperty("门店名称")
    @Column(name = "terminal_name", length = 200, scale = 6, columnDefinition = "varchar(200) COMMENT '门店名称'")
    private String terminalName;

    @ApiModelProperty("陈列数量")
    @Column(name = "display_quantity", columnDefinition = "DECIMAL(24,6) COMMENT '陈列数量'")
    private BigDecimal displayQuantity;
    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionCode;

    /**
     * 所属销售机构编码
     */
    @ApiModelProperty("所属销售机构编码")
    @Column(name = "sales_institution_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售机构编码'")
    private String salesInstitutionErpCode;

    /**
     * 所属销售机构
     */
    @ApiModelProperty("所属销售机构")
    @Column(name = "sales_institution_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售机构'")
    private String salesInstitutionName;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_erp_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区编码 '")
    private String salesRegionErpCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_code", nullable = true, length = 32, columnDefinition = "VARCHAR(32) COMMENT ' 所属销售大区编码 '")
    private String salesRegionCode;

    @ApiModelProperty("所属销售大区编码")
    @Column(name = "sales_region_name", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT ' 所属销售大区编码 '")
    private String salesRegionName;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_erp_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '所属销售组织(组)编码'")
    private String salesOrgErpCode;

    @ApiModelProperty("所属销售组织(组)编码")
    @Column(name = "sales_org_code", length = 64, columnDefinition = "VARCHAR(64) COMMENT '所属销售组织(组)编码'")
    private String salesOrgCode;


    @ApiModelProperty("所属销售组织(组)名称")
    @Column(name = "sales_org_name", length = 128, columnDefinition = "VARCHAR(128) COMMENT '所属销售组织(组)名称'")
    private String salesOrgName;

    @ApiModelProperty("员工id(人员方案模板用)")
    @Column(name = "employee_id", length = 32, columnDefinition = "VARCHAR(32) COMMENT '员工id(人员方案模板用)'")
    private String employeeId;

    @ApiModelProperty("导购员姓名")
    @Column(name = "name_of_shopping_guide", nullable = true, length = 128, columnDefinition = "VARCHAR(128) COMMENT '导购员姓名 '")
    private String nameOfShoppingGuide;
    @ApiModelProperty("活动场次")
    @Column(name = "activity_event_code", length = 32, columnDefinition = "VARCHAR(32) COMMENT '活动场次(行销方案模板用)'")
    private String activityEventCode;

    @ApiModelProperty("场次名称")
    @Column(name = "activity_event_name", length = 100, columnDefinition = "VARCHAR(100) COMMENT '场次名称(行销方案模板用)'")
    private String activityEventName;

    @ApiModelProperty("合同未税金额")
    @Column(name = "contract_excluding_tax", precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '合同未税金额'")
    private BigDecimal contractExcludingTax;

    @ApiModelProperty("合同含税金额")
    @Column(name = "contract_including_tax", precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '合同含税金额'")
    private BigDecimal contractIncludingTax;

    @ApiModelProperty(value = "* 随车搭赠组合")
    @Column(name = "car_gift_group", length = 32, columnDefinition = "VARCHAR(32) COMMENT '随车搭赠组合'")
    private String carGiftGroup;

    @Column(name = "face_value", length = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '面值'")
    private BigDecimal faceValue;

    @Column(name = "personal_income_tax", precision = 24, scale = 6, columnDefinition = "DECIMAL(24,6) COMMENT '个税金额（元）'")
    private BigDecimal personalIncomeTax;

    @Column(name = "is_break_price", length = 1, columnDefinition = "varchar(1) COMMENT '是否破价，Y是N否'")
    private String isBreakPrice;
    /**
     * 是否回退预算： Y是N否
     */
    @ApiModelProperty(name = "isRollbackBudget", notes = "是否已回退预算", value = "是否回退预算： Y是N否")
    @Column(name = "is_rollback_budget", length = 10, columnDefinition = "VARCHAR(5) COMMENT '是否回退预算： Y是N否'")
    private String isRollbackBudget;


    @ApiModelProperty("搭赠类型")
    @Column(name = "bonus_type", nullable = true, length = 1, columnDefinition = "varchar(1) COMMENT '搭赠类型'")
    private String bonusType;

















    /*========================================副表中的字段========================================================*/

    /**
     * 政策支持
     */
    @ApiModelProperty("政策支持")
    @Transient
    @TableField(exist = false)
    private String promotionSupport;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("组合品编码")
    @Transient
    @TableField(exist = false)
    private String productCode2;
    /**
     * 组合品名称
     */
    @ApiModelProperty("组合品名称")
    @Transient
    @TableField(exist = false)
    private String productName2;

    @ApiModelProperty("承接总部方案力度")
    @Transient
    @TableField(exist = false)
    private String headPlanIntensity;

    @ApiModelProperty("关联上级方案，是否完全承接")
    @Transient
    @TableField(exist = false)
    private String headMonthBudgetFullAccept;

    @ApiModelProperty("关联策略，是否完全承接")
    @Transient
    @TableField(exist = false)
    private String monthBudgetFullAccept;

    /**
     * 关联总部策略编码
     */
    @ApiModelProperty("关联总部策略编码")
    @Transient
    @TableField(exist = false)
    private String relateHeadStrategyCode;

    /**
     * 关联总部策略明细编码
     */
    @ApiModelProperty("关联总部策略明细编码")
    @Transient
    @TableField(exist = false)
    private String relateHeadStrategyItemCode;

    /**
     * 是否大日期
     */
    @ApiModelProperty("是否大日期")
    @Transient
    @TableField(exist = false)
    private String isBigDate;

    @ApiModelProperty(name = "employeeCode", notes = "员工号")
    @Transient
    @TableField(exist = false)
    private String employeeCode;

    @ApiModelProperty("是否完全结案")
    @Column(name = "whole_audit", length = 10, columnDefinition = "VARCHAR(10) COMMENT '是否完全结案'")
    private String wholeAudit;

    /**
     * 已结案金额
     */
    @ApiModelProperty("已结案金额")
    @Column(name = "already_audit_amount", columnDefinition = "DECIMAL(24,6) COMMENT '已结案金额'")
    private BigDecimal alreadyAuditAmount;

    /**
     * 调整前版本号
     */
    @ApiModelProperty("调整前变更编码")
    @Column(name = "curr_modify_business_code", nullable = true, length = 32, columnDefinition = "varchar(32) COMMENT '调整前版本号'")
    private String currModifyBusinessCode;

    /**
     * 销售组织erp编码
     */
    @ApiModelProperty(name = "activityOrgErpCode", notes = "销售组织erp编码")
    @Transient
    @TableField(exist = false)
    private String activityOrgErpCode;


    /*========================================副表中的字段========================================================*/


    /**
     * 集群/职能
     * */
    @ApiModelProperty("集群/职能")
    @Transient
    @TableField(exist = false)
    private String functioned;

    /**
     * 系统主管
     * */
    @ApiModelProperty("系统主管")
    @Transient
    @TableField(exist = false)
    private String systemSupervisor;

    /**
     * 省份
     * */
    @ApiModelProperty("省份")
    @Transient
    @TableField(exist = false)
    private String province;

    /**
     * 联系方式
     * */
    @ApiModelProperty("联系方式")
    @Transient
    @TableField(exist = false)
    private String contactInformation;

    /**
     * 卡片类型
     * */
    @ApiModelProperty("卡片类型")
    @Transient
    @TableField(exist = false)
    private String cardType;

    /**
     * 卡内提数
     * */
    @ApiModelProperty("卡内提数")
    @Transient
    @TableField(exist = false)
    private Integer carnegieNumber;

    /**
     * 姓名
     * */
    @ApiModelProperty("姓名")
    @Transient
    @TableField(exist = false)
    private String milkName;

    /**
     * 职位
     * */
    @ApiModelProperty("职位")
    @Transient
    @TableField(exist = false)
    private String position;

    /**
     * 电话
     * */
    @ApiModelProperty("电话")
    @Transient
    @TableField(exist = false)
    private String telephone;

    /**
     * 大日期盘点数量
     */
    @ApiModelProperty("大日期盘点数量")
    @Transient
    @TableField(exist = false)
    private BigDecimal bigDateQty;

    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    @Transient
    @TableField(exist = false)
    private BigDecimal priceIncludingTax;

    /**
     * 大日期来源
     */
    @ApiModelProperty("大日期来源")
    @Transient
    @TableField(exist = false)
    private String bigDateSource;

    /**
     * GMV（元）
     */
    @ApiModelProperty("GMV（元）")
    @Transient
    @TableField(exist = false)
    private BigDecimal gmv;

    /**
     * 平台
     */
    @ApiModelProperty("平台")
    @Transient
    @TableField(exist = false)
    private String platform;

    @ApiModelProperty("区域细分编码")
    @Transient
    @TableField(exist = false)
    private String activityOrgSubdivisionCode;

    /**
     * 档期名称
     */
    @ApiModelProperty("档期名称")
    @Transient
    @TableField(exist = false)
    private String scheduleName;

    /**
     * 零售商渠道
     */
    @ApiModelProperty("零售商渠道")
    @Transient
    @TableField(exist = false)
    private String retailerChannel;
    /**
     * 库存可用数量
     */
    @ApiModelProperty(name = "inventoryCheckUsableQuantity", notes = "库存可用数量")
    @Transient
    @TableField(exist = false)
    private Integer inventoryCheckUsableQuantity;

}

