package com.biz.crm.tpm.business.activity.plan.local.entity;

import com.baomidou.mybatisplus.annotation.TableName;
import com.biz.crm.business.common.local.entity.TenantEntity;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Getter;
import lombok.Setter;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Index;
import javax.persistence.Table;
import java.math.BigDecimal;

/**
 * 活动方案明细扩展类
 * @author wanghaojia
 * @date 2023/3/5 23:52
 */
@ApiModel(value = "ActivityPlanItemExtend", description = "活动方案明细扩展字段")
@TableName("tpm_activity_plan_item_extend")
@Getter
@Setter
@Entity(name = "tpm_activity_plan_item_extend")
@org.hibernate.annotations.Table(appliesTo = "tpm_activity_plan_item_extend", comment = "活动方案明细扩展字段")
@Table(
        name = "tpm_activity_plan_item_extend",
        indexes = {
                @Index(name = "activity_plan_item_extend_inx1", columnList = "plan_item_code,", unique = false),
                @Index(name = "activity_plan_item_extend_inx2", columnList = "plan_code,", unique = false)
        }
)
public class ActivityPlanItemExtend extends TenantEntity {

    /**
     * 活动方案编码
     */
    @ApiModelProperty("活动方案编码")
    @Column(name = "plan_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案编码'")
    private String planCode;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("活动方案明细编码")
    @Column(name = "plan_item_code", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案明细编码'")
    private String planItemCode;

    /**
     * 政策支持
     */
    @ApiModelProperty("政策支持")
    @Column(name = "promotion_support", length = 128, columnDefinition = "varchar(128) COMMENT '政策支持'")
    private String promotionSupport;
    /**
     * 活动方案明细编码
     */
    @ApiModelProperty("组合品编码")
    @Column(name = "product_code2", length = 32, columnDefinition = "varchar(32) COMMENT '活动方案明细编码'")
    private String productCode2;
    /**
     * 组合品名称
     */
    @ApiModelProperty("组合品名称")
    @Column(name = "product_name2", length = 255, columnDefinition = "varchar(255) COMMENT '活动方案明细编码'")
    private String productName2;

    @ApiModelProperty("是否承接总部方案力度")
    @Column(name = "is_undertaking_intensity", length = 1, columnDefinition = "varchar(1) COMMENT '是否承接总部方案力度'")
    private String isUndertakingIntensity;

    /**
     * 关联总部策略编码
     */
    @ApiModelProperty("关联总部策略编码")
    @Column(name = "relate_head_strategy_code", length = 32, columnDefinition = "varchar(32) COMMENT '是否承接总部方案力度'")
    private String relateHeadStrategyCode;

    /**
     * 关联总部策略明细编码
     */
    @ApiModelProperty("关联总部策略明细编码")
    @Column(name = "relate_head_strategy_item_code", length = 32, columnDefinition = "varchar(32) COMMENT '是否承接总部方案力度'")
    private String relateHeadStrategyItemCode;


    /**
     * 是否大日期
     */
    @ApiModelProperty("是否大日期")
    @Column(name = "is_big_date", columnDefinition = "varchar(1) COMMENT '是否大日期'")
    private String isBigDate;

    @ApiModelProperty(name = "employeeCode", notes = "员工号")
    @Column(name = "employee_code", columnDefinition = "varchar(64) COMMENT '员工号'")
    private String employeeCode;

    /**
     * 销售组织erp编码
     */
    @ApiModelProperty(name = "activityOrgErpCode", notes = "销售组织erp编码")
    @Column(name = "activity_org_erp_code", length = 32, columnDefinition = "varchar(32) COMMENT '销售组织erp编码'")
    private String activityOrgErpCode;

    /**
     * 集群/职能
     * */
    @ApiModelProperty("集群/职能")
    @Column(name = "functioned", length = 32,columnDefinition = "varchar(32) COMMENT '集群/职能'")
    private String functioned;

    /**
     * 系统主管
     * */
    @ApiModelProperty("系统主管")
    @Column(name = "system_supervisor", length = 32,columnDefinition = "varchar(32) COMMENT '系统主管'")
    private String systemSupervisor;

    /**
     * 省份
     * */
    @ApiModelProperty("省份")
    @Column(name = "province", length = 64,columnDefinition = "varchar(64) COMMENT '省份'")
    private String province;

    /**
     * 联系方式
     * */
    @ApiModelProperty("联系方式")
    @Column(name = "contact_information", length = 64,columnDefinition = "varchar(64) COMMENT '联系方式'")
    private String contactInformation;


    /**
     * 卡片类型
     * */
    @ApiModelProperty("卡片类型")
    @Column(name = "card_type", length = 32,columnDefinition = "varchar(32) COMMENT '卡片类型'")
    private String cardType;

    /**
     * 卡内提数
     * */
    @ApiModelProperty("卡内提数")
    @Column(name = "carnegie_number", length = 12,columnDefinition = "int(12) COMMENT '卡内提数'")
    private Integer carnegieNumber;

    /**
     * 姓名
     * */
    @ApiModelProperty("姓名")
    @Column(name = "milk_name", length = 32,columnDefinition = "varchar(32) COMMENT '姓名'")
    private String milkName;

    /**
     * 职位
     * */
    @ApiModelProperty("职位")
    @Column(name = "position", length = 32,columnDefinition = "varchar(32) COMMENT '职位'")
    private String position;

    /**
     * 电话
     * */
    @ApiModelProperty("电话")
    @Column(name = "telephone", length = 32,columnDefinition = "varchar(32) COMMENT '电话'")
    private String telephone;


    /**
     * 含税单价
     */
    @ApiModelProperty("含税单价")
    @Column(name = "price_including_tax", length = 24, columnDefinition = "decimal(24,6) COMMENT '含税单价'")
    private BigDecimal priceIncludingTax;

    /**
     * 大日期盘点数量
     */
    @ApiModelProperty("大日期盘点数量")
    @Column(name = "big_date_qty", length = 24, columnDefinition = "decimal(24,6) COMMENT '大日期盘点数量'")
    private BigDecimal bigDateQty;

    /**
     * 大日期来源
     */
    @ApiModelProperty("大日期来源")
    @Column(name = "big_date_source", length = 32,columnDefinition = "varchar(32) COMMENT '大日期来源'")
    private String bigDateSource;

    /**
     * GMV（元）
     */
    @ApiModelProperty("GMV（元）")
    @Column(name = "gmv", length = 24, columnDefinition = "decimal(24,6) COMMENT 'GMV（元）'")
    private BigDecimal gmv;

    /**
     * 平台
     */
    @ApiModelProperty("平台")
    @Column(name = "platform", length = 255, columnDefinition = "varchar(255) COMMENT '平台'")
    private String platform;

    /**
     * 区域细分编码
     */
    @ApiModelProperty("区域细分编码")
    @Column(name = "activity_org_subdivision_code", length = 32, columnDefinition = "varchar(32) COMMENT '区域细分编码'")
    private String activityOrgSubdivisionCode;

    /**
     * 档期名称
     */
    @ApiModelProperty("档期名称")
    @Column(name = "schedule_name", length = 128, columnDefinition = "varchar(128) COMMENT 'schedule_name'")
    private String scheduleName;

    @ApiModelProperty("推送sap状态标记")
    @Column(name = "sap_interface_state", length = 2, columnDefinition = "VARCHAR(2) COMMENT '推送sap状态标记'")
    private String sapInterfaceState;

    /**
     * 零售商渠道
     */
    @ApiModelProperty("零售商渠道")
    @Column(name = "retailer_channel", length = 64, columnDefinition = "varchar(64) COMMENT 'retailer_channel'")
    private String retailerChannel;

    /**
     * 库存可用数量
     */
    @ApiModelProperty(name = "inventoryCheckUsableQuantity", notes = "库存可用数量")
    @Column(name = "inventory_check_usable_quantity", columnDefinition = "int(12) COMMENT '库存可用数量'")
    private Integer inventoryCheckUsableQuantity;

}
